/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator.ui;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.esa.snap.SnapCoreActivator;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.smart.configurator.Benchmark;
import org.esa.snap.smart.configurator.BenchmarkOperatorProvider;
import org.esa.snap.smart.configurator.BenchmarkSingleCalculus;
import org.esa.snap.smart.configurator.ConfigurationOptimizer;
import org.esa.snap.smart.configurator.JavaSystemInfos;
import org.esa.snap.smart.configurator.PerformanceParameters;
import org.esa.snap.smart.configurator.VMParameters;
import org.esa.snap.smart.configurator.ui.BenchmarkDialog;
import org.esa.snap.smart.configurator.ui.LineSplitTextEditDialog;
import org.esa.snap.smart.configurator.ui.PerformanceOptionsPanelController;
import org.esa.snap.ui.AppContext;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class PerformancePanel
extends JPanel {
    private static final Color CURRENT_VALUES_COLOR = Color.BLACK;
    private static final Color ERROR_VALUES_COLOR = Color.RED;
    private static final String BENCHMARK_SEPARATOR = ";";
    private static final int nbCores = JavaSystemInfos.getInstance().getNbCPUs();
    private final ConfigurationOptimizer confOptimizer;
    private final PerformanceOptionsPanelController controller;
    private JTextField benchmarkCacheSizeTextField;
    private JTextField benchmarkNbThreadsTextField;
    private JTextField benchmarkTileSizeTextField;
    private JButton editVMParametersButton;
    private JButton browseUserDirButton;
    private JLabel cacheSizeLabel;
    private JTextField cacheSizeTextField;
    private JTextField defaultTileSizeTextField;
    private JLabel jLabel1;
    private JLabel cachePathLabel;
    private JLabel vmParametersLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel largeCacheInfoLabel;
    private JLabel nbThreadsLabel;
    private JTextField nbThreadsTextField;
    private JComboBox procGraphJComboBox;
    private JPanel processingParametersPanel;
    private JButton processingParamsComputeButton;
    private JButton processingParamsResetButton;
    private JButton sysComputeButton;
    private JButton sysResetButton;
    private JPanel systemParametersPanel;
    private JLabel tileWidthLabel;
    private JTextField cachePathTextField;
    private JLabel vmParametersInfoLabel;
    private JTextField vmParametersTextField;

    private static Path getUserDirPathFromString(String userDirString) {
        Path userDirPath = null;
        try {
            File userDirAsFile = new File(userDirString);
            userDirPath = FileUtils.getPathFromURI((URI)userDirAsFile.toURI());
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.WARNING, "Cannot convert performance parameters to PATH: {0}", userDirString);
        }
        return userDirPath;
    }

    PerformancePanel(final PerformanceOptionsPanelController controller) {
        this.controller = controller;
        this.confOptimizer = ConfigurationOptimizer.getInstance();
        this.initComponents();
        DocumentListener textFieldListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                controller.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                controller.changed();
            }
        };
        this.vmParametersTextField.getDocument().addDocumentListener(textFieldListener);
        this.cachePathTextField.getDocument().addDocumentListener(textFieldListener);
        this.nbThreadsTextField.getDocument().addDocumentListener(textFieldListener);
        this.defaultTileSizeTextField.getDocument().addDocumentListener(textFieldListener);
        this.cacheSizeTextField.getDocument().addDocumentListener(textFieldListener);
    }

    private void initComponents() {
        this.systemParametersPanel = new JPanel();
        this.cachePathLabel = new JLabel();
        this.vmParametersTextField = new JTextField();
        this.editVMParametersButton = new JButton();
        this.cachePathTextField = new JTextField();
        this.browseUserDirButton = new JButton();
        this.vmParametersLabel = new JLabel();
        this.sysResetButton = new JButton();
        this.sysComputeButton = new JButton();
        this.largeCacheInfoLabel = new JLabel();
        this.vmParametersInfoLabel = new JLabel();
        this.processingParametersPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.tileWidthLabel = new JLabel();
        this.cacheSizeLabel = new JLabel();
        this.nbThreadsLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.defaultTileSizeTextField = new JTextField();
        this.cacheSizeTextField = new JTextField();
        this.nbThreadsTextField = new JTextField();
        this.jPanel4 = new JPanel();
        this.benchmarkTileSizeTextField = new JTextField();
        this.benchmarkCacheSizeTextField = new JTextField();
        this.benchmarkNbThreadsTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.procGraphJComboBox = new JComboBox<Object>(this.getBenchmarkOperators());
        this.jPanel3 = new JPanel();
        this.processingParamsComputeButton = new JButton();
        this.processingParamsResetButton = new JButton();
        BoxLayout perfPanelLayout = new BoxLayout(this, 1);
        this.setLayout(perfPanelLayout);
        Box.createVerticalGlue();
        this.systemParametersPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.systemParametersPanel.border.title")));
        this.systemParametersPanel.setMinimumSize(new Dimension(283, 115));
        this.systemParametersPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.cachePathLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.jLabel2.text"));
        this.cachePathLabel.setMaximumSize(new Dimension(100, 14));
        this.cachePathLabel.setPreferredSize(new Dimension(80, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.systemParametersPanel.add((Component)this.cachePathLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.vmParametersLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.jLabel3.text"));
        this.vmParametersLabel.setMaximumSize(new Dimension(200, 14));
        this.vmParametersLabel.setMinimumSize(new Dimension(100, 14));
        this.vmParametersLabel.setPreferredSize(new Dimension(80, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.systemParametersPanel.add((Component)this.vmParametersLabel, gridBagConstraints);
        this.vmParametersTextField.setText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.vmParametersTextField.text"));
        this.vmParametersTextField.setToolTipText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.vmParametersTextField.toolTipText"));
        if (!VMParameters.canSave()) {
            this.vmParametersTextField.setEditable(false);
        }
        this.vmParametersTextField.setColumns(50);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.systemParametersPanel.add((Component)this.vmParametersTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editVMParametersButton, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.editVMParametersButton.text"));
        this.editVMParametersButton.addActionListener(this::editVMParametersButtonActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 0, 10);
        this.systemParametersPanel.add((Component)this.editVMParametersButton, gridBagConstraints);
        if (!VMParameters.canSave()) {
            this.vmParametersLabel.setEnabled(false);
            this.vmParametersTextField.setEnabled(false);
            this.editVMParametersButton.setEnabled(false);
            String vmParameterDisableToolTip = "VM parameters can't be saved from SNAP, please use the snap-conf-optimiser application as an administrator to change them";
            this.vmParametersLabel.setToolTipText(vmParameterDisableToolTip);
            this.vmParametersTextField.setToolTipText(vmParameterDisableToolTip);
            this.editVMParametersButton.setToolTipText(vmParameterDisableToolTip);
        }
        this.cachePathTextField.setText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.userDirTextField.text"));
        this.cachePathTextField.setToolTipText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.userDirTextField.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.systemParametersPanel.add((Component)this.cachePathTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseUserDirButton, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.browseUserDirButton.text"));
        this.browseUserDirButton.addActionListener(evt -> this.browseCachePathButtonActionPerformed());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 0, 10);
        this.systemParametersPanel.add((Component)this.browseUserDirButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.sysResetButton, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.sysResetButton.text"));
        this.sysResetButton.addActionListener(evt -> this.sysResetButtonActionPerformed());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 3, 0, 10);
        this.systemParametersPanel.add((Component)this.sysResetButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.sysComputeButton, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.sysComputeButton.text"));
        this.sysComputeButton.addActionListener(evt -> this.sysComputeButtonActionPerformed());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 3);
        this.systemParametersPanel.add((Component)this.sysComputeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.largeCacheInfoLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.largeCacheInfoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.systemParametersPanel.add((Component)this.largeCacheInfoLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.vmParametersInfoLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.vmParametersInfoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.systemParametersPanel.add((Component)this.vmParametersInfoLabel, gridBagConstraints);
        this.add(this.systemParametersPanel);
        Box.createVerticalGlue();
        this.processingParametersPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.border.title")));
        this.processingParametersPanel.setName("");
        this.processingParametersPanel.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridLayout(3, 0, 0, 15));
        Mnemonics.setLocalizedText((JLabel)this.tileWidthLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.tileWidthLabel.text"));
        this.tileWidthLabel.setMaximumSize(new Dimension(120, 14));
        this.tileWidthLabel.setPreferredSize(new Dimension(100, 14));
        this.jPanel2.add(this.tileWidthLabel);
        Mnemonics.setLocalizedText((JLabel)this.cacheSizeLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.cacheSizeLabel.text"));
        this.cacheSizeLabel.setMaximumSize(new Dimension(100, 14));
        this.cacheSizeLabel.setPreferredSize(new Dimension(80, 14));
        this.jPanel2.add(this.cacheSizeLabel);
        Mnemonics.setLocalizedText((JLabel)this.nbThreadsLabel, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.nbThreadsLabel.text"));
        this.nbThreadsLabel.setMaximumSize(new Dimension(100, 14));
        this.jPanel2.add(this.nbThreadsLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.processingParametersPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.jPanel1.border.title")));
        this.jPanel1.setMinimumSize(new Dimension(100, 100));
        this.jPanel1.setLayout(new GridLayout(3, 1, 0, 10));
        this.defaultTileSizeTextField.setText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.defaultTileSizeTextField.text"));
        this.defaultTileSizeTextField.setMinimumSize(new Dimension(100, 20));
        this.defaultTileSizeTextField.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.add(this.defaultTileSizeTextField);
        this.cacheSizeTextField.setText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.cacheSizeTextField.text"));
        this.cacheSizeTextField.setMinimumSize(new Dimension(100, 20));
        this.cacheSizeTextField.setName("");
        this.cacheSizeTextField.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.add(this.cacheSizeTextField);
        this.nbThreadsTextField.setText(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.nbThreadsTextField.text"));
        this.nbThreadsTextField.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.add(this.nbThreadsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.processingParametersPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.jPanel4.border.title")));
        this.jPanel4.setMinimumSize(new Dimension(190, 107));
        this.jPanel4.setLayout(new GridLayout(3, 1, 0, 10));
        PerformanceParameters actualParameters = this.confOptimizer.getActualPerformanceParameters();
        String tileSizeBenchmarkValues = this.getDefaultTileSizeValuesForBenchmark(actualParameters.getDefaultTileSize());
        this.benchmarkTileSizeTextField.setText(tileSizeBenchmarkValues);
        this.benchmarkTileSizeTextField.setPreferredSize(new Dimension(150, 20));
        this.jPanel4.add(this.benchmarkTileSizeTextField);
        String cacheSizeBenchmarkValues = this.getDefaultCacheSizeValuesForBenchmark(actualParameters);
        this.benchmarkCacheSizeTextField.setText(cacheSizeBenchmarkValues);
        this.benchmarkCacheSizeTextField.setMinimumSize(new Dimension(100, 20));
        this.benchmarkCacheSizeTextField.setName("");
        this.benchmarkCacheSizeTextField.setPreferredSize(new Dimension(150, 20));
        this.jPanel4.add(this.benchmarkCacheSizeTextField);
        this.benchmarkNbThreadsTextField.setText(Integer.toString(actualParameters.getNbThreads()) + BENCHMARK_SEPARATOR);
        this.benchmarkNbThreadsTextField.setPreferredSize(new Dimension(150, 20));
        this.jPanel4.add(this.benchmarkNbThreadsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.processingParametersPanel.add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.processingParametersPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.procGraphJComboBox.setMinimumSize(new Dimension(180, 22));
        this.nbThreadsTextField.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.processingParametersPanel.add((Component)this.procGraphJComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.processingParamsComputeButton, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.text"));
        this.processingParamsComputeButton.setName("");
        this.processingParamsComputeButton.addActionListener(this::processingParamsComputeButtonActionPerformed);
        this.jPanel3.add(this.processingParamsComputeButton);
        Mnemonics.setLocalizedText((AbstractButton)this.processingParamsResetButton, (String)NbBundle.getMessage(PerformancePanel.class, (String)"PerformancePanel.processingParamsResetButton.text"));
        this.processingParamsResetButton.addActionListener(this::processingParamsResetButtonActionPerformed);
        this.jPanel3.add(this.processingParamsResetButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.processingParametersPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.add(this.processingParametersPanel);
    }

    private String getDefaultTileSizeValuesForBenchmark(int defaultTileSize) {
        StringBuilder defaultTileSizeValues = new StringBuilder();
        if (defaultTileSize >= 1024) {
            defaultTileSizeValues.append(defaultTileSize / 2);
            defaultTileSizeValues.append(BENCHMARK_SEPARATOR);
        }
        defaultTileSizeValues.append(defaultTileSize);
        defaultTileSizeValues.append(BENCHMARK_SEPARATOR);
        defaultTileSizeValues.append(defaultTileSize * 2);
        defaultTileSizeValues.append(BENCHMARK_SEPARATOR);
        if (defaultTileSize < 1024) {
            defaultTileSizeValues.append(defaultTileSize * 4);
            defaultTileSizeValues.append(BENCHMARK_SEPARATOR);
        }
        return defaultTileSizeValues.toString();
    }

    private String getDefaultCacheSizeValuesForBenchmark(PerformanceParameters actualParameters) {
        StringBuilder defaultCacheSizeValues = new StringBuilder();
        int defaultCacheSize = actualParameters.getCacheSize();
        long xmx = actualParameters.getVmXMX();
        if (xmx == 0L) {
            PerformanceParameters memoryParameters = new PerformanceParameters();
            ConfigurationOptimizer.getInstance().computeOptimisedRAMParams(memoryParameters);
            xmx = memoryParameters.getVmXMX();
        }
        defaultCacheSizeValues.append(defaultCacheSize);
        defaultCacheSizeValues.append(BENCHMARK_SEPARATOR);
        if (xmx != 0L) {
            defaultCacheSizeValues.append(Math.round((double)xmx * 0.5));
            defaultCacheSizeValues.append(BENCHMARK_SEPARATOR);
            defaultCacheSizeValues.append(Math.round((double)xmx * 0.75));
            defaultCacheSizeValues.append(BENCHMARK_SEPARATOR);
        }
        return defaultCacheSizeValues.toString();
    }

    private void editVMParametersButtonActionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Window window = null;
        if (source instanceof Component) {
            Component component = (Component)source;
            window = SwingUtilities.getWindowAncestor(component);
        }
        String vmParametersAsBlankSeparatedString = this.vmParametersTextField.getText();
        LineSplitTextEditDialog vmParamsEditDialog = new LineSplitTextEditDialog(window, vmParametersAsBlankSeparatedString, " ", "VM Parameters", VMParameters.canSave());
        vmParamsEditDialog.show();
        this.vmParametersTextField.setText(vmParamsEditDialog.getTextWithSeparators());
        this.controller.changed();
    }

    private Object[] getBenchmarkOperators() {
        GPF gpf = GPF.getDefaultInstance();
        if (gpf.getOperatorSpiRegistry().getOperatorSpis().isEmpty()) {
            gpf.getOperatorSpiRegistry().loadOperatorSpis();
        }
        ServiceRegistry benchemarkOperatorServiceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(BenchmarkOperatorProvider.class);
        SnapCoreActivator.loadServices((ServiceRegistry)benchemarkOperatorServiceRegistry);
        Set providers = benchemarkOperatorServiceRegistry.getServices();
        TreeSet<String> externalOperatorsAliases = new TreeSet<String>();
        for (BenchmarkOperatorProvider provider : providers) {
            Set operatorSpis = provider.getBenchmarkOperators();
            for (OperatorSpi operatorSpi : operatorSpis) {
                externalOperatorsAliases.add(operatorSpi.getOperatorAlias());
            }
        }
        return externalOperatorsAliases.toArray();
    }

    private void sysResetButtonActionPerformed() {
        this.setSystemPerformanceParametersToActualValues();
    }

    private void sysComputeButtonActionPerformed() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        PerformanceParameters optimizedParameters = this.confOptimizer.computeOptimisedSystemParameters();
        if (VMParameters.canSave() && !this.vmParametersTextField.getText().equals(optimizedParameters.getVMParameters())) {
            this.vmParametersTextField.setText(optimizedParameters.getVMParameters());
            this.vmParametersTextField.setForeground(CURRENT_VALUES_COLOR);
            this.vmParametersTextField.setCaretPosition(0);
        }
        if (!this.cachePathTextField.getText().equals(optimizedParameters.getCachePath().toString())) {
            this.cachePathTextField.setText(optimizedParameters.getCachePath().toString());
            this.cachePathTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.controller.changed();
    }

    private void browseCachePathButtonActionPerformed() {
        JFileChooser fileChooser = new JFileChooser(this.cachePathTextField.getText());
        fileChooser.setFileSelectionMode(1);
        int returnValue = fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            File selectedDir = fileChooser.getSelectedFile();
            this.cachePathTextField.setText(selectedDir.getAbsolutePath());
            this.cachePathTextField.setForeground(CURRENT_VALUES_COLOR);
            this.controller.changed();
        }
    }

    private void processingParamsComputeButtonActionPerformed(ActionEvent evt) {
        if (this.validCompute()) {
            ArrayList<Integer> tileSizesList = new ArrayList<Integer>();
            ArrayList<Integer> cacheSizesList = new ArrayList<Integer>();
            ArrayList<Integer> nbThreadsList = new ArrayList<Integer>();
            for (String tileSize : StringUtils.split((String)this.benchmarkTileSizeTextField.getText(), (char)';')) {
                tileSizesList.add(Integer.parseInt(tileSize));
            }
            for (String cacheSize : StringUtils.split((String)this.benchmarkCacheSizeTextField.getText(), (char)';')) {
                cacheSizesList.add(Integer.parseInt(cacheSize));
            }
            for (String nbThread : StringUtils.split((String)this.benchmarkNbThreadsTextField.getText(), (char)';')) {
                nbThreadsList.add(Integer.parseInt(nbThread));
            }
            Benchmark benchmarkModel = new Benchmark(tileSizesList, cacheSizesList, nbThreadsList);
            String opName = this.procGraphJComboBox.getSelectedItem().toString();
            AppContext appContext = SnapApp.getDefault().getAppContext();
            BenchmarkDialog productDialog = new BenchmarkDialog(this, opName, benchmarkModel, appContext);
            productDialog.show();
        }
    }

    private void processingParamsResetButtonActionPerformed(ActionEvent evt) {
        this.setProcessingPerformanceParametersToActualValues();
    }

    void load() {
        this.setSystemPerformanceParametersToActualValues();
        this.setProcessingPerformanceParametersToActualValues();
    }

    void updatePerformanceParameters(BenchmarkSingleCalculus benchmarkSingleCalcul) {
        this.defaultTileSizeTextField.setText(Integer.toString(benchmarkSingleCalcul.getTileSize()));
        this.defaultTileSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        this.cacheSizeTextField.setText(Integer.toString(benchmarkSingleCalcul.getCacheSize()));
        this.cacheSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        this.nbThreadsTextField.setText(Integer.toString(benchmarkSingleCalcul.getNbThreads()));
        this.nbThreadsTextField.setForeground(CURRENT_VALUES_COLOR);
        this.controller.changed();
    }

    void store() {
        if (this.valid()) {
            PerformanceParameters updatedPerformanceParams = this.getPerformanceParameters();
            this.confOptimizer.updateCustomisedParameters(updatedPerformanceParams);
            try {
                this.confOptimizer.saveCustomisedParameters();
            }
            catch (IOException | BackingStoreException e) {
                SystemUtils.LOG.severe("Could not save performance parameters: " + e.getMessage());
                this.setSystemPerformanceParametersToActualValues();
            }
        }
    }

    private PerformanceParameters getPerformanceParameters() {
        PerformanceParameters parameters = new PerformanceParameters();
        parameters.setVMParameters(this.vmParametersTextField.getText());
        Path userDirPath = PerformancePanel.getUserDirPathFromString(this.cachePathTextField.getText());
        parameters.setCachePath(userDirPath);
        parameters.setDefaultTileSize(Integer.parseInt(this.defaultTileSizeTextField.getText()));
        parameters.setCacheSize(Integer.parseInt(this.cacheSizeTextField.getText()));
        parameters.setNbThreads(Integer.parseInt(this.nbThreadsTextField.getText()));
        return parameters;
    }

    boolean valid() {
        boolean isValid = true;
        File userDir = new File(this.cachePathTextField.getText());
        if (userDir.exists() && !userDir.isDirectory()) {
            this.cachePathTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        } else {
            this.cachePathTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        String defaultTileSize = this.defaultTileSizeTextField.getText();
        try {
            Integer.parseInt(defaultTileSize);
            this.defaultTileSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        catch (NumberFormatException ex) {
            this.defaultTileSizeTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        }
        String readerCacheSize = this.cacheSizeTextField.getText();
        try {
            Integer.parseInt(readerCacheSize);
            this.cacheSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        catch (NumberFormatException ex) {
            this.cacheSizeTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        }
        String nbThreadsString = this.nbThreadsTextField.getText();
        try {
            int nbThreads = Integer.parseUnsignedInt(nbThreadsString);
            if (nbThreads > nbCores) {
                this.nbThreadsTextField.setForeground(ERROR_VALUES_COLOR);
                isValid = false;
            } else {
                this.nbThreadsTextField.setForeground(CURRENT_VALUES_COLOR);
            }
        }
        catch (NumberFormatException ex) {
            this.nbThreadsTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        }
        return isValid;
    }

    private boolean validCompute() {
        boolean isValid = true;
        Pattern patternBenchmarkValues = Pattern.compile("([0-9]+[\\;]*)+");
        if (!patternBenchmarkValues.matcher(this.benchmarkTileSizeTextField.getText()).matches()) {
            this.benchmarkTileSizeTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        } else {
            this.benchmarkTileSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        if (!patternBenchmarkValues.matcher(this.benchmarkCacheSizeTextField.getText()).matches()) {
            this.benchmarkCacheSizeTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        } else {
            this.benchmarkCacheSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        if (!patternBenchmarkValues.matcher(this.benchmarkNbThreadsTextField.getText()).matches() || !this.validBenchmarkNbThreads()) {
            this.benchmarkNbThreadsTextField.setForeground(ERROR_VALUES_COLOR);
            isValid = false;
        } else {
            this.benchmarkNbThreadsTextField.setForeground(CURRENT_VALUES_COLOR);
        }
        return isValid;
    }

    private boolean validBenchmarkNbThreads() {
        boolean valid = true;
        for (String nbThread : StringUtils.split((String)this.benchmarkNbThreadsTextField.getText(), (char)';')) {
            try {
                if (Integer.parseInt(nbThread) <= nbCores) continue;
                valid = false;
            }
            catch (NumberFormatException e) {
                valid = false;
            }
            break;
        }
        return valid;
    }

    private void setSystemPerformanceParametersToActualValues() {
        PerformanceParameters actualPerformanceParameters = this.confOptimizer.getActualPerformanceParameters();
        this.vmParametersTextField.setText(actualPerformanceParameters.getVMParameters());
        this.vmParametersTextField.setForeground(CURRENT_VALUES_COLOR);
        this.vmParametersTextField.setCaretPosition(0);
        this.cachePathTextField.setText(actualPerformanceParameters.getCachePath().toString());
        this.cachePathTextField.setForeground(CURRENT_VALUES_COLOR);
    }

    private void setProcessingPerformanceParametersToActualValues() {
        PerformanceParameters actualPerformanceParameters = this.confOptimizer.getActualPerformanceParameters();
        this.defaultTileSizeTextField.setText(Integer.toString(actualPerformanceParameters.getDefaultTileSize()));
        this.defaultTileSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        this.cacheSizeTextField.setText(Integer.toString(actualPerformanceParameters.getCacheSize()));
        this.cacheSizeTextField.setForeground(CURRENT_VALUES_COLOR);
        this.nbThreadsTextField.setText(Integer.toString(actualPerformanceParameters.getNbThreads()));
        this.nbThreadsTextField.setForeground(CURRENT_VALUES_COLOR);
    }
}

