/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import org.esa.snap.runtime.Engine;
import org.junit.Assert;
import org.junit.Test;

public class EngineTest {
    @Test
    public void testIllegalStateException() throws Exception {
        Engine engine = Engine.start((boolean)false);
        engine.stop();
        try {
            engine.getClientClassLoader();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("start()"));
        }
        try {
            engine.setContextClassLoader();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("start()"));
        }
        try {
            engine.runClientCode(() -> {});
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("start()"));
        }
        try {
            engine.createClientRunnable(() -> {});
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("start()"));
        }
    }

    @Test
    public void testIllegalStateExceptionDeferred() throws Exception {
        Engine engine = Engine.start((boolean)false);
        Runnable clientRunnable = engine.createClientRunnable(() -> {});
        engine.stop();
        try {
            clientRunnable.run();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("start()"));
        }
    }
}

