/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import org.esa.snap.runtime.EngineConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EngineConfigTest {
    @Before
    public void setUp() throws Exception {
        EngineConfig.instance().clear();
        System.getProperties().stringPropertyNames().stream().filter(name -> name.startsWith("snap.")).forEach(System::clearProperty);
    }

    @Test
    public void testDefaults() throws Exception {
        Assert.assertFalse((boolean)EngineConfig.instance().loaded());
        Assert.assertFalse((boolean)EngineConfig.instance().debug());
        Assert.assertFalse((boolean)EngineConfig.instance().ignoreUserConfig());
        Assert.assertFalse((boolean)EngineConfig.instance().ignoreDefaultConfig());
        Assert.assertArrayEquals((Object[])EngineConfig.DEFAULT_EXCLUDED_CLUSTER_NAMES, (Object[])EngineConfig.instance().excludedClusterNames());
        Assert.assertArrayEquals((Object[])EngineConfig.DEFAULT_EXCLUDED_MODULE_NAMES, (Object[])EngineConfig.instance().excludedModuleNames());
        Assert.assertEquals((Object)Paths.get(System.getProperty("user.dir"), new String[0]), (Object)EngineConfig.instance().installDir());
        Assert.assertEquals((Object)Paths.get(System.getProperty("user.home"), ".snap"), (Object)EngineConfig.instance().userDir());
        Assert.assertNull((Object)EngineConfig.instance().configFile());
    }

    @Test
    public void testSetters() throws Exception {
        EngineConfig.instance().debug(true).ignoreUserConfig(true).ignoreDefaultConfig(true).excludedClusterNames(new String[]{"s2tbx", "s3tbx", "smos"}).excludedModuleNames(new String[]{"a", "b", "c"}).installDir(Paths.get("/opt/snap2", new String[0])).userDir(Paths.get("/home/bar", new String[0])).configFile(Paths.get("./test.properties", new String[0]));
        Assert.assertTrue((boolean)EngineConfig.instance().debug());
        Assert.assertTrue((boolean)EngineConfig.instance().ignoreUserConfig());
        Assert.assertTrue((boolean)EngineConfig.instance().ignoreDefaultConfig());
        Assert.assertArrayEquals((Object[])new String[]{"s2tbx", "s3tbx", "smos"}, (Object[])EngineConfig.instance().excludedClusterNames());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])EngineConfig.instance().excludedModuleNames());
        Assert.assertEquals((Object)Paths.get("/opt/snap2", new String[0]), (Object)EngineConfig.instance().installDir());
        Assert.assertEquals((Object)Paths.get("/home/bar", new String[0]), (Object)EngineConfig.instance().userDir());
        Assert.assertEquals((Object)Paths.get("./test.properties", new String[0]), (Object)EngineConfig.instance().configFile());
    }

    @Test
    public void testLoadWithDefaults() throws Exception {
        EngineConfig.instance().load();
        Assert.assertTrue((boolean)EngineConfig.instance().loaded());
        Assert.assertFalse((boolean)EngineConfig.instance().debug());
        Assert.assertFalse((boolean)EngineConfig.instance().ignoreUserConfig());
        Assert.assertFalse((boolean)EngineConfig.instance().ignoreDefaultConfig());
        Assert.assertArrayEquals((Object[])EngineConfig.DEFAULT_EXCLUDED_CLUSTER_NAMES, (Object[])EngineConfig.instance().excludedClusterNames());
        Assert.assertArrayEquals((Object[])EngineConfig.DEFAULT_EXCLUDED_MODULE_NAMES, (Object[])EngineConfig.instance().excludedModuleNames());
        Assert.assertEquals((Object)Paths.get(System.getProperty("user.dir"), new String[0]), (Object)EngineConfig.instance().installDir());
        Assert.assertEquals((Object)Paths.get(System.getProperty("user.home"), ".snap"), (Object)EngineConfig.instance().userDir());
        Assert.assertNull((Object)EngineConfig.instance().configFile());
    }

    @Test
    public void testLoadFromFile() throws Exception {
        Path configFile = Paths.get(EngineConfigTest.class.getResource("test.properties").toURI());
        EngineConfig.instance().configFile(configFile).load();
        Assert.assertTrue((boolean)EngineConfig.instance().debug());
        Assert.assertTrue((boolean)EngineConfig.instance().ignoreUserConfig());
        Assert.assertTrue((boolean)EngineConfig.instance().ignoreDefaultConfig());
        Assert.assertArrayEquals((Object[])new String[]{"s1tbx", "s2tbx", "s3tbx"}, (Object[])EngineConfig.instance().excludedClusterNames());
        Assert.assertArrayEquals((Object[])new String[]{"snap-binning", "org.esa.snap:ceres-jai"}, (Object[])EngineConfig.instance().excludedModuleNames());
        Assert.assertEquals((Object)Paths.get("/opt/snap", new String[0]), (Object)EngineConfig.instance().installDir());
        Assert.assertEquals((Object)Paths.get("/home/foo", new String[0]), (Object)EngineConfig.instance().userDir());
        Assert.assertEquals((Object)configFile, (Object)EngineConfig.instance().configFile());
    }

    @Test
    public void testPreferencesResolution() throws Exception {
        Preferences preferences = EngineConfig.instance().preferences();
        preferences.put("snap.home", "/opt/snap");
        preferences.put("extra-cluster", "bibo");
        preferences.put("cluster-path", "${snap.home}/${extra-cluster}");
        Assert.assertEquals((Object)"/opt/snap/bibo", (Object)preferences.get("cluster-path", null));
        preferences.put("myarch", "${os.arch}");
        Assert.assertNotNull((Object)preferences.get("myarch", null));
        Assert.assertFalse((boolean)preferences.get("myarch", null).contains("${"));
        Assert.assertFalse((boolean)preferences.get("myarch", null).contains("}"));
    }
}

