/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.esa.snap.runtime.EngineConfig;

class EnginePreferences
extends AbstractPreferences {
    private static EnginePreferences root = new EnginePreferences(null, "");
    private Properties properties = new Properties();
    private final String keyPrefix;
    private Path backingStorePath;

    EnginePreferences(String name) {
        this(root, name);
    }

    EnginePreferences(AbstractPreferences parent, String name) {
        super(parent, name);
        this.keyPrefix = name + ".";
    }

    Properties getProperties() {
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    protected void putSpi(String key, String value) {
        String globalValue;
        if (key.startsWith(this.keyPrefix) && (globalValue = System.getProperty(key)) != null) {
            System.setProperty(key, value);
        }
        this.properties.put(key, value);
    }

    @Override
    protected String getSpi(String key) {
        String globalValue;
        if (key.startsWith(this.keyPrefix) && (globalValue = System.getProperty(key)) != null) {
            return this.resolveValue(globalValue);
        }
        return this.resolveKey(key);
    }

    @Override
    protected void removeSpi(String key) {
        String globalValue;
        if (key.startsWith(this.keyPrefix) && (globalValue = System.getProperty(key)) != null) {
            System.clearProperty(key);
        }
        this.properties.remove(key);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.properties.clear();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        Set<String> names = this.properties.stringPropertyNames();
        return names.toArray(new String[names.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return new String[0];
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return null;
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.load();
        this.store();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        this.store();
    }

    private String resolveKey(String key) {
        String value = this.properties.getProperty(key, null);
        return value != null ? this.resolveValue(value) : null;
    }

    private String resolveValue(String value) {
        boolean change;
        int pos1 = 0;
        do {
            String varKey;
            String varValue;
            change = false;
            if ((pos1 = value.indexOf("${", pos1)) < 0) break;
            int pos2 = value.indexOf("}", pos1 + 2);
            if (pos2 == -1 || (varValue = this.getVariableValue(varKey = value.substring(pos1 + 2, pos2))) == null) continue;
            String newValue = value.replace("${" + varKey + "}", varValue);
            change = !newValue.equals(value);
            value = newValue;
        } while (change);
        return value;
    }

    private String getVariableValue(String varKey) {
        String varValue = this.properties.getProperty(varKey);
        if (varValue == null && this.parent() != null) {
            varValue = this.parent().get(varKey, null);
        }
        if (varValue == null) {
            varValue = System.getProperty(varKey, null);
        }
        if (varValue == null) {
            varValue = System.getenv(varKey);
        }
        return varValue;
    }

    private void load() throws BackingStoreException {
        Properties properties = new Properties();
        Path userConfigFile = this.getBackingStorePath();
        try (BufferedReader reader = Files.newBufferedReader(userConfigFile);){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        properties.putAll((Map<?, ?>)this.properties);
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    private void store() throws BackingStoreException {
        Path userConfigFile = this.getBackingStorePath();
        if (!Files.isDirectory(userConfigFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(userConfigFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(userConfigFile, new OpenOption[0]);){
            this.properties.store(bufferedWriter, "SNAP configuration '" + this.name() + "'");
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    public Path getBackingStorePath() {
        return this.backingStorePath != null ? this.backingStorePath : this.getDefaultBackingStorePath();
    }

    public void setBackingStorePath(Path backingStorePath) {
        this.backingStorePath = backingStorePath;
    }

    private Path getDefaultBackingStorePath() {
        return EngineConfig.instance().userDir().resolve("etc").resolve(this.name() + ".properties");
    }
}

