/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.rtp;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.thoughtworks.xstream.XStream;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.core.dataio.AbstractProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.image.ImageHeader;
import org.esa.snap.core.image.TiledFileOpImage;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.rtp.BandDescriptor;
import org.esa.snap.dataio.rtp.ProductDescriptor;
import org.esa.snap.dataio.rtp.RawTiledPyramidsProductCodecSpi;

public class RawTiledPyramidsProductWriter
extends AbstractProductWriter {
    private File headerFile;
    private HashSet<Band> writtenBands;
    private final ProductNodeHandler productNodeHandler = new ProductNodeHandler();

    public RawTiledPyramidsProductWriter(RawTiledPyramidsProductCodecSpi spi) {
        super((ProductWriterPlugIn)spi);
    }

    protected void writeProductNodesImpl() throws IOException {
        this.headerFile = RawTiledPyramidsProductCodecSpi.getHeaderFile(this.getOutput());
        this.writtenBands = new HashSet(31);
        Product product = this.getSourceProduct();
        product.addProductNodeListener((ProductNodeListener)this.productNodeHandler);
        ProductDescriptor productDescriptor = this.createProductDescriptor(product);
        XStream xStream = RawTiledPyramidsProductCodecSpi.createXStream();
        File productDir = this.headerFile.getParentFile();
        if (productDir != null && !productDir.exists() && !productDir.mkdirs()) {
            throw new IOException("Failed to create product folder.");
        }
        try (FileWriter writer = new FileWriter(this.headerFile);){
            xStream.toXML((Object)productDescriptor, (Writer)writer);
        }
    }

    private ProductDescriptor createProductDescriptor(Product product) {
        return new ProductDescriptor(product.getName(), product.getProductType(), product.getSceneRasterWidth(), product.getSceneRasterHeight(), this.createBandDescriptors(), product.getDescription());
    }

    private BandDescriptor[] createBandDescriptors() {
        Product product = this.getSourceProduct();
        Band[] bands = product.getBands();
        ArrayList<BandDescriptor> bandList = new ArrayList<BandDescriptor>(bands.length);
        for (Band band : bands) {
            if (band.getClass() == Band.class) {
                bandList.add(new BandDescriptor(band.getName(), ProductData.getTypeString((int)band.getDataType()), band.getScalingOffset(), band.getScalingFactor(), null, band.getDescription()));
                continue;
            }
            if (band.getClass() != VirtualBand.class) continue;
            bandList.add(new BandDescriptor(band.getName(), ProductData.getTypeString((int)band.getDataType()), band.getScalingOffset(), band.getScalingFactor(), ((VirtualBand)band).getExpression(), band.getDescription()));
        }
        return bandList.toArray(new BandDescriptor[bandList.size()]);
    }

    public synchronized void writeBandRasterData(Band band, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        if (this.writtenBands.contains(band)) {
            return;
        }
        if (band.getClass() != Band.class) {
            return;
        }
        MultiLevelImage image = band.getSourceImage();
        File productDir = this.headerFile.getParentFile();
        File bandDir = new File(productDir, band.getName());
        if (!this.ensureDir(bandDir)) {
            return;
        }
        int levelCount = image.getModel().getLevelCount();
        Properties imageProperties = new Properties();
        imageProperties.setProperty("numLevels", image.getModel().getLevelCount() + "");
        imageProperties.setProperty("width", image.getWidth() + "");
        imageProperties.setProperty("height", image.getHeight() + "");
        double[] flatmatrix = new double[6];
        image.getModel().getImageToModelTransform(0).getMatrix(flatmatrix);
        imageProperties.setProperty("i2mTransform", flatmatrix[0] + "," + flatmatrix[1] + "," + flatmatrix[2] + "," + flatmatrix[3] + "," + flatmatrix[4] + "," + flatmatrix[5]);
        try (FileWriter writer = new FileWriter(new File(bandDir, "image.properties"));){
            imageProperties.store(writer, "File created by " + ((Object)((Object)this)).getClass());
        }
        pm.beginTask("Writing tile data", levelCount);
        for (int level = 0; level < levelCount; ++level) {
            RenderedImage levelImage = image.getImage(level);
            File levelDir = new File(bandDir, "" + level);
            this.writeLevelImage(levelImage, levelDir, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
        }
        this.writtenBands.add(band);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeLevelImage(RenderedImage levelImage, File levelDir, ProgressMonitor pm) throws IOException {
        if (!this.ensureDir(levelDir)) {
            return;
        }
        try {
            pm.beginTask("Writing image", levelImage.getNumXTiles() * levelImage.getNumYTiles());
            ImageHeader imageHeader = new ImageHeader(levelImage, "raw");
            try (FileWriter fileWriter = new FileWriter(new File(levelDir, "image.properties"));){
                imageHeader.store((Writer)fileWriter, null);
            }
            for (int y = 0; y < levelImage.getNumYTiles(); ++y) {
                for (int x = 0; x < levelImage.getNumXTiles(); ++x) {
                    this.writeTile(levelImage, x, y, levelDir);
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
    }

    private synchronized void writeTile(RenderedImage levelImage, int tileX, int tileY, File levelDir) throws IOException {
        Raster raster = levelImage.getTile(tileX, tileY);
        File tileFile = new File(levelDir, tileX + "-" + tileY + ".raw");
        FileImageOutputStream stream = new FileImageOutputStream(tileFile);
        try {
            TiledFileOpImage.writeRawDataTile((Raster)raster, (ImageOutputStream)stream);
            stream.close();
        }
        catch (Throwable t) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tileFile.delete();
            throw new IOException("Failed to write tile to " + tileFile, t);
        }
    }

    private synchronized boolean ensureDir(File dir) {
        return dir.isDirectory() || dir.mkdir();
    }

    public synchronized void flush() throws IOException {
    }

    public synchronized void close() throws IOException {
        Product product;
        this.flush();
        if (this.writtenBands != null) {
            this.writtenBands.clear();
            this.writtenBands = null;
        }
        if ((product = this.getSourceProduct()) != null) {
            product.removeProductNodeListener((ProductNodeListener)this.productNodeHandler);
        }
    }

    public synchronized void deleteOutput() throws IOException {
        String[] bandNames;
        this.close();
        this.headerFile.delete();
        File dir = this.headerFile.getParentFile();
        if (dir == null) {
            throw new IOException("Could not retrieve the parent directory of '" + this.headerFile.getAbsolutePath() + "'.");
        }
        Product product = this.getSourceProduct();
        for (String bandName : bandNames = product.getBandNames()) {
            File imageDir = new File(dir, bandName);
            if (!imageDir.isDirectory()) continue;
            FileUtils.deleteTree((File)imageDir);
        }
        dir.delete();
    }

    private class ProductNodeHandler
    implements ProductNodeListener {
        private ProductNodeHandler() {
        }

        public void nodeChanged(ProductNodeEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeDataChanged(ProductNodeEvent event) {
            if (event.getSourceNode().getClass() == Band.class) {
                RawTiledPyramidsProductWriter rawTiledPyramidsProductWriter = RawTiledPyramidsProductWriter.this;
                synchronized (rawTiledPyramidsProductWriter) {
                    if (RawTiledPyramidsProductWriter.this.writtenBands != null) {
                        RawTiledPyramidsProductWriter.this.writtenBands.remove(event.getSourceNode());
                    }
                }
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
        }

        public void nodeRemoved(ProductNodeEvent event) {
        }
    }
}

