/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.rtp;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.image.TiledFileMultiLevelSource;
import org.esa.snap.dataio.rtp.ProductDescriptor;
import org.esa.snap.dataio.rtp.RawTiledPyramidsProductCodecSpi;

public class RawTiledPyramidsProductReader
extends AbstractProductReader {
    public RawTiledPyramidsProductReader(RawTiledPyramidsProductCodecSpi spi) {
        super((ProductReaderPlugIn)spi);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Product readProductNodesImpl() throws IOException {
        File headerFile = RawTiledPyramidsProductCodecSpi.getHeaderFile(this.getInput());
        XStream xStream = RawTiledPyramidsProductCodecSpi.createXStream();
        try (FileReader reader = new FileReader(headerFile);){
            Product bandDescriptors;
            ProductDescriptor productDescriptor = new ProductDescriptor();
            xStream.fromXML((Reader)reader, (Object)productDescriptor);
            Product product = new Product(productDescriptor.getName(), productDescriptor.getType(), productDescriptor.getWidth(), productDescriptor.getHeight());
            product.setDescription(productDescriptor.getDescription());
            for (Product bandDescriptor : bandDescriptors = productDescriptor.getBandDescriptors()) {
                Band band;
                String expression = bandDescriptor.getExpression();
                if (expression != null && !expression.trim().isEmpty()) {
                    band = new VirtualBand(bandDescriptor.getName(), ProductData.getType((String)bandDescriptor.getDataType()), product.getSceneRasterWidth(), product.getSceneRasterHeight(), expression);
                } else {
                    band = new Band(bandDescriptor.getName(), ProductData.getType((String)bandDescriptor.getDataType()), product.getSceneRasterWidth(), product.getSceneRasterHeight());
                    Path imageDir = headerFile.toPath().getParent().resolve(bandDescriptor.getName());
                    band.setSourceImage((MultiLevelImage)new DefaultMultiLevelImage((MultiLevelSource)TiledFileMultiLevelSource.create((Path)imageDir)));
                }
                band.setDescription(bandDescriptor.getDescription());
                band.setScalingFactor(bandDescriptor.getScalingFactor());
                band.setScalingOffset(bandDescriptor.getScalingOffset());
                product.addBand(band);
            }
            Product product2 = product;
            return product2;
        }
        catch (XStreamException e) {
            throw new IOException("Failed to read product header.", e);
        }
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("should not come here!");
    }
}

