/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.resampling;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Resampler;
import org.esa.snap.core.gpf.common.resample.ResamplingOp;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.rcp.SnapApp;

public class ResamplingOpResampler
implements Resampler {
    public String getName() {
        return "Resampling Operator";
    }

    public String getDescription() {
        return "Uses the SNAP resampling op to resample all bands of a product to the same size";
    }

    public boolean canResample(Product multiSizeProduct) {
        return ResamplingOp.canBeApplied((Product)multiSizeProduct);
    }

    public void resample(Product multiSizeProduct) {
        DefaultSingleTargetProductDialog resamplingDialog = new DefaultSingleTargetProductDialog("Resample", SnapApp.getDefault().getAppContext(), "Resampling", "resampleAction");
        resamplingDialog.setTargetProductNameSuffix("_resampled");
        Property referenceNodeNameProperty = resamplingDialog.getBindingContext().getPropertySet().getProperty("referenceBandName");
        Object[] bandNames = multiSizeProduct.getBandNames();
        if (bandNames.length > 0) {
            referenceNodeNameProperty.getDescriptor().setAttribute("valueSet", (Object)new ValueSet(bandNames));
            referenceNodeNameProperty.getDescriptor().setAttribute("defaultValue", bandNames[0]);
            referenceNodeNameProperty.getDescriptor().setDefaultValue(bandNames[0]);
            try {
                referenceNodeNameProperty.setValue(bandNames[0]);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        resamplingDialog.show();
    }

    public static void create() {
        new ResamplingOpResampler();
    }
}

