/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.visat.actions;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.HeadlessTestRunner;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.ExpectedMetadata;
import org.esa.snap.visat.actions.CreateExpectedJsonCodeAction;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@RunWith(value=HeadlessTestRunner.class)
public class CreateExpectedJsonCodeActionTest {
    private static final String JSON_CODE_RESOURCE = "EXPECTED_JSON_CODE.json";
    private static final String JSON_CODE_PINS_RESOURCE = "EXPECTED_JSON_PINS_CODE.json";
    private static final String LF = System.getProperty("line.separator");
    private static String EXPECTED_JSON_CODE;
    private static String EXPECTED_JSON_PINS_CODE;
    private static Product product;
    private static final int WIDTH = 10;
    private static final int HEIGHT = 20;
    private static final Point[] EXPECTED_PIXEL_POSES;

    @BeforeClass
    public static void setUpClass() throws Exception {
        EXPECTED_JSON_CODE = CreateExpectedJsonCodeActionTest.loadJSONCode(JSON_CODE_RESOURCE);
        EXPECTED_JSON_PINS_CODE = CreateExpectedJsonCodeActionTest.loadJSONCode(JSON_CODE_PINS_RESOURCE);
    }

    @Before
    public void setUp() throws Exception {
        product = new Product("Hans Wurst", "T", 10, 20);
        product.setStartTime(ProductData.UTC.parse((String)"23-AUG-1983 12:10:10"));
        product.setEndTime(ProductData.UTC.parse((String)"23-AUG-1983 12:14:41"));
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 10, 20, 0.0, 0.0, 1.0, -1.0));
        ProductReader readerMock = (ProductReader)Mockito.mock(ProductReader.class);
        ProductReaderPlugIn plugInMock = (ProductReaderPlugIn)Mockito.mock(ProductReaderPlugIn.class);
        Mockito.when((Object)readerMock.getReaderPlugIn()).thenReturn((Object)plugInMock);
        Mockito.when((Object)plugInMock.getDecodeQualification(Mockito.any())).thenReturn((Object)DecodeQualification.INTENDED);
        product.setProductReader(readerMock);
        Band band1 = product.addBand("band_1", 12);
        band1.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(20.0f), (Number[])new Integer[]{1}, null));
        band1.setDescription("description_1");
        band1.setUnit("abc");
        band1.setGeophysicalNoDataValue(1.0);
        band1.setNoDataValueUsed(true);
        Band band2 = product.addBand("band_2", 30);
        band2.setDescription("description_2");
        band2.setUnit("m/w^2");
        band2.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(20.0f), (Number[])new Float[]{Float.valueOf(2.0f)}, null));
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement test1Element = new MetadataElement("test_1");
        MetadataElement abc_1 = new MetadataElement("ABC");
        abc_1.addAttribute(new MetadataAttribute("Name", ProductData.createInstance((String)"ABC_1"), true));
        test1Element.addElement(abc_1);
        MetadataElement abc_2 = new MetadataElement("ABC");
        abc_2.addAttribute(new MetadataAttribute("Name", ProductData.createInstance((String)"ABC_2"), true));
        test1Element.addElement(abc_2);
        MetadataElement abc_3 = new MetadataElement("ABC");
        abc_3.addAttribute(new MetadataAttribute("Name", ProductData.createInstance((String)"ABC_3"), true));
        test1Element.addElement(abc_3);
        MetadataElement abc_4 = new MetadataElement("ABC");
        abc_4.addAttribute(new MetadataAttribute("Name", ProductData.createInstance((String)"ABC_4"), true));
        test1Element.addElement(abc_4);
        metadataRoot.addElement(test1Element);
        MetadataElement test2Element = new MetadataElement("test_2");
        test2Element.addAttribute(new MetadataAttribute("attrib", ProductData.createInstance((String)"abc"), true));
        test2Element.addAttribute(new MetadataAttribute("attrib", ProductData.createInstance((String)"def"), true));
        test2Element.addAttribute(new MetadataAttribute("attrib", ProductData.createInstance((String)"ghi"), true));
        metadataRoot.addElement(test2Element);
    }

    private static String loadJSONCode(String jsonCodeResource) throws IOException {
        InputStream resourceAsStream = CreateExpectedJsonCodeActionTest.class.getResourceAsStream(jsonCodeResource);
        InputStreamReader reader = new InputStreamReader(resourceAsStream);
        BufferedReader r = new BufferedReader(reader);
        String line = r.readLine();
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            sb.append(line);
            line = r.readLine();
            if (line == null) continue;
            sb.append(LF);
        }
        return sb.toString();
    }

    @Test
    public void testCreatedJson() throws Exception {
        CreateExpectedJsonCodeAction jsonCodeCommand = new CreateExpectedJsonCodeAction(product);
        Random mock = this.createMockedRandom();
        String actualJsonCode = jsonCodeCommand.createJsonCode(mock);
        Assert.assertEquals((Object)EXPECTED_JSON_CODE, (Object)actualJsonCode);
    }

    @Test
    public void testCreatedJsonWith_Pins() throws Exception {
        CreateExpectedJsonCodeAction jsonCodeCommand = new CreateExpectedJsonCodeAction(product);
        GeoCoding geoCoding = product.getSceneGeoCoding();
        PixelPos pinPos1 = new PixelPos(3.0, 7.0);
        Placemark pin1 = Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)"P1", (String)"L1", (String)"T1", (PixelPos)pinPos1, (GeoPos)geoCoding.getGeoPos(pinPos1, null), (GeoCoding)geoCoding);
        PixelPos pinPos2 = new PixelPos(8.0, 16.5);
        Placemark pin2 = Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)"P2", (String)"L2", (String)"T2", (PixelPos)pinPos2, (GeoPos)geoCoding.getGeoPos(pinPos2, null), (GeoCoding)geoCoding);
        product.getPinGroup().add(pin1);
        product.getPinGroup().add(pin2);
        String actualJsonCode = jsonCodeCommand.createJsonCode(new Random(12345L));
        Assert.assertEquals((Object)EXPECTED_JSON_PINS_CODE, (Object)actualJsonCode);
    }

    @Test
    public void testFillClipboardWithJsonCode() throws Exception {
        Clipboard clipboard = new Clipboard("testClipboard");
        CreateExpectedJsonCodeAction jsonCodeCommand = new CreateExpectedJsonCodeAction(product);
        jsonCodeCommand.setClipboard(clipboard);
        jsonCodeCommand.fillClipboardWithJsonCode(this.createMockedRandom());
        Assert.assertTrue((boolean)clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor));
        String actualJsonCode = (String)clipboard.getData(DataFlavor.stringFlavor);
        Assert.assertNotNull((Object)actualJsonCode);
        Assert.assertEquals((Object)EXPECTED_JSON_CODE, (Object)actualJsonCode);
    }

    @Test
    public void testIdGeneration() throws Exception {
        CreateExpectedJsonCodeAction jsonCodeCommand = new CreateExpectedJsonCodeAction(product);
        Product testProduct = new Product("blah test.1", "d", 3, 3);
        Assert.assertEquals((Object)"blah_test_1", (Object)jsonCodeCommand.generateID(testProduct));
        testProduct.setName("B  L..A H");
        Assert.assertEquals((Object)"B__L__A_H", (Object)jsonCodeCommand.generateID(testProduct));
    }

    private Random createMockedRandom() {
        Random mock = (Random)Mockito.mock(Random.class);
        OngoingStubbing ongoingStubbing = Mockito.when((Object)Float.valueOf(mock.nextFloat()));
        for (Point coord : EXPECTED_PIXEL_POSES) {
            ongoingStubbing = ongoingStubbing.thenReturn((Object)Float.valueOf((float)coord.x / 10.0f));
            ongoingStubbing = ongoingStubbing.thenReturn((Object)Float.valueOf((float)coord.y / 20.0f));
        }
        return mock;
    }

    @Test
    public void testJsonWriter() throws Exception {
        ObjectWriter jsonWriter = CreateExpectedJsonCodeAction.getConfiguredJsonWriter();
        ExpectedMetadata expectedMetadata = new ExpectedMetadata();
        expectedMetadata.setPath("DSD/DSD.21/Name");
        expectedMetadata.setValue("");
        StringWriter writer = new StringWriter(500);
        jsonWriter.writeValue((Writer)writer, (Object)expectedMetadata);
        String expectedString = "{" + CreateExpectedJsonCodeAction.LF + "    \"path\": \"DSD/DSD.21/Name\"," + CreateExpectedJsonCodeAction.LF + "    \"value\": \"\"" + CreateExpectedJsonCodeAction.LF + "}";
        String actualString = writer.getBuffer().toString();
        Assert.assertEquals((Object)expectedString, (Object)actualString);
    }

    static {
        EXPECTED_PIXEL_POSES = new Point[]{new Point(7, 6), new Point(0, 0), new Point(5, 6), new Point(8, 8), new Point(0, 2), new Point(8, 11), new Point(2, 10)};
    }
}

