/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.ExpectedBand;
import org.esa.snap.dataio.ExpectedContent;
import org.esa.snap.dataio.ExpectedGeoCoding;
import org.esa.snap.dataio.ExpectedGeoCoordinate;
import org.esa.snap.dataio.ExpectedMask;
import org.esa.snap.dataio.ExpectedMetadata;
import org.esa.snap.dataio.ExpectedPixel;
import org.esa.snap.dataio.ExpectedSample;
import org.esa.snap.dataio.ExpectedSampleCoding;
import org.esa.snap.dataio.ExpectedTiePointGrid;
import org.junit.Assert;

class ContentAssert {
    private final ExpectedContent expectedContent;
    private final String productId;
    private final Product product;

    ContentAssert(ExpectedContent expectedContent, String productId, Product product) {
        this.expectedContent = expectedContent;
        this.productId = productId;
        this.product = product;
    }

    void assertProductContent() {
        ContentAssert.assertExpectedProductProperties(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedGeoCoding(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedFlagCoding(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedIndexCoding(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedTiePointGrids(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedBands(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedMasks(this.expectedContent, this.productId, this.product);
        ContentAssert.testExpectedMetadata(this.expectedContent, this.productId, this.product);
    }

    private static void assertExpectedProductProperties(ExpectedContent expectedContent, String productId, Product product) {
        if (expectedContent.isSceneWidthSet()) {
            Assert.assertEquals((String)(productId + " SceneWidth"), (long)expectedContent.getSceneWidth(), (long)product.getSceneRasterWidth());
        }
        if (expectedContent.isSceneHeightSet()) {
            Assert.assertEquals((String)(productId + " SceneHeight"), (long)expectedContent.getSceneHeight(), (long)product.getSceneRasterHeight());
        }
        if (expectedContent.isStartTimeSet()) {
            Assert.assertEquals((String)(productId + " StartTime"), (Object)expectedContent.getStartTime(), (Object)product.getStartTime().format());
        }
        if (expectedContent.isEndTimeSet()) {
            Assert.assertEquals((String)(productId + " EndTime"), (Object)expectedContent.getEndTime(), (Object)product.getEndTime().format());
        }
    }

    private static void testExpectedGeoCoding(ExpectedContent expectedContent, String productId, Product product) {
        if (expectedContent.isGeoCodingSet()) {
            ExpectedGeoCoding expectedGeoCoding = expectedContent.getGeoCoding();
            GeoCoding geoCoding = product.getSceneGeoCoding();
            Assert.assertNotNull((String)(productId + " has no GeoCoding"), (Object)geoCoding);
            Double reverseAccuracy = expectedGeoCoding.getReverseAccuracy();
            ExpectedGeoCoordinate[] coordinates = expectedGeoCoding.getCoordinates();
            if (coordinates == null) {
                return;
            }
            for (ExpectedGeoCoordinate coordinate : coordinates) {
                PixelPos expectedPixelPos = coordinate.getPixelPos();
                GeoPos expectedGeoPos = coordinate.getGeoPos();
                GeoPos actualGeoPos = geoCoding.getGeoPos(expectedPixelPos, null);
                String message = productId + " GeoPos at Pixel(" + expectedPixelPos.getX() + "," + expectedPixelPos.getY() + ")";
                Assert.assertEquals((String)message, (double)expectedGeoPos.getLat(), (double)actualGeoPos.getLat(), (double)ContentAssert.computeAssertDelta(expectedGeoPos.getLat()));
                Assert.assertEquals((String)message, (double)expectedGeoPos.getLon(), (double)actualGeoPos.getLon(), (double)ContentAssert.computeAssertDelta(expectedGeoPos.getLon()));
                if (!(reverseAccuracy >= 0.0)) continue;
                PixelPos actualPixelPos = geoCoding.getPixelPos(actualGeoPos, null);
                Assert.assertEquals((String)(productId + " Pixel.X at GeoPos(" + actualGeoPos.getLat() + "," + actualGeoPos.getLon() + ")"), (double)expectedPixelPos.getX(), (double)actualPixelPos.getX(), (double)reverseAccuracy);
                Assert.assertEquals((String)(productId + " Pixel.Y at GeoPos(" + actualGeoPos.getLat() + "," + actualGeoPos.getLon() + ")"), (double)expectedPixelPos.getY(), (double)actualPixelPos.getY(), (double)reverseAccuracy);
            }
        }
    }

    private static void testExpectedFlagCoding(ExpectedContent expectedContent, String productId, Product product) {
        ProductNodeGroup flagCodingGroup = product.getFlagCodingGroup();
        for (ExpectedSampleCoding expectedFlagCoding : expectedContent.getFlagCodings()) {
            String name = expectedFlagCoding.getName();
            FlagCoding actualFlagCoding = (FlagCoding)flagCodingGroup.get(name);
            String msgPrefix = productId + " FlagCoding '" + name;
            Assert.assertNotNull((String)(msgPrefix + "' does not exist"), (Object)flagCodingGroup.contains(name));
            ContentAssert.assertEqualSampleCodings(msgPrefix, expectedFlagCoding, (SampleCoding)actualFlagCoding);
        }
    }

    private static void assertEqualSampleCodings(String msgPrefix, ExpectedSampleCoding expectedSampleCoding, SampleCoding actualSampleCoding) {
        ExpectedSample[] expectedSamples = expectedSampleCoding.getSamples();
        Assert.assertEquals((String)(msgPrefix + "' number of samples"), (long)expectedSamples.length, (long)actualSampleCoding.getNumAttributes());
        for (ExpectedSample expectedSample : expectedSamples) {
            String expectedSampleName = expectedSample.getName();
            MetadataAttribute actualSample = actualSampleCoding.getAttribute(expectedSampleName);
            Assert.assertNotNull((String)(msgPrefix + " sample '" + expectedSampleName + "' does not exist"), (Object)actualSample);
            Assert.assertEquals((String)(msgPrefix + " sample '" + expectedSampleName + "' Value"), (long)expectedSample.getValue(), (long)actualSample.getData().getElemUInt());
            String expectedSampleDescription = expectedSample.getDescription();
            if (!StringUtils.isNotNullAndNotEmpty((String)expectedSampleDescription)) continue;
            Assert.assertEquals((String)(msgPrefix + " sample '" + expectedSampleName + "' Description"), (Object)expectedSampleDescription, (Object)actualSample.getDescription());
        }
    }

    private static void testExpectedIndexCoding(ExpectedContent expectedContent, String productId, Product product) {
        ProductNodeGroup indexCodingGroup = product.getIndexCodingGroup();
        for (ExpectedSampleCoding expectedIndexCoding : expectedContent.getIndexCodings()) {
            String name = expectedIndexCoding.getName();
            IndexCoding actualIndexCoding = (IndexCoding)indexCodingGroup.get(name);
            String msgPrefix = productId + " IndexCoding '" + name;
            Assert.assertNotNull((String)(msgPrefix + "' does not exist"), (Object)actualIndexCoding);
            ContentAssert.assertEqualSampleCodings(msgPrefix, expectedIndexCoding, (SampleCoding)actualIndexCoding);
        }
    }

    private static void testExpectedTiePointGrids(ExpectedContent expectedContent, String productId, Product product) {
        ExpectedTiePointGrid[] tiePointGrids;
        for (ExpectedTiePointGrid tiePointGrid : tiePointGrids = expectedContent.getTiePointGrids()) {
            ContentAssert.testExpectedTiePointGrid(productId, tiePointGrid, product);
        }
    }

    private static void testExpectedBands(ExpectedContent expectedContent, String productId, Product product) {
        ExpectedBand[] expectedBands;
        for (ExpectedBand expectedBand : expectedBands = expectedContent.getBands()) {
            ContentAssert.testExpectedBand(productId, expectedBand, product);
        }
    }

    private static void testExpectedTiePointGrid(String productId, ExpectedTiePointGrid expectedTiePointGrid, Product product) {
        ExpectedPixel[] expectedPixel;
        TiePointGrid tiePointGrid = product.getTiePointGrid(expectedTiePointGrid.getName());
        Assert.assertNotNull((String)("missing tie-point grid '" + expectedTiePointGrid.getName() + " in product '" + product.getFileLocation()), (Object)tiePointGrid);
        String assertMessagePrefix = productId + " " + tiePointGrid.getName();
        if (expectedTiePointGrid.isDescriptionSet()) {
            Assert.assertEquals((String)(assertMessagePrefix + " Description"), (Object)expectedTiePointGrid.getDescription(), (Object)tiePointGrid.getDescription());
        }
        if (expectedTiePointGrid.isOffsetXSet()) {
            Assert.assertEquals((String)(assertMessagePrefix + " OffsetX"), (double)expectedTiePointGrid.getOffsetX(), (double)tiePointGrid.getOffsetX(), (double)ContentAssert.computeAssertDelta(expectedTiePointGrid.getOffsetX()));
        }
        if (expectedTiePointGrid.isOffsetYSet()) {
            Assert.assertEquals((String)(assertMessagePrefix + " OffsetY"), (double)expectedTiePointGrid.getOffsetY(), (double)tiePointGrid.getOffsetY(), (double)ContentAssert.computeAssertDelta(expectedTiePointGrid.getOffsetY()));
        }
        if (expectedTiePointGrid.isSubSamplingXSet()) {
            Assert.assertEquals((String)(assertMessagePrefix + " SubSamplingX"), (double)expectedTiePointGrid.getSubSamplingX(), (double)tiePointGrid.getSubSamplingX(), (double)ContentAssert.computeAssertDelta(expectedTiePointGrid.getSubSamplingX()));
        }
        if (expectedTiePointGrid.isSubSamplingYSet()) {
            Assert.assertEquals((String)(assertMessagePrefix + " SubSamplingY"), (double)expectedTiePointGrid.getSubSamplingY(), (double)tiePointGrid.getSubSamplingY(), (double)ContentAssert.computeAssertDelta(expectedTiePointGrid.getSubSamplingY()));
        }
        for (ExpectedPixel pixel : expectedPixel = expectedTiePointGrid.getExpectedPixels()) {
            float bandValue = tiePointGrid.getSampleFloat(pixel.getX(), pixel.getY());
            if (!tiePointGrid.isPixelValid(pixel.getX(), pixel.getY())) {
                bandValue = Float.NaN;
            }
            Assert.assertEquals((String)(assertMessagePrefix + " Pixel(" + pixel.getX() + "," + pixel.getY() + ")"), (double)pixel.getValue(), (double)bandValue, (double)ContentAssert.computeAssertDelta(pixel.getValue()));
        }
    }

    private static void testExpectedBand(String productId, ExpectedBand expectedBand, Product product) {
        ExpectedPixel[] expectedPixel;
        Band band = product.getBand(expectedBand.getName());
        Assert.assertNotNull((String)("missing band '" + expectedBand.getName() + " in product '" + productId), (Object)band);
        String messagePrefix = productId + " " + band.getName();
        if (expectedBand.isDescriptionSet()) {
            Assert.assertEquals((String)(messagePrefix + " Description"), (Object)expectedBand.getDescription(), (Object)band.getDescription());
        }
        if (expectedBand.isBandWidthSet()) {
            Assert.assertEquals((String)(messagePrefix + " BandWidth"), (long)expectedBand.getBandWidth(), (long)band.getRasterWidth());
        }
        if (expectedBand.isBandHeightSet()) {
            Assert.assertEquals((String)(messagePrefix + " BandHeight"), (long)expectedBand.getBandHeight(), (long)band.getRasterHeight());
        }
        if (expectedBand.isGeophysicalUnitSet()) {
            Assert.assertEquals((String)(messagePrefix + " Unit"), (Object)expectedBand.getGeophysicalUnit(), (Object)band.getUnit());
        }
        if (expectedBand.isNoDataValueSet()) {
            double expectedNDValue = Double.parseDouble(expectedBand.getNoDataValue());
            Assert.assertEquals((String)(messagePrefix + " NoDataValue"), (double)expectedNDValue, (double)band.getGeophysicalNoDataValue(), (double)ContentAssert.computeAssertDelta(expectedNDValue));
        }
        if (expectedBand.isNoDataValueUsedSet()) {
            boolean expectedNDUsedValue = Boolean.parseBoolean(expectedBand.isNoDataValueUsed());
            Assert.assertEquals((String)(messagePrefix + " NoDataValueUsed"), (Object)expectedNDUsedValue, (Object)band.isNoDataValueUsed());
        }
        if (expectedBand.isSpectralWavelengthSet()) {
            float expectedSpectralWavelength = Float.parseFloat(expectedBand.getSpectralWavelength());
            Assert.assertEquals((String)(messagePrefix + " SpectralWavelength"), (double)expectedSpectralWavelength, (double)band.getSpectralWavelength(), (double)ContentAssert.computeAssertDelta(expectedSpectralWavelength));
        }
        if (expectedBand.isSpectralBandWidthSet()) {
            float expectedSpectralBandwidth = Float.parseFloat(expectedBand.getSpectralBandwidth());
            Assert.assertEquals((String)(messagePrefix + " SpectralBandWidth"), (double)expectedSpectralBandwidth, (double)band.getSpectralBandwidth(), (double)ContentAssert.computeAssertDelta(expectedSpectralBandwidth));
        }
        for (ExpectedPixel pixel : expectedPixel = expectedBand.getExpectedPixels()) {
            int pixelX = pixel.getX();
            int pixelY = pixel.getY();
            String pixelString = " Pixel(" + pixel.getX() + "," + pixel.getY() + ")";
            try {
                float bandValue = band.isPixelValid(pixelX, pixelY) ? band.getSampleFloat(pixelX, pixelY) : Float.NaN;
                Assert.assertEquals((String)(messagePrefix + pixelString), (double)pixel.getValue(), (double)bandValue, (double)ContentAssert.computeAssertDelta(pixel.getValue()));
            }
            catch (Exception e) {
                StringWriter stackTraceWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTraceWriter));
                Assert.fail((String)(messagePrefix + pixelString + "- caused " + e.getClass().getSimpleName() + "\n" + stackTraceWriter.toString()));
            }
        }
    }

    private static void assertEqualMasks(String msgPrefix, ExpectedMask expectedMask, Mask actualMask) {
        Assert.assertEquals((String)(msgPrefix + " Type"), (Object)expectedMask.getType(), actualMask.getImageType().getClass());
        Assert.assertEquals((String)(msgPrefix + " Color"), (Object)expectedMask.getColor(), (Object)actualMask.getImageColor());
        String expectedMaskDescription = expectedMask.getDescription();
        if (StringUtils.isNotNullAndNotEmpty((String)expectedMaskDescription)) {
            Assert.assertEquals((String)(msgPrefix + " Description"), (Object)expectedMaskDescription, (Object)actualMask.getDescription());
        }
    }

    private static void testExpectedMasks(ExpectedContent expectedContent, String productId, Product product) {
        ExpectedMask[] expectedMasks = expectedContent.getMasks();
        ProductNodeGroup actualMaskGroup = product.getMaskGroup();
        for (ExpectedMask expectedMask : expectedMasks) {
            String expectedName = expectedMask.getName();
            Mask actualMask = (Mask)actualMaskGroup.get(expectedName);
            String msgPrefix = productId + " Mask '" + expectedName + "' ";
            Assert.assertNotNull((String)(msgPrefix + "' does not exist"), (Object)actualMask);
            ContentAssert.assertEqualMasks(msgPrefix, expectedMask, actualMask);
        }
    }

    private static MetadataElement getMetadataElement(String msgPrefix, String[] pathElementNames, MetadataElement rootElement) {
        MetadataElement element = rootElement;
        Pattern pattern = Pattern.compile("(.*)\\[(\\d++)\\]");
        for (String elementName : pathElementNames) {
            Matcher matcher = pattern.matcher(elementName);
            if (matcher.matches()) {
                MetadataElement[] elements;
                elementName = matcher.group(1);
                int elemIndex = Integer.parseInt(matcher.group(2));
                Assert.assertTrue((String)(msgPrefix + " Index must be >= 1"), (elemIndex >= 1 ? 1 : 0) != 0);
                for (MetadataElement elem : elements = element.getElements()) {
                    if (!elem.getName().equals(elementName) || --elemIndex != 0) continue;
                    element = elem;
                    break;
                }
            } else {
                element = element.getElement(elementName);
            }
            Assert.assertNotNull((String)(msgPrefix + " Element '" + elementName + "' not found"), (Object)element);
        }
        return element;
    }

    private static MetadataAttribute getMetadataAttribute(String msgPrefix, MetadataElement currentElement, String attributeName) {
        Pattern pattern = Pattern.compile("(.*)\\[(\\d++)\\]");
        Matcher matcher = pattern.matcher(attributeName);
        if (matcher.matches()) {
            MetadataAttribute[] attributes;
            String attributeBaseName = matcher.group(1);
            int attribIndex = Integer.parseInt(matcher.group(2));
            Assert.assertTrue((String)(msgPrefix + " Index must be >= 1"), (attribIndex >= 1 ? 1 : 0) != 0);
            for (MetadataAttribute attrib : attributes = currentElement.getAttributes()) {
                if (!attrib.getName().equals(attributeBaseName) || --attribIndex != 0) continue;
                return attrib;
            }
        }
        return currentElement.getAttribute(attributeName);
    }

    private static void testExpectedMetadata(ExpectedContent expectedContent, String productId, Product product) {
        ExpectedMetadata[] expectedMetadataArray;
        for (ExpectedMetadata expectedMetadata : expectedMetadataArray = expectedContent.getMetadata()) {
            String path = expectedMetadata.getPath();
            String[] pathTokens = ContentAssert.getPathTokens(path);
            String[] elementNames = Arrays.copyOf(pathTokens, pathTokens.length - 1);
            String msgPrefix = productId + " Metadata path '" + path + "' not valid.";
            MetadataElement currentElement = ContentAssert.getMetadataElement(msgPrefix, elementNames, product.getMetadataRoot());
            String attributeName = pathTokens[pathTokens.length - 1];
            MetadataAttribute attribute = ContentAssert.getMetadataAttribute(msgPrefix, currentElement, attributeName);
            Assert.assertNotNull((String)(msgPrefix + " Attribute '" + attributeName + "' not found"), (Object)attribute);
            Assert.assertEquals((String)(msgPrefix + " Value"), (Object)expectedMetadata.getValue(), (Object)attribute.getData().getElemString());
        }
    }

    private static String[] getPathTokens(String path) {
        String[] splits = path.split("/");
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < splits.length; ++i) {
            String currentSplit = splits[i];
            if (currentSplit.isEmpty()) {
                tokens.add((String)tokens.remove(tokens.size() - 1) + "/" + splits[++i]);
                continue;
            }
            tokens.add(currentSplit);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    static double computeAssertDelta(double expectedValue) {
        if (!Double.isFinite(expectedValue) || Math.abs(expectedValue) < 1.0) {
            return 1.0E-6;
        }
        double delta = Math.abs(expectedValue) / 1000000.0;
        long rounded = Math.round(delta * 1.0E7);
        return (double)rounded / 1.0E7;
    }
}

