/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.io.StringWriter;
import java.io.Writer;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.dataio.ExpectedMask;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ColorSerializerDeserializerTest {
    private static final String JSON_CONTENT_RGB = "{\"name\":\"maskName\",\"type\":\"org.esa.snap.core.datamodel.Mask$BandMathsType\",\"color\":\"0,255,255\",\"description\":\"describing the mask\"}";
    private static final ExpectedMask EXPECTED_MASK_RGB = new ExpectedMask("maskName", Mask.BandMathsType.class, Color.CYAN, "describing the mask");
    private static final String JSON_CONTENT_RGBA = "{\"name\":\"maskName\",\"type\":\"org.esa.snap.core.datamodel.Mask$BandMathsType\",\"color\":\"101,25,0,120\",\"description\":\"describing the mask\"}";
    private static final ExpectedMask EXPECTED_MASK_RGBA = new ExpectedMask("maskName", Mask.BandMathsType.class, new Color(101, 25, 0, 120), "describing the mask");

    @BeforeClass
    public static void setUp() throws Exception {
    }

    @Test
    public void testSerializeRGB() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter stringWriter = new StringWriter();
        mapper.writeValue((Writer)stringWriter, (Object)EXPECTED_MASK_RGB);
        Assert.assertEquals((Object)JSON_CONTENT_RGB, (Object)stringWriter.toString());
    }

    @Test
    public void testDeserializeRGB() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ExpectedMask actualExpectedMask = (ExpectedMask)mapper.readValue(JSON_CONTENT_RGB, ExpectedMask.class);
        Assert.assertEquals((Object)EXPECTED_MASK_RGB.getColor(), (Object)actualExpectedMask.getColor());
    }

    @Test
    public void testSerializeRGBA() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter stringWriter = new StringWriter();
        mapper.writeValue((Writer)stringWriter, (Object)EXPECTED_MASK_RGBA);
        Assert.assertEquals((Object)JSON_CONTENT_RGBA, (Object)stringWriter.toString());
    }

    @Test
    public void testDeserializeRGBA() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ExpectedMask actualExpectedMask = (ExpectedMask)mapper.readValue(JSON_CONTENT_RGBA, ExpectedMask.class);
        Assert.assertEquals((Object)EXPECTED_MASK_RGBA.getColor(), (Object)actualExpectedMask.getColor());
    }
}

