/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio;

import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReaderPlugin;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.dataio.ExpectedDataset;
import org.esa.snap.dataio.TestDefinition;
import org.esa.snap.dataio.TestProduct;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefinitionTest {
    private TestDefinition definition;

    @Before
    public void setUp() {
        this.definition = new TestDefinition();
    }

    @Test
    public void testSetGetProductReaderPlugin() {
        LandsatGeotiffReaderPlugin readerPlugin = new LandsatGeotiffReaderPlugin();
        this.definition.setProductReaderPlugin((ProductReaderPlugIn)readerPlugin);
        Assert.assertSame((Object)readerPlugin, (Object)this.definition.getProductReaderPlugin());
    }

    @Test
    public void testGetAllProducts_empty() {
        List products = this.definition.getAllProducts();
        Assert.assertNotNull((Object)products);
        Assert.assertEquals((long)0L, (long)products.size());
    }

    @Test
    public void testAddListAndGetAll() {
        TestProduct testProduct = new TestProduct();
        ArrayList<TestProduct> testProducts = new ArrayList<TestProduct>();
        testProducts.add(testProduct);
        this.definition.addTestProducts(testProducts);
        List allProducts = this.definition.getAllProducts();
        Assert.assertNotNull((Object)allProducts);
        Assert.assertEquals((long)1L, (long)allProducts.size());
    }

    @Test
    public void testGetExpectedDatasetById_empty() {
        ExpectedDataset expectedDataset = this.definition.getExpectedDataset("an_id");
        Assert.assertNull((Object)expectedDataset);
    }

    @Test
    public void testGetExpectedDatasetbyId() {
        ExpectedDataset expectedDataset = new ExpectedDataset();
        expectedDataset.setId("identifier");
        this.definition.addExpectedDataset(expectedDataset);
        ExpectedDataset dataset = this.definition.getExpectedDataset("identifier");
        Assert.assertNotNull((Object)dataset);
    }

    @Test
    public void testGetIntendedProductIds_empty() {
        List expectedIds = this.definition.getDecodableProductIds();
        Assert.assertNotNull((Object)expectedIds);
        Assert.assertEquals((long)0L, (long)expectedIds.size());
    }

    @Test
    public void testGetIntendedProductIds() {
        ExpectedDataset expectedDataset = new ExpectedDataset();
        expectedDataset.setId("identifier");
        expectedDataset.setDecodeQualification("intended");
        this.definition.addExpectedDataset(expectedDataset);
        List expectedIds = this.definition.getDecodableProductIds();
        Assert.assertEquals((long)1L, (long)expectedIds.size());
    }

    @Test
    public void testGetIntendedProductIds_mixed() {
        ExpectedDataset suitableDataset = new ExpectedDataset();
        suitableDataset.setId("id_suitable");
        suitableDataset.setDecodeQualification("suitable");
        this.definition.addExpectedDataset(suitableDataset);
        ExpectedDataset intendedDataset = new ExpectedDataset();
        intendedDataset.setId("id_intended");
        intendedDataset.setDecodeQualification("intended");
        this.definition.addExpectedDataset(intendedDataset);
        List expectedIds = this.definition.getDecodableProductIds();
        Assert.assertEquals((long)2L, (long)expectedIds.size());
        Assert.assertEquals((Object)"id_suitable", expectedIds.get(0));
        Assert.assertEquals((Object)"id_intended", expectedIds.get(1));
    }
}

