/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.DefaultViewport;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.StopWatch;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.ContentAssert;
import org.esa.snap.dataio.CustomLogFormatter;
import org.esa.snap.dataio.ExpectedContent;
import org.esa.snap.dataio.ExpectedDataset;
import org.esa.snap.dataio.ProductList;
import org.esa.snap.dataio.ReaderTestRunner;
import org.esa.snap.dataio.TestDefinition;
import org.esa.snap.dataio.TestDefinitionList;
import org.esa.snap.dataio.TestProduct;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=ReaderTestRunner.class)
public class ProductReaderAcceptanceTest {
    private static final String PROPERTYNAME_DATA_DIR = "snap.reader.tests.data.dir";
    private static final String PROPERTYNAME_FAIL_ON_MISSING_DATA = "snap.reader.tests.failOnMissingData";
    private static final String PROPERTYNAME_FAIL_ON_INTENDED = "snap.reader.tests.failOnMultipleIntendedReaders";
    private static final String PROPERTYNAME_LOG_FILE_PATH = "snap.reader.tests.log.file";
    private static final String PROPERTYNAME_CASS_NAME = "snap.reader.tests.class.name";
    private static final boolean FAIL_ON_MISSING_DATA = Boolean.parseBoolean(System.getProperty("snap.reader.tests.failOnMissingData", "true"));
    private static final String INDENT = "\t";
    private static final ProductList testProductList = new ProductList();
    private static final int DECODE_QUALI_LOG_THRESHOLD = 50;
    private static TestDefinitionList testDefinitionList;
    private static File dataRootDir;
    private static Logger logger;
    private static final SimpleDateFormat DATE_FORMAT;
    private static final Calendar CALENDAR;
    @Rule
    public ErrorCollector errorCollector = new ErrorCollector();

    @BeforeClass
    public static void initialize() throws Exception {
        ProductReaderAcceptanceTest.initLogger();
        ProductReaderAcceptanceTest.logFailOnMissingDataMessage();
        ProductReaderAcceptanceTest.assertTestDataDirectory();
        ProductReaderAcceptanceTest.loadProductReaderTestDefinitions();
        ProductReaderAcceptanceTest.createGlobalProductList();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        ProductReaderAcceptanceTest.logInfoWithStars("Finished / " + DATE_FORMAT.format(CALENDAR.getTime()));
    }

    @Test
    public void testOneIntendedReader() {
        ProductReaderAcceptanceTest.logInfoWithStars("Testing OneIntendedReader");
        boolean duplicates = false;
        for (TestProduct testProduct : testProductList) {
            Object testDefinition2;
            if (!testProduct.exists()) continue;
            ArrayList<ProductReaderPlugIn> intendedPlugins = new ArrayList<ProductReaderPlugIn>();
            for (Object testDefinition2 : testDefinitionList) {
                if (DecodeQualification.INTENDED != ProductReaderAcceptanceTest.getExpectedDecodeQualification((TestDefinition)testDefinition2, testProduct)) continue;
                intendedPlugins.add(testDefinition2.getProductReaderPlugin());
            }
            boolean hasMoreThanPlugin = intendedPlugins.size() > 1;
            if (!hasMoreThanPlugin) continue;
            logger.info(INDENT + testProduct.getId());
            testDefinition2 = intendedPlugins.iterator();
            while (testDefinition2.hasNext()) {
                ProductReaderPlugIn intendedPlugin = (ProductReaderPlugIn)testDefinition2.next();
                logger.info("\t\t" + intendedPlugin.getClass().getName());
            }
            duplicates = true;
            String reason = "more than one 'INTENDED' reader " + testProduct.getId();
            this.errorCollector.checkThat(reason, (Object)(intendedPlugins.size() <= 1 ? 1 : 0), CoreMatchers.is((Object)true));
        }
        if (duplicates && Boolean.parseBoolean(System.getProperty(PROPERTYNAME_FAIL_ON_INTENDED, "false"))) {
            Assert.fail((String)"Products are accepted by more than one ReaderPlugin as 'INTENDED'");
        }
    }

    @Test
    public void testPluginDecodeQualifications() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ProductReaderAcceptanceTest.logInfoWithStars("Testing DecodeQualification");
        StopWatch stopWatchTotal = new StopWatch();
        stopWatchTotal.start();
        int testCounter = 0;
        StopWatch stopWatch = new StopWatch();
        logger.info("");
        logger.info("\tNumber of test products: " + testProductList.size());
        logger.info("\tNumber of ReaderPlugIns: " + testDefinitionList.size());
        logger.info("\tLogging only decode qualification tests >50ms");
        logger.info("");
        for (TestDefinition testDefinition : testDefinitionList) {
            ProductReaderPlugIn productReaderPlugin = testDefinition.getProductReaderPlugin();
            logger.info(INDENT + productReaderPlugin.getClass().getName());
            for (TestProduct testProduct : testProductList) {
                if (testProduct.exists()) {
                    boolean decodeQualificationIsDefined;
                    File productFile = this.getTestProductFile(testProduct);
                    DecodeQualification expected = ProductReaderAcceptanceTest.getExpectedDecodeQualification(testDefinition, testProduct);
                    stopWatch.start();
                    DecodeQualification decodeQualification = productReaderPlugin.getDecodeQualification((Object)productFile);
                    stopWatch.stop();
                    boolean bl = decodeQualificationIsDefined = expected != null;
                    if (decodeQualificationIsDefined) {
                        String reason = productReaderPlugin.getClass().getName() + ": " + testProduct.getId();
                        this.errorCollector.checkThat(reason, (Object)decodeQualification, CoreMatchers.equalTo((Object)expected));
                        if (stopWatch.getTimeDiff() > 50L) {
                            logger.info("\t\t" + stopWatch.getTimeDiffString() + " - [" + expected + "] " + testProduct.getId());
                        }
                        ++testCounter;
                        continue;
                    }
                    if (DecodeQualification.UNABLE.equals((Object)decodeQualification)) continue;
                    logger.info("\t\t" + productReaderPlugin.getClass().getSimpleName() + ": " + "Can read " + testProduct.getId() + "[" + decodeQualification + "] but it is not defined in tests");
                    continue;
                }
                this.logProductNotExistent(2, testProduct);
            }
        }
        stopWatchTotal.stop();
        ProductReaderAcceptanceTest.logInfoWithStars(String.format("Tested DecodeQualification: %d tests in %s", testCounter, stopWatchTotal.getTimeDiffString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadIntendedProductContent() throws IOException {
        ProductReaderAcceptanceTest.logInfoWithStars("Testing IntendedProductContent");
        StopWatch stopWatchTotal = new StopWatch();
        stopWatchTotal.start();
        int testCounter = 0;
        StopWatch stopWatch = new StopWatch();
        for (TestDefinition testDefinition : testDefinitionList) {
            List intendedProductIds = testDefinition.getDecodableProductIds();
            logger.info(INDENT + testDefinition.getProductReaderPlugin().getClass().getSimpleName());
            for (String productId : intendedProductIds) {
                TestProduct testProduct = testProductList.getById(productId);
                String reason = "Test file not defined for ID=" + productId;
                this.errorCollector.checkThat(reason, (Object)testProduct, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                if (testProduct.exists()) {
                    File testProductFile = this.getTestProductFile(testProduct);
                    ProductReader productReader = testDefinition.getProductReaderPlugin().createReaderInstance();
                    stopWatch.start();
                    Product product = productReader.readProductNodes((Object)testProductFile, null);
                    try {
                        ProductReaderAcceptanceTest.assertExpectedContent(testDefinition, productId, product);
                    }
                    catch (Throwable t) {
                        Throwable error = new Throwable("[" + productId + "] " + t.getMessage());
                        error.initCause(t);
                        this.errorCollector.addError(error);
                    }
                    finally {
                        if (product != null) {
                            product.dispose();
                        }
                    }
                    stopWatch.stop();
                    logger.info("\t\t" + stopWatch.getTimeDiffString() + " - " + testProduct.getId());
                    ++testCounter;
                    continue;
                }
                this.logProductNotExistent(2, testProduct);
            }
        }
        stopWatchTotal.stop();
        ProductReaderAcceptanceTest.logInfoWithStars(String.format("Tested IntendedProductContent: %d tests in %s", testCounter, stopWatchTotal.getTimeDiffString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductIO_readProduct() throws Exception {
        ProductReaderAcceptanceTest.logInfoWithStars("Testing ProductIO.readProduct");
        StopWatch stopWatchTotal = new StopWatch();
        stopWatchTotal.start();
        int testCounter = 0;
        StopWatch stopWatch = new StopWatch();
        for (TestProduct testProduct : testProductList) {
            if (testProduct.exists()) {
                File testProductFile = this.getTestProductFile(testProduct);
                Product product = null;
                try {
                    stopWatch.start();
                    product = ProductIO.readProduct((File)testProductFile);
                    stopWatch.stop();
                    logger.info(INDENT + stopWatch.getTimeDiffString() + " - " + testProduct.getId());
                }
                catch (Exception e) {
                    String message = "ProductIO.readProduct " + testProduct.getId() + " caused an exception.\n" + "Should only return NULL or a product instance but should not cause any exception.";
                    logger.log(Level.SEVERE, message, e);
                    this.errorCollector.addError((Throwable)new Exception(message, e));
                }
                finally {
                    if (product != null) {
                        product.dispose();
                    }
                }
                ++testCounter;
                continue;
            }
            this.logProductNotExistent(1, testProduct);
        }
        stopWatchTotal.stop();
        ProductReaderAcceptanceTest.logInfoWithStars(String.format("Tested ProductIO.readProduct: %d tests in %s", testCounter, stopWatchTotal.getTimeDiffString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProductReadTimes() throws Exception {
        ProductReaderAcceptanceTest.logInfoWithStars("Testing product read times");
        logger.info(String.format("%s%s - %s - %s - %s", INDENT, " findReader ", " readNodes  ", "   getStx   ", " getViewData"));
        StopWatch stopWatchTotal = new StopWatch();
        stopWatchTotal.start();
        int testCounter = 0;
        StopWatch stopWatch = new StopWatch();
        for (TestProduct testProduct : testProductList) {
            if (testProduct.exists()) {
                File testProductFile = this.getTestProductFile(testProduct);
                Product product = null;
                try {
                    stopWatch.start();
                    ProductReader productReader = ProductIO.getProductReaderForInput((Object)testProductFile);
                    stopWatch.stop();
                    String findProductReaderTime = stopWatch.getTimeDiffString();
                    String readProductNodesTime = "--:--:--.---";
                    String getStxTime = "--:--:--.---";
                    String getViewDataTime = "--:--:--.---";
                    if (productReader != null) {
                        stopWatch.start();
                        product = productReader.readProductNodes((Object)testProductFile, null);
                        stopWatch.stop();
                        readProductNodesTime = stopWatch.getTimeDiffString();
                        if (product.getNumBands() > 0) {
                            Band band0 = product.getBandAt(0);
                            stopWatch.start();
                            Stx stx = band0.getStx();
                            this.errorCollector.checkThat("stx != null:" + testProduct.getId(), (Object)stx, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                            stopWatch.stop();
                            getStxTime = stopWatch.getTimeDiffString();
                            DefaultViewport viewport = new DefaultViewport(new Rectangle(1000, 1000));
                            int viewLevel = ImageLayer.getLevel((MultiLevelModel)band0.getSourceImage().getModel(), (Viewport)viewport);
                            RenderedImage viewImage = band0.getSourceImage().getImage(viewLevel);
                            stopWatch.start();
                            int numXTiles = viewImage.getNumXTiles();
                            int numYTiles = viewImage.getNumYTiles();
                            if (numXTiles > 0 && numYTiles > 0) {
                                for (int x = 0; x < numXTiles; ++x) {
                                    for (int y = 0; y < numYTiles; ++y) {
                                        Raster tileRaster = viewImage.getTile(x, y);
                                        this.errorCollector.checkThat("tileRaster != null: " + testProduct.getId(), (Object)tileRaster, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                                    }
                                }
                            } else {
                                Raster imageRaster = viewImage.getData();
                                this.errorCollector.checkThat("imageRaster != null: " + testProduct.getId(), (Object)imageRaster, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                            }
                            stopWatch.stop();
                            getViewDataTime = stopWatch.getTimeDiffString();
                        }
                    }
                    logger.info(String.format("%s%s - %s - %s - %s - %s", INDENT, findProductReaderTime, readProductNodesTime, getStxTime, getViewDataTime, testProduct.getId()));
                }
                catch (Exception e) {
                    String message = "Product reading " + testProduct.getId() + " caused an exception.";
                    logger.log(Level.SEVERE, message, e);
                    this.errorCollector.addError((Throwable)new Exception(message, e));
                }
                finally {
                    if (product != null) {
                        product.dispose();
                    }
                }
                ++testCounter;
                continue;
            }
            this.logProductNotExistent(1, testProduct);
        }
        stopWatchTotal.stop();
        ProductReaderAcceptanceTest.logInfoWithStars(String.format("Testing product read times: %d tests in %s", testCounter, stopWatchTotal.getTimeDiffString()));
    }

    private static void assertExpectedContent(TestDefinition testDefinition, String productId, Product product) {
        ExpectedContent expectedContent = testDefinition.getExpectedContent(productId);
        if (expectedContent == null) {
            return;
        }
        ContentAssert contentAssert = new ContentAssert(expectedContent, productId, product);
        contentAssert.assertProductContent();
    }

    private static DecodeQualification getExpectedDecodeQualification(TestDefinition testDefinition, TestProduct testProduct) {
        ExpectedDataset expectedDataset = testDefinition.getExpectedDataset(testProduct.getId());
        if (expectedDataset != null) {
            return expectedDataset.getDecodeQualification();
        }
        return null;
    }

    private File getTestProductFile(TestProduct testProduct) {
        String relativePath = testProduct.getRelativePath();
        File testProductFile = new File(dataRootDir, relativePath);
        this.errorCollector.checkThat("testProductFile exist " + testProduct.getId(), (Object)testProductFile.exists(), CoreMatchers.is((Object)true));
        return testProductFile;
    }

    private void logProductNotExistent(int indention, TestProduct testProduct) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indention; ++i) {
            sb.append(INDENT);
        }
        logger.info(sb.toString() + "Not existent - " + testProduct.getId());
    }

    private static void logFailOnMissingDataMessage() {
        if (!FAIL_ON_MISSING_DATA) {
            logger.warning("Tests will not fail if test data is missing!");
        }
    }

    private static void assertTestDataDirectory() {
        String dataDirProperty = System.getProperty(PROPERTYNAME_DATA_DIR);
        if (dataDirProperty == null) {
            Assert.fail((String)"Data directory path not set");
        }
        if (!(dataRootDir = new File(dataDirProperty)).isDirectory()) {
            Assert.fail((String)("Data directory is not valid: " + dataDirProperty));
        }
    }

    private static void initLogger() throws Exception {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        logger = Logger.getLogger(ProductReaderAcceptanceTest.class.getSimpleName());
        ProductReaderAcceptanceTest.removeRootLogHandler();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new CustomLogFormatter());
        logger.addHandler(consoleHandler);
        String logFilePath = System.getProperty(PROPERTYNAME_LOG_FILE_PATH);
        if (logFilePath != null) {
            File logFile = new File(logFilePath);
            FileOutputStream fos = new FileOutputStream(logFile);
            StreamHandler streamHandler = new StreamHandler(fos, new CustomLogFormatter());
            logger.addHandler(streamHandler);
        }
        ProductReaderAcceptanceTest.logInfoWithStars("Reader Acceptance Tests / " + DATE_FORMAT.format(CALENDAR.getTime()));
    }

    private static void removeRootLogHandler() {
        Handler[] handlers;
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
    }

    private static void createGlobalProductList() {
        for (TestDefinition testDefinition : testDefinitionList) {
            List allPluginProducts = testDefinition.getAllProducts();
            for (TestProduct testProduct : allPluginProducts) {
                if (ProductReaderAcceptanceTest.testIfIdAlreadyRegistered(testProduct)) continue;
                testProductList.add(testProduct);
            }
        }
    }

    private static boolean testIfIdAlreadyRegistered(TestProduct testProduct) {
        String id = testProduct.getId();
        TestProduct storedProduct = testProductList.getById(id);
        if (storedProduct != null) {
            if (storedProduct.isDifferent(testProduct)) {
                Assert.fail((String)("Test file with ID=" + id + " already defined with different settings"));
            }
            return true;
        }
        return false;
    }

    private static void testIfProductFilesExists(ProductList productList) {
        for (TestProduct testProduct : productList) {
            String relativePath = testProduct.getRelativePath();
            File productFile = new File(dataRootDir, relativePath);
            if (productFile.exists()) continue;
            testProduct.exists(false);
            if (!FAIL_ON_MISSING_DATA) continue;
            Assert.fail((String)("Test product does not exist: " + productFile.getAbsolutePath()));
        }
    }

    private static void loadProductReaderTestDefinitions() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Iterable readerPlugIns = SystemUtils.loadServices(ProductReaderPlugIn.class);
        testDefinitionList = new TestDefinitionList();
        String className = System.getProperty(PROPERTYNAME_CASS_NAME);
        for (ProductReaderPlugIn readerPlugIn : readerPlugIns) {
            String[] ids;
            Class<?> readerPlugInClass = readerPlugIn.getClass();
            if (className != null && !readerPlugInClass.getName().startsWith(className)) continue;
            String dataResourceName = ProductReaderAcceptanceTest.getReaderTestResourceName(readerPlugInClass.getName(), "-data.json");
            URL dataResource = readerPlugInClass.getResource(dataResourceName);
            if (dataResource == null) {
                logger.warning(readerPlugInClass.getSimpleName() + " does not define test data");
                continue;
            }
            TestDefinition testDefinition = new TestDefinition();
            testDefinition.setProductReaderPlugin(readerPlugIn);
            testDefinitionList.add(testDefinition);
            ProductList productList = (ProductList)mapper.readValue(dataResource, ProductList.class);
            ProductReaderAcceptanceTest.testIfProductFilesExists(productList);
            testDefinition.addTestProducts(productList.getAll());
            for (String id : ids = productList.getAllIds()) {
                String fileResourceName = id + ".json";
                URL fileResource = readerPlugInClass.getResource(fileResourceName);
                if (fileResource == null) {
                    Assert.fail((String)(readerPlugInClass.getSimpleName() + " resource file '" + fileResourceName + "' is missing"));
                }
                ExpectedDataset expectedDataset = (ExpectedDataset)mapper.readValue(fileResource, ExpectedDataset.class);
                testDefinition.addExpectedDataset(expectedDataset);
            }
        }
    }

    private static String getReaderTestResourceName(String fullyQualifiedName, String suffix) {
        String path = fullyQualifiedName.replace(".", "/");
        return "/" + path + suffix;
    }

    private static void logInfoWithStars(String text) {
        String msg = "  " + text + "  ";
        char[] stars = new char[msg.length()];
        Arrays.fill(stars, '*');
        String starString = new String(stars);
        logger.info("");
        logger.info(starString);
        logger.info(msg);
        logger.info(starString);
        logger.info("");
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm", Locale.ENGLISH);
        CALENDAR = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
    }
}

