/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Resampler;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class MultiSizeIssue {
    public static Product maybeResample(Product product) {
        int messageType;
        int optionType;
        String title = Dialogs.getDialogTitle("Resampling Required");
        List<Resampler> availableResamplers = MultiSizeIssue.getAvailableResamplers(product);
        StringBuilder msgTextBuilder = new StringBuilder("The functionality you have chosen is not supported for products with bands of different sizes.<br/>");
        if (availableResamplers.isEmpty()) {
            optionType = 2;
            messageType = 1;
        } else if (availableResamplers.size() == 1) {
            msgTextBuilder.append("You can use the ").append(availableResamplers.get(0).getName()).append(" to resample this product so that all bands have the same size, <br/>which will enable you to use this feature.<br/>Do you want to resample the product now?");
            optionType = 0;
            messageType = 3;
        } else {
            msgTextBuilder.append("You can use one of these resamplers to resample this product so that all bands have the same size, <br/>which will enable you to use this feature.<br/>Do you want to resample the product now?");
            optionType = 0;
            messageType = 3;
        }
        msgTextBuilder.append("<br/><br/>More info about this issue and its status can be found in the <a href=\"https://senbox.atlassian.net/browse/SNAP-1\">SNAP Issue Tracker</a>.");
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        JEditorPane textPane = new JEditorPane("text/html", msgTextBuilder.toString());
        MultiSizeIssue.setFont(textPane);
        textPane.setEditable(false);
        textPane.setOpaque(false);
        textPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (IOException | URISyntaxException e1) {
                    Dialogs.showWarning("Could not open URL: " + e.getDescription());
                }
            }
        });
        panel.add((Component)textPane, "Center");
        JComboBox<String> resamplerBox = new JComboBox<String>();
        if (availableResamplers.size() > 1) {
            String[] resamplerNames = new String[availableResamplers.size()];
            for (int i = 0; i < availableResamplers.size(); ++i) {
                resamplerNames[i] = availableResamplers.get(i).getName();
                resamplerBox.addItem(resamplerNames[i]);
            }
            panel.add(resamplerBox, "South");
        }
        NotifyDescriptor d = new NotifyDescriptor((Object)panel, title, optionType, messageType, null, null);
        DialogDisplayer.getDefault().notify(d);
        if (d.getValue() == NotifyDescriptor.YES_OPTION) {
            Resampler selectedResampler = availableResamplers.size() == 1 ? availableResamplers.get(0) : availableResamplers.get(resamplerBox.getSelectedIndex());
            return selectedResampler.resample(product);
        }
        return null;
    }

    private static List<Resampler> getAvailableResamplers(Product product) {
        Collection allResamplers = Lookup.getDefault().lookupAll(Resampler.class);
        ArrayList<Resampler> availableResamplers = new ArrayList<Resampler>();
        for (Resampler resampler : allResamplers) {
            if (!resampler.canResample(product)) continue;
            availableResamplers.add(resampler);
        }
        return availableResamplers;
    }

    public static boolean isMultiSize(Product selectedProduct) {
        return selectedProduct != null && selectedProduct.isMultiSize();
    }

    private static void setFont(JEditorPane textPane) {
        if (textPane.getDocument() instanceof HTMLDocument) {
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(bodyRule);
        }
    }
}

