/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.geom.Point2D;

public class PointConverter
implements Converter {
    private final GeometryFactory geometryFactory = new GeometryFactory();

    public Class getValueType() {
        return Point2D.class;
    }

    public Object parse(String text) throws ConversionException {
        try {
            Geometry geometry = new WKTReader(this.geometryFactory).read(text);
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                return new Point2D.Double(point.getX(), point.getY());
            }
            throw new ConversionException("Failed to parse point geometry WKT.");
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse point geometry WKT.", (Throwable)e);
        }
    }

    public String format(Object value) {
        Point2D point = (Point2D)value;
        return new WKTWriter().write((Geometry)this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY())));
    }
}

