/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import com.bc.ceres.core.CanceledException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.CloseAllProductsAction;
import org.esa.snap.rcp.session.RestoredSession;
import org.esa.snap.rcp.session.Session;
import org.esa.snap.rcp.session.SessionIO;
import org.esa.snap.rcp.session.SessionManager;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductNodeView;
import org.esa.snap.ui.product.ProductSceneView;

public class OpenSessionAction
extends AbstractAction {
    public static final String ID = "openSession";
    public static final String LAST_SESSION_DIR_KEY = "beam.lastSessionDir";
    private static final String TITLE = "Open Session";

    @Override
    public void actionPerformed(ActionEvent event) {
        Dialogs.Answer answer;
        SessionManager manager = SessionManager.getDefault();
        if (manager.getSessionFile() != null && (answer = Dialogs.requestDecision(TITLE, "This will close or reopen the current session.\nDo you want to continue?", true, null)) != Dialogs.Answer.YES) {
            return;
        }
        File sessionFile = Dialogs.requestFileForOpen(TITLE, false, (FileFilter)SessionManager.getDefault().getSessionFileFilter(), LAST_SESSION_DIR_KEY);
        if (sessionFile == null) {
            return;
        }
        this.openSession(sessionFile);
    }

    public void openSession(File sessionFile) {
        SessionManager manager = SessionManager.getDefault();
        manager.setSessionFile(sessionFile);
        CloseAllProductsAction closeProductAction = new CloseAllProductsAction();
        closeProductAction.execute();
        OpenSessionWorker worker = new OpenSessionWorker(manager, sessionFile);
        ((SwingWorker)((Object)worker)).execute();
    }

    private static class OpenSessionWorker
    extends ProgressMonitorSwingWorker<RestoredSession, Object> {
        private final SessionManager app;
        private final File sessionFile;

        public OpenSessionWorker(SessionManager app, File sessionFile) {
            super((Component)SnapApp.getDefault().getMainFrame(), OpenSessionAction.TITLE);
            this.app = app;
            this.sessionFile = sessionFile;
        }

        protected RestoredSession doInBackground(ProgressMonitor pm) throws Exception {
            Session session = SessionIO.getInstance().readSession(this.sessionFile);
            File parentFile = this.sessionFile.getParentFile();
            URI rootURI = parentFile != null ? parentFile.toURI() : new File(".").toURI();
            return session.restore(SnapApp.getDefault().getAppContext(), rootURI, pm, new SessionProblemSolver());
        }

        /*
         * WARNING - void declaration
         */
        protected void done() {
            void var7_16;
            ProductNodeView[] productNodeViewArray;
            Product[] products;
            RestoredSession restoredSession;
            try {
                restoredSession = (RestoredSession)this.get();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CanceledException) {
                    return;
                }
                Dialogs.showError(MessageFormat.format("An unexpected exception occurred!\nMessage: {0}", e.getCause().getMessage()));
                e.printStackTrace();
                return;
            }
            Exception[] problems = restoredSession.getProblems();
            if (problems.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("The following problem(s) occurred while opening a session:\n");
                for (Exception exception : problems) {
                    exception.printStackTrace();
                    sb.append("  ");
                    sb.append(exception.getMessage());
                    sb.append("\n");
                }
                Dialogs.showWarning(sb.toString());
            }
            for (Product product : products = restoredSession.getProducts()) {
                SnapApp.getDefault().getProductManager().addProduct(product);
            }
            ProductNodeView[] productNodeViewArray2 = productNodeViewArray = restoredSession.getViews();
            int n = productNodeViewArray2.length;
            boolean bl = false;
            while (var7_16 < n) {
                ProductNodeView nodeView = productNodeViewArray2[var7_16];
                Rectangle bounds = nodeView.getBounds();
                Object internalFrame = null;
                if (nodeView instanceof ProductSceneView) {
                    ProductSceneView sceneView = (ProductSceneView)nodeView;
                    sceneView.getLayerCanvas().setInitiallyZoomingAll(false);
                    Viewport viewport = sceneView.getLayerCanvas().getViewport().clone();
                }
                ++var7_16;
            }
        }

        private <T> T getAction(String actionId) {
            T action = null;
            if (action == null) {
                throw new IllegalStateException("Action not found: actionId=" + actionId);
            }
            return action;
        }

        private class SessionProblemSolver
        implements Session.ProblemSolver {
            private SessionProblemSolver() {
            }

            @Override
            public Product solveProductNotFound(int id, File file) throws CanceledException {
                final File[] newFile = new File[1];
                final Dialogs.Answer[] answer = new Dialogs.Answer[1];
                final String title = MessageFormat.format("Open Session - Resolving [{0}]", file);
                final String msg = MessageFormat.format("Product [{0}] has been renamed or (re-)moved.\nIts location was [{1}].\nDo you wish to provide its new location?\n(Select ''No'' if the product shall no longer be part of the session.)", id, file);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            answer[0] = Dialogs.requestDecision(title, msg, true, null);
                            if (answer[0] == Dialogs.Answer.YES) {
                                newFile[0] = Dialogs.requestFileForOpen(title, false, null, null);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new CanceledException();
                }
                if (answer[0] == Dialogs.Answer.YES) {
                    throw new CanceledException();
                }
                if (newFile[0] != null) {
                    try {
                        return ProductIO.readProduct((File)newFile[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }
}

