/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.magicwand;

import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.magicwand.SpectralBandComparator;

public class MagicWandModel
implements Cloneable {
    public static final String MAGIC_WAND_MASK_NAME = "magic_wand";
    private double tolerance = 0.1;
    private double minTolerance = 0.0;
    private double maxTolerance = 1.0;
    private ArrayList<String> bandNames;
    private SpectrumTransform spectrumTransform;
    private PixelTest pixelTest;
    private boolean normalize;
    private PickMode pickMode = PickMode.SINGLE;
    private ArrayList<double[]> plusSpectra;
    private ArrayList<double[]> minusSpectra;
    private transient ArrayList<Listener> listeners;

    public MagicWandModel() {
        this.pixelTest = PixelTest.DISTANCE;
        this.spectrumTransform = SpectrumTransform.IDENTITY;
        this.bandNames = new ArrayList();
        this.plusSpectra = new ArrayList();
        this.minusSpectra = new ArrayList();
    }

    public void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void fireModelChanged(boolean recomputeMask) {
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                listener.modelChanged(this, recomputeMask);
            }
        }
    }

    public MagicWandModel clone() {
        try {
            MagicWandModel clone = (MagicWandModel)super.clone();
            clone.bandNames = new ArrayList<String>(this.bandNames);
            clone.plusSpectra = new ArrayList<double[]>(this.plusSpectra);
            clone.minusSpectra = new ArrayList<double[]>(this.minusSpectra);
            clone.listeners = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void assign(MagicWandModel other) {
        this.pixelTest = other.pixelTest;
        this.spectrumTransform = other.spectrumTransform;
        this.pickMode = other.pickMode;
        this.tolerance = other.tolerance;
        this.minTolerance = other.minTolerance;
        this.maxTolerance = other.maxTolerance;
        this.bandNames = new ArrayList<String>(other.bandNames);
        this.plusSpectra = new ArrayList<double[]>(other.plusSpectra);
        this.minusSpectra = new ArrayList<double[]>(other.minusSpectra);
        this.fireModelChanged(true);
    }

    int getSpectrumCount() {
        return this.plusSpectra.size() + this.minusSpectra.size();
    }

    int getPlusSpectrumCount() {
        return this.plusSpectra.size();
    }

    int getMinusSpectrumCount() {
        return this.minusSpectra.size();
    }

    int getBandCount() {
        return this.bandNames.size();
    }

    void addSpectrum(double ... spectrum) {
        Assert.argument((spectrum.length == this.bandNames.size() ? 1 : 0) != 0, (String)"spectrum size does not match # selected bands");
        if (this.pickMode == PickMode.SINGLE) {
            this.plusSpectra.clear();
            this.minusSpectra.clear();
            this.plusSpectra.add(spectrum);
        } else if (this.pickMode == PickMode.PLUS) {
            this.plusSpectra.add(spectrum);
        } else if (this.pickMode == PickMode.MINUS) {
            this.minusSpectra.add(spectrum);
        }
        this.fireModelChanged(true);
    }

    void clearSpectra() {
        this.plusSpectra.clear();
        this.minusSpectra.clear();
        this.fireModelChanged(true);
    }

    public List<String> getBandNames() {
        return Collections.unmodifiableList(this.bandNames);
    }

    public void setBandNames(String ... bandNames) {
        this.setBandNames(Arrays.asList(bandNames));
    }

    public void setBandNames(List<String> bandNames) {
        this.plusSpectra.clear();
        this.minusSpectra.clear();
        this.bandNames = new ArrayList<String>(bandNames);
        this.fireModelChanged(true);
    }

    public PickMode getPickMode() {
        return this.pickMode;
    }

    public void setPickMode(PickMode pickMode) {
        this.pickMode = pickMode;
        this.fireModelChanged(false);
    }

    public PixelTest getPixelTest() {
        return this.pixelTest;
    }

    public void setPixelTest(PixelTest pixelTest) {
        this.pixelTest = pixelTest;
        this.fireModelChanged(false);
    }

    public SpectrumTransform getSpectrumTransform() {
        return this.spectrumTransform;
    }

    public void setSpectrumTransform(SpectrumTransform spectrumTransform) {
        this.spectrumTransform = spectrumTransform;
        this.fireModelChanged(false);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
        this.fireModelChanged(true);
    }

    public double getMinTolerance() {
        return this.minTolerance;
    }

    public void setMinTolerance(double minTolerance) {
        this.minTolerance = minTolerance;
        this.fireModelChanged(false);
    }

    public double getMaxTolerance() {
        return this.maxTolerance;
    }

    public void setMaxTolerance(double maxTolerance) {
        this.maxTolerance = maxTolerance;
        this.fireModelChanged(false);
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
        this.fireModelChanged(false);
    }

    public void setSpectralBandNames(Product product) {
        List<Band> bands = MagicWandModel.getSpectralBands(product);
        ArrayList<String> bandNames = new ArrayList<String>();
        for (Band band : bands) {
            bandNames.add(band.getName());
        }
        if (!bandNames.isEmpty()) {
            this.setBandNames(bandNames.toArray(new String[bandNames.size()]));
        }
    }

    public static List<Band> getSpectralBands(Product product) {
        ArrayList<Band> bands = new ArrayList<Band>();
        for (Band band : product.getBands()) {
            if (!((double)band.getSpectralWavelength() > 0.0) && band.getSpectralBandIndex() < 0) continue;
            bands.add(band);
        }
        Collections.sort(bands, new SpectralBandComparator());
        return bands;
    }

    List<Band> getBands(Product product) {
        List<String> names = this.getBandNames();
        ArrayList<Band> bands = new ArrayList<Band>(names.size());
        for (String name : names) {
            Band band = product.getBand(name);
            if (band == null) {
                return null;
            }
            bands.add(band);
        }
        return bands;
    }

    static void setMagicWandMask(Product product, String expression) {
        Mask magicWandMask;
        String validMaskExpression;
        try {
            validMaskExpression = BandArithmetic.getValidMaskExpression((String)expression, (Product)product, null);
        }
        catch (ParseException e) {
            validMaskExpression = null;
        }
        if (validMaskExpression != null) {
            expression = "(" + validMaskExpression + ") && (" + expression + ")";
        }
        if ((magicWandMask = (Mask)product.getMaskGroup().get(MAGIC_WAND_MASK_NAME)) != null) {
            magicWandMask.getImageConfig().setValue("expression", (Object)expression);
        } else {
            product.addMask(MAGIC_WAND_MASK_NAME, expression, "Magic wand mask", Color.RED, 0.5);
        }
    }

    String createMaskExpression() {
        String minusPart;
        String plusPart;
        if (this.getPixelTest() == PixelTest.DISTANCE) {
            plusPart = MagicWandModel.getDistancePart(this.bandNames, this.spectrumTransform, this.plusSpectra, this.tolerance, this.normalize);
            minusPart = MagicWandModel.getDistancePart(this.bandNames, this.spectrumTransform, this.minusSpectra, this.tolerance, this.normalize);
        } else if (this.getPixelTest() == PixelTest.AVERAGE) {
            plusPart = MagicWandModel.getAveragePart(this.bandNames, this.spectrumTransform, this.plusSpectra, this.tolerance, this.normalize);
            minusPart = MagicWandModel.getAveragePart(this.bandNames, this.spectrumTransform, this.minusSpectra, this.tolerance, this.normalize);
        } else if (this.getPixelTest() == PixelTest.LIMITS) {
            plusPart = MagicWandModel.getLimitsPart(this.bandNames, this.spectrumTransform, this.plusSpectra, this.tolerance, this.normalize);
            minusPart = MagicWandModel.getLimitsPart(this.bandNames, this.spectrumTransform, this.minusSpectra, this.tolerance, this.normalize);
        } else {
            throw new IllegalStateException("Unhandled method " + (Object)((Object)this.getPixelTest()));
        }
        if (plusPart != null && minusPart != null) {
            return String.format("(%s) && !(%s)", plusPart, minusPart);
        }
        if (plusPart != null) {
            return plusPart;
        }
        if (minusPart != null) {
            return String.format("!(%s)", minusPart);
        }
        return "0";
    }

    private static String getDistancePart(List<String> bandNames, SpectrumTransform spectrumTransform, List<double[]> spectra, double tolerance, boolean normalize) {
        if (spectra.isEmpty()) {
            return null;
        }
        StringBuilder part = new StringBuilder();
        for (int i = 0; i < spectra.size(); ++i) {
            double[] spectrum = MagicWandModel.getSpectrum(spectra.get(i), normalize);
            if (i > 0) {
                part.append(" || ");
            }
            part.append(MagicWandModel.getDistanceSubPart(bandNames, spectrumTransform, spectrum, tolerance, normalize));
        }
        return part.toString();
    }

    private static String getAveragePart(List<String> bandNames, SpectrumTransform spectrumTransform, List<double[]> spectra, double tolerance, boolean normalize) {
        if (spectra.isEmpty()) {
            return null;
        }
        double[] avgSpectrum = MagicWandModel.getAvgSpectrum(bandNames.size(), spectra, normalize);
        return MagicWandModel.getDistanceSubPart(bandNames, spectrumTransform, avgSpectrum, tolerance, normalize);
    }

    private static String getLimitsPart(List<String> bandNames, SpectrumTransform spectrumTransform, List<double[]> spectra, double tolerance, boolean normalize) {
        if (spectra.isEmpty()) {
            return null;
        }
        double[] minSpectrum = MagicWandModel.getMinSpectrum(bandNames.size(), spectra, tolerance, normalize);
        double[] maxSpectrum = MagicWandModel.getMaxSpectrum(bandNames.size(), spectra, tolerance, normalize);
        return MagicWandModel.getLimitsSubPart(bandNames, spectrumTransform, minSpectrum, maxSpectrum, normalize);
    }

    private static double[] getSpectrum(double[] spectrum, boolean normalize) {
        if (normalize) {
            double[] normSpectrum = new double[spectrum.length];
            for (int i = 0; i < spectrum.length; ++i) {
                normSpectrum[i] = MagicWandModel.getSpectrumValue(spectrum, i, true);
            }
            return normSpectrum;
        }
        return spectrum;
    }

    private static double[] getAvgSpectrum(int numBands, List<double[]> spectra, boolean normalize) {
        double[] avgSpectrum = new double[numBands];
        for (double[] spectrum : spectra) {
            int i = 0;
            while (i < spectrum.length) {
                double value = MagicWandModel.getSpectrumValue(spectrum, i, normalize);
                int n = i++;
                avgSpectrum[n] = avgSpectrum[n] + value;
            }
        }
        int i = 0;
        while (i < avgSpectrum.length) {
            int n = i++;
            avgSpectrum[n] = avgSpectrum[n] / (double)spectra.size();
        }
        return avgSpectrum;
    }

    private static double[] getMinSpectrum(int numBands, List<double[]> spectra, double tolerance, boolean normalize) {
        double[] minSpectrum = new double[numBands];
        Arrays.fill(minSpectrum, Double.MAX_VALUE);
        for (double[] spectrum : spectra) {
            for (int i = 0; i < spectrum.length; ++i) {
                double value = MagicWandModel.getSpectrumValue(spectrum, i, normalize);
                minSpectrum[i] = Math.min(minSpectrum[i], value - tolerance);
            }
        }
        return minSpectrum;
    }

    private static double[] getMaxSpectrum(int numBands, List<double[]> spectra, double tolerance, boolean normalize) {
        double[] maxSpectrum = new double[numBands];
        Arrays.fill(maxSpectrum, -1.7976931348623157E308);
        for (double[] spectrum : spectra) {
            for (int i = 0; i < spectrum.length; ++i) {
                double value = MagicWandModel.getSpectrumValue(spectrum, i, normalize);
                maxSpectrum[i] = Math.max(maxSpectrum[i], value + tolerance);
            }
        }
        return maxSpectrum;
    }

    private static double getSpectrumValue(double[] spectrum, int i, boolean normalize) {
        return normalize ? spectrum[i] / spectrum[0] : spectrum[i];
    }

    private static String getDistanceSubPart(List<String> bandNames, SpectrumTransform spectrumTransform, double[] spectrum, double tolerance, boolean normalize) {
        String functionName;
        if (bandNames.isEmpty()) {
            return "0";
        }
        StringBuilder arguments = new StringBuilder();
        MagicWandModel.appendSpectrumBandNames(bandNames, normalize, arguments);
        MagicWandModel.appendSpectrumBandValues(spectrum, arguments);
        if (spectrumTransform == SpectrumTransform.IDENTITY) {
            functionName = "distance";
        } else if (spectrumTransform == SpectrumTransform.DERIVATIVE) {
            functionName = "distance_deriv";
        } else if (spectrumTransform == SpectrumTransform.INTEGRAL) {
            functionName = "distance_integ";
        } else {
            throw new IllegalStateException("unhandled operator " + (Object)((Object)spectrumTransform));
        }
        if (bandNames.size() == 1) {
            return String.format("%s(%s) < %s", functionName, arguments, tolerance);
        }
        return String.format("%s(%s)/%s < %s", functionName, arguments, bandNames.size(), tolerance);
    }

    private static String getLimitsSubPart(List<String> bandNames, SpectrumTransform spectrumTransform, double[] minSpectrum, double[] maxSpectrum, boolean normalize) {
        String functionName;
        if (bandNames.isEmpty()) {
            return "0";
        }
        StringBuilder arguments = new StringBuilder();
        MagicWandModel.appendSpectrumBandNames(bandNames, normalize, arguments);
        MagicWandModel.appendSpectrumBandValues(minSpectrum, arguments);
        MagicWandModel.appendSpectrumBandValues(maxSpectrum, arguments);
        if (spectrumTransform == SpectrumTransform.IDENTITY) {
            functionName = "inrange";
        } else if (spectrumTransform == SpectrumTransform.DERIVATIVE) {
            functionName = "inrange_deriv";
        } else if (spectrumTransform == SpectrumTransform.INTEGRAL) {
            functionName = "inrange_integ";
        } else {
            throw new IllegalStateException("unhandled operator " + (Object)((Object)spectrumTransform));
        }
        return String.format("%s(%s)", functionName, arguments);
    }

    private static void appendSpectrumBandNames(List<String> bandNames, boolean normalize, StringBuilder arguments) {
        String firstName = BandArithmetic.createExternalName((String)bandNames.get(0));
        for (int i = 0; i < bandNames.size(); ++i) {
            if (i > 0) {
                arguments.append(",");
            }
            String name = BandArithmetic.createExternalName((String)bandNames.get(i));
            if (normalize) {
                arguments.append(name).append("/").append(firstName);
                continue;
            }
            arguments.append(name);
        }
    }

    private static void appendSpectrumBandValues(double[] spectrum, StringBuilder arguments) {
        for (double value : spectrum) {
            arguments.append(",");
            arguments.append(value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MagicWandModel that = (MagicWandModel)o;
        if (Double.compare(that.maxTolerance, this.maxTolerance) != 0) {
            return false;
        }
        if (Double.compare(that.minTolerance, this.minTolerance) != 0) {
            return false;
        }
        if (this.normalize != that.normalize) {
            return false;
        }
        if (Double.compare(that.tolerance, this.tolerance) != 0) {
            return false;
        }
        if (this.pixelTest != that.pixelTest) {
            return false;
        }
        if (this.pickMode != that.pickMode) {
            return false;
        }
        if (this.spectrumTransform != that.spectrumTransform) {
            return false;
        }
        if (!ObjectUtils.equalObjects(this.bandNames, that.bandNames)) {
            return false;
        }
        if (!ObjectUtils.equalObjects((Object)this.plusSpectra.toArray(), (Object)that.plusSpectra.toArray())) {
            return false;
        }
        return ObjectUtils.equalObjects((Object)this.minusSpectra.toArray(), (Object)that.minusSpectra.toArray());
    }

    public int hashCode() {
        int result = this.pickMode.hashCode();
        result = 31 * result + this.spectrumTransform.hashCode();
        result = 31 * result + this.pixelTest.hashCode();
        result = 31 * result + this.plusSpectra.hashCode();
        result = 31 * result + this.minusSpectra.hashCode();
        result = 31 * result + this.bandNames.hashCode();
        long temp = this.tolerance != 0.0 ? Double.doubleToLongBits(this.tolerance) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.normalize ? 1 : 0);
        temp = this.minTolerance != 0.0 ? Double.doubleToLongBits(this.minTolerance) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.maxTolerance != 0.0 ? Double.doubleToLongBits(this.maxTolerance) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static MagicWandModel fromXml(String xml) {
        return (MagicWandModel)MagicWandModel.createXStream().fromXML(xml);
    }

    public String toXml() {
        return MagicWandModel.createXStream().toXML((Object)this);
    }

    private static XStream createXStream() {
        XStream xStream = new XStream();
        xStream.alias("magicWandSettings", MagicWandModel.class);
        xStream.registerConverter(new SingleValueConverter(){

            public boolean canConvert(Class type) {
                return type.equals(double[].class);
            }

            public String toString(Object obj) {
                return StringUtils.arrayToString((Object)obj, (String)",");
            }

            public Object fromString(String str) {
                return StringUtils.toDoubleArray((String)str, (String)",");
            }
        });
        return xStream;
    }

    public static interface Listener {
        public void modelChanged(MagicWandModel var1, boolean var2);
    }

    public static enum PixelTest {
        DISTANCE,
        AVERAGE,
        LIMITS;

    }

    public static enum SpectrumTransform {
        INTEGRAL,
        IDENTITY,
        DERIVATIVE;

    }

    public static enum PickMode {
        SINGLE,
        PLUS,
        MINUS;

    }
}

