/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.image;

import com.bc.ceres.glayer.tools.Tools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.FilePathListCellRenderer;
import org.esa.snap.rcp.layermanager.layersrc.HistoryComboBoxModel;
import org.esa.snap.rcp.layermanager.layersrc.image.ImageFileAssistantPage2;
import org.esa.snap.rcp.layermanager.layersrc.image.ImageFileLayerSource;
import org.esa.snap.ui.FileHistory;
import org.esa.snap.ui.UserInputHistory;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;

class ImageFileAssistantPage1
extends AbstractLayerSourceAssistantPage {
    private static final String LAST_IMAGE_PREFIX = "ImageFileAssistantPage1.ImageFile.history";
    private static final String LAST_DIR = "ImageFileAssistantPage1.ImageFile.lastDir";
    private JComboBox imageFileBox;
    private JTextField worldFileField;
    private HistoryComboBoxModel imageHistoryModel;
    private JLabel imagePreviewLabel;

    ImageFileAssistantPage1() {
        super("Select Image File");
    }

    public boolean validatePage() {
        String imageFilePath = (String)this.getContext().getPropertyValue("imageFilePath");
        String worldFilePath = (String)this.getContext().getPropertyValue("worldFilePath");
        if (imageFilePath == null) {
            return false;
        }
        return new File(imageFilePath).exists() && (worldFilePath == null || new File(worldFilePath).exists());
    }

    public boolean hasNextPage() {
        return this.getContext().getPropertyValue("imageFilePath") != null;
    }

    public AbstractLayerSourceAssistantPage getNextPage() {
        this.imageHistoryModel.getHistory().copyInto(SnapApp.getDefault().getPreferences());
        ImageFileAssistantPage1.createTransform(this.getContext());
        return new ImageFileAssistantPage2();
    }

    public boolean canFinish() {
        return this.getContext().getPropertyValue("imageFilePath") != null;
    }

    public boolean performFinish() {
        this.imageHistoryModel.getHistory().copyInto(SnapApp.getDefault().getPreferences());
        ImageFileAssistantPage1.createTransform(this.getContext());
        return ImageFileLayerSource.insertImageLayer(this.getContext());
    }

    public Component createPageComponent() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.anchor = 17;
        gbc.gridy = 0;
        Preferences preferences = SnapApp.getDefault().getPreferences();
        FileHistory fileHistory = new FileHistory(5, LAST_IMAGE_PREFIX);
        fileHistory.initBy(preferences);
        this.imageHistoryModel = new HistoryComboBoxModel((UserInputHistory)fileHistory);
        this.imageFileBox = new JComboBox(this.imageHistoryModel);
        this.imageFileBox.addActionListener(new ImageFileItemListener());
        this.imageFileBox.setRenderer(new FilePathListCellRenderer(80));
        JLabel imageFileLabel = new JLabel("Path to image file (.png, .jpg, .tif, .gif):");
        JButton imageFileButton = new JButton("...");
        FileNameExtensionFilter imageFileFilter = new FileNameExtensionFilter("Image Files", "png", "jpg", "tif", "gif");
        imageFileButton.addActionListener(new FileChooserActionListener(imageFileFilter){

            @Override
            protected void onFileSelected(LayerSourcePageContext pageContext, String filePath) {
                pageContext.setPropertyValue("imageFilePath", (Object)filePath);
            }
        });
        this.addRow(panel, gbc, imageFileLabel, this.imageFileBox, imageFileButton);
        this.worldFileField = new JTextField();
        this.worldFileField.getDocument().addDocumentListener(new WorldFilePathDocumentListener());
        JLabel worldFileLabel = new JLabel("Path to world file (.pgw, .jgw, .tfw, .gfw):");
        JButton worldFileButton = new JButton("...");
        FileNameExtensionFilter worldFileFilter = new FileNameExtensionFilter("World Files", "pgw", "jgw", "tfw", "gfw");
        worldFileButton.addActionListener(new FileChooserActionListener(worldFileFilter){

            @Override
            protected void onFileSelected(LayerSourcePageContext pageContext, String filePath) {
                pageContext.setPropertyValue("worldFilePath", (Object)filePath);
            }
        });
        this.addRow(panel, gbc, worldFileLabel, this.worldFileField, worldFileButton);
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        this.imagePreviewLabel = new JLabel();
        this.imagePreviewLabel.setPreferredSize(new Dimension(200, 200));
        panel.add((Component)this.imagePreviewLabel, gbc);
        this.getContext().setPropertyValue("imageFilePath", null);
        this.getContext().setPropertyValue("worldFilePath", null);
        this.getContext().setPropertyValue("worldTransform", null);
        return panel;
    }

    private void addRow(JPanel panel, GridBagConstraints gbc, JLabel label, JComponent component, JButton button) {
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        panel.add((Component)label, gbc);
        gbc.insets = new Insets(0, 4, 0, 4);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        panel.add((Component)component, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        panel.add((Component)button, gbc);
    }

    private static void createTransform(LayerSourcePageContext pageContext) {
        AffineTransform transform = new AffineTransform();
        String worldFilePath = (String)pageContext.getPropertyValue("worldFilePath");
        if (worldFilePath != null && !worldFilePath.isEmpty()) {
            try {
                transform = Tools.loadWorldFile((String)worldFilePath);
            }
            catch (IOException e) {
                e.printStackTrace();
                pageContext.showErrorDialog(e.getMessage());
            }
        }
        pageContext.setPropertyValue("worldTransform", (Object)transform);
    }

    private class ImageFileItemListener
    implements ActionListener {
        private ImageFileItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String imageFilePath = (String)ImageFileAssistantPage1.this.imageFileBox.getSelectedItem();
            if (imageFilePath == null || !new File(imageFilePath).isFile()) {
                return;
            }
            ImagePreviewWorker worker = new ImagePreviewWorker(imageFilePath, ImageFileAssistantPage1.this.imagePreviewLabel);
            worker.execute();
            ImageFileAssistantPage1.this.getContext().setPropertyValue("imageFilePath", (Object)imageFilePath);
            String worldFilePath = this.createWorldFilePath(imageFilePath);
            if (new File(worldFilePath).isFile()) {
                ImageFileAssistantPage1.this.worldFileField.setText(worldFilePath);
            } else {
                ImageFileAssistantPage1.this.worldFileField.setText(null);
            }
            ImageFileAssistantPage1.this.getContext().updateState();
        }

        private String createWorldFilePath(String imageFilePath) {
            String worldFilePath;
            String imageFileExt = FileUtils.getExtension((String)imageFilePath);
            if (imageFileExt != null && imageFileExt.length() == 4) {
                String worldFileExt = imageFileExt.substring(0, 2) + imageFileExt.charAt(imageFileExt.length() - 1) + "w";
                worldFilePath = FileUtils.exchangeExtension((String)imageFilePath, (String)worldFileExt);
            } else {
                worldFilePath = imageFilePath + "w";
            }
            return worldFilePath;
        }

        private class ImagePreviewWorker
        extends SwingWorker<Image, Object> {
            private final Dimension targetDimension;
            private final String imageFilePath;
            private final JLabel imageLabel;

            private ImagePreviewWorker(String imageFilePath, JLabel imageLabel) {
                this.imageFilePath = imageFilePath;
                this.imageLabel = imageLabel;
                this.targetDimension = this.imageLabel.getSize();
            }

            @Override
            protected Image doInBackground() throws Exception {
                RenderedOp sourceImage = FileLoadDescriptor.create((String)this.imageFilePath, null, (Boolean)true, null);
                int width = sourceImage.getWidth();
                int height = sourceImage.getHeight();
                float scale = (float)(this.targetDimension.getWidth() / (double)width);
                if ((scale = (float)Math.min((double)scale, this.targetDimension.getHeight() / (double)height)) > 1.0f) {
                    scale = 1.0f;
                }
                Interpolation interpolation = Interpolation.getInstance((int)0);
                RenderedOp scaledImage = ScaleDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(scale), (Float)Float.valueOf(scale), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)interpolation, null);
                PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)scaledImage);
                BufferedImage bufferedImage = planarImage.getAsBufferedImage();
                planarImage.dispose();
                return bufferedImage;
            }

            @Override
            protected void done() {
                try {
                    this.imageLabel.setIcon(new ImageIcon((Image)this.get()));
                    this.imageLabel.setText(null);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.imageLabel.setText("Could not create preview");
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    this.imageLabel.setText("Could not create preview");
                }
            }
        }
    }

    private abstract class FileChooserActionListener
    implements ActionListener {
        private final FileFilter filter;

        private FileChooserActionListener(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(this.filter);
            fileChooser.setCurrentDirectory(this.getLastDirectory());
            LayerSourcePageContext pageContext = ImageFileAssistantPage1.this.getContext();
            fileChooser.showOpenDialog(pageContext.getWindow());
            if (fileChooser.getSelectedFile() != null) {
                String filePath = fileChooser.getSelectedFile().getPath();
                ImageFileAssistantPage1.this.imageHistoryModel.setSelectedItem(filePath);
                Preferences preferences = SnapApp.getDefault().getPreferences();
                preferences.put(ImageFileAssistantPage1.LAST_DIR, fileChooser.getCurrentDirectory().getAbsolutePath());
                this.onFileSelected(pageContext, filePath);
                pageContext.updateState();
            }
        }

        protected abstract void onFileSelected(LayerSourcePageContext var1, String var2);

        private File getLastDirectory() {
            Preferences preferences = SnapApp.getDefault().getPreferences();
            String dirPath = preferences.get(ImageFileAssistantPage1.LAST_DIR, System.getProperty("user.home"));
            File lastDir = new File(dirPath);
            if (!lastDir.isDirectory()) {
                lastDir = new File(System.getProperty("user.home"));
            }
            return lastDir;
        }
    }

    private class WorldFilePathDocumentListener
    implements DocumentListener {
        private WorldFilePathDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ImageFileAssistantPage1.this.getContext().setPropertyValue("worldFilePath", (Object)ImageFileAssistantPage1.this.worldFileField.getText());
            ImageFileAssistantPage1.this.getContext().updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ImageFileAssistantPage1.this.getContext().setPropertyValue("worldFilePath", (Object)ImageFileAssistantPage1.this.worldFileField.getText());
            ImageFileAssistantPage1.this.getContext().updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ImageFileAssistantPage1.this.getContext().setPropertyValue("worldFilePath", (Object)ImageFileAssistantPage1.this.worldFileField.getText());
            ImageFileAssistantPage1.this.getContext().updateState();
        }
    }
}

