/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import org.esa.snap.rcp.layermanager.AbstractLayerTopComponent;
import org.esa.snap.rcp.layermanager.Bundle;
import org.esa.snap.ui.layer.LayerEditor;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="LayerEditorTopComponent", iconBase="org/esa/snap/rcp/icons/LayerEditor.png", persistenceType=0)
public class LayerEditorTopComponent
extends AbstractLayerTopComponent {
    private LayerEditor activeEditor;
    private LayerHandler layerHandler;

    @Override
    protected String getTitle() {
        return Bundle.CTL_LayerEditorTopComponent_Name();
    }

    @Override
    protected String getHelpId() {
        return Bundle.CTL_LayerEditorTopComponent_HelpId();
    }

    @Override
    protected void initUI() {
        this.layerHandler = new LayerHandler();
        super.initUI();
    }

    @Override
    protected void layerSelectionChanged(Layer oldLayer, Layer newLayer) {
        if (oldLayer != null) {
            oldLayer.removeListener((LayerListener)this.layerHandler);
        }
        if (this.getComponentCount() > 0) {
            this.remove(0);
        }
        LayerEditor oldEditor = this.activeEditor;
        if (newLayer != null) {
            this.activeEditor = this.getLayerEditor(newLayer);
            this.setDisplayName("Layer Editor - " + newLayer.getName());
        } else {
            this.activeEditor = LayerEditor.EMPTY;
            this.setDisplayName("Layer Editor");
        }
        if (oldEditor != null) {
            oldEditor.handleEditorDetached();
        }
        this.add(this.activeEditor.createControl(newLayer), "Center");
        this.activeEditor.handleEditorAttached();
        this.activeEditor.handleLayerContentChanged();
        this.validate();
        this.repaint();
        if (newLayer != null) {
            newLayer.addListener((LayerListener)this.layerHandler);
        }
    }

    private LayerEditor getLayerEditor(Layer layer) {
        LayerEditor layerEditor = (LayerEditor)layer.getExtension(LayerEditor.class);
        if (layerEditor != null) {
            return layerEditor;
        }
        layerEditor = (LayerEditor)layer.getLayerType().getExtension(LayerEditor.class);
        if (layerEditor != null) {
            return layerEditor;
        }
        return LayerEditor.EMPTY;
    }

    private class LayerHandler
    extends AbstractLayerListener {
        private LayerHandler() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            LayerEditorTopComponent.this.activeEditor.handleLayerContentChanged();
        }

        public void handleLayerDataChanged(Layer layer, Rectangle2D modelRegion) {
            LayerEditorTopComponent.this.activeEditor.handleLayerContentChanged();
        }

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
            LayerEditorTopComponent.this.activeEditor.handleLayerContentChanged();
        }

        public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
            LayerEditorTopComponent.this.activeEditor.handleLayerContentChanged();
        }
    }
}

