/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.imgfilter.model.Filter;

public class FilterPropertiesForm
extends JPanel
implements PropertyChangeListener,
Filter.Listener {
    public static final TrueCondition TRUE_CONDITION = new TrueCondition();
    private Filter filter;
    private JComboBox<Filter.Operation> operationComboBox;
    private JTextField nameField;
    private JTextField shorthandField;
    private JTextField tagsField;
    private JTextField kernelOffsetXField;
    private JTextField kernelOffsetYField;
    private JTextField kernelWidthField;
    private JTextField kernelHeightField;
    private JTextField kernelQuotientField;
    private BindingContext bindingContext;

    public FilterPropertiesForm(Filter filter) {
        super((LayoutManager)new TableLayout());
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.createUI();
        this.setFilter(filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        if (this.filter != filter) {
            if (this.filter != null) {
                this.filter.removeListener(this);
            }
            if (this.bindingContext != null) {
                this.bindingContext.removePropertyChangeListener((PropertyChangeListener)this);
                this.bindingContext.unbind(this.bindingContext.getBinding("operation"));
                this.bindingContext.unbind(this.bindingContext.getBinding("name"));
                this.bindingContext.unbind(this.bindingContext.getBinding("shorthand"));
                this.bindingContext.unbind(this.bindingContext.getBinding("tags"));
                this.bindingContext.unbind(this.bindingContext.getBinding("kernelQuotient"));
                this.bindingContext.unbind(this.bindingContext.getBinding("kernelOffsetX"));
                this.bindingContext.unbind(this.bindingContext.getBinding("kernelOffsetY"));
                this.bindingContext.unbind(this.bindingContext.getBinding("kernelWidth"));
                this.bindingContext.unbind(this.bindingContext.getBinding("kernelHeight"));
                this.bindingContext = null;
            }
            Filter oldFilter = this.filter;
            this.filter = filter;
            if (this.filter != null) {
                PropertyContainer propertyContainer = PropertyContainer.createObjectBacked((Object)this.filter);
                propertyContainer.getDescriptor("tags").setConverter((Converter)new TagsConverter());
                propertyContainer.getDescriptor("operation").setDescription("<html>The image filter operation.<br/>CONVOLVE uses a real-valued kernel matrix.<br/>Other operations have Boolean matrices.");
                propertyContainer.getDescriptor("tags").setDescription("<html>Tags are used categorise and group filters.<br/>Use a comma to separate multiple tags.");
                propertyContainer.getDescriptor("name").setDescription("The filter's display name");
                propertyContainer.getDescriptor("shorthand").setDescription("A shorthand for the name, used as default band name suffix");
                propertyContainer.getDescriptor("kernelQuotient").setDescription("<html>Inverse scaling factor, will be used<br/>to pre-multiply the kernel matrix before convolution");
                propertyContainer.getDescriptor("kernelWidth").setDescription("<html>Width of the kernel matrix<br/>(editing not supported here, use the graphical editor)");
                propertyContainer.getDescriptor("kernelHeight").setDescription("<html>Height of the kernel matrix<br/>(editing not supported here, use the graphical editor)");
                propertyContainer.getDescriptor("kernelOffsetX").setDescription("<html>Offset in X of the kernel matrix' 'key element'<br/>(editing not yet supported, will always be kernel center)");
                propertyContainer.getDescriptor("kernelOffsetY").setDescription("<html>Offset in Y of the kernel matrix' 'key element'<br/>(editing not yet supported, will always be kernel center)");
                this.bindingContext = new BindingContext((PropertySet)propertyContainer);
                this.bindingContext.bind("operation", this.operationComboBox);
                this.bindingContext.bind("name", this.nameField);
                this.bindingContext.bind("shorthand", this.shorthandField);
                this.bindingContext.bind("tags", this.tagsField);
                this.bindingContext.bind("kernelQuotient", this.kernelQuotientField);
                this.bindingContext.bind("kernelOffsetX", this.kernelOffsetXField);
                this.bindingContext.bind("kernelOffsetY", this.kernelOffsetYField);
                this.bindingContext.bind("kernelWidth", this.kernelWidthField);
                this.bindingContext.bind("kernelHeight", this.kernelHeightField);
                Enablement.Condition editableCondition = new Enablement.Condition(){

                    public boolean evaluate(BindingContext bindingContext) {
                        return (Boolean)bindingContext.getPropertySet().getValue("editable");
                    }
                };
                Enablement.Condition editableConvolutionCondition = new Enablement.Condition(){

                    public boolean evaluate(BindingContext bindingContext) {
                        PropertySet propertySet = bindingContext.getPropertySet();
                        return Boolean.TRUE.equals(propertySet.getValue("editable")) && Filter.Operation.CONVOLVE.equals(propertySet.getValue("operation"));
                    }
                };
                this.bindingContext.bindEnabledState("operation", true, editableCondition);
                this.bindingContext.bindEnabledState("name", true, editableCondition);
                this.bindingContext.bindEnabledState("shorthand", true, editableCondition);
                this.bindingContext.bindEnabledState("tags", true, editableCondition);
                this.bindingContext.bindEnabledState("kernelQuotient", true, editableConvolutionCondition);
                this.bindingContext.bindEnabledState("kernelWidth", false, (Enablement.Condition)TRUE_CONDITION);
                this.bindingContext.bindEnabledState("kernelHeight", false, (Enablement.Condition)TRUE_CONDITION);
                this.bindingContext.bindEnabledState("kernelOffsetX", false, (Enablement.Condition)TRUE_CONDITION);
                this.bindingContext.bindEnabledState("kernelOffsetY", false, (Enablement.Condition)TRUE_CONDITION);
                this.bindingContext.adjustComponents();
                this.bindingContext.addPropertyChangeListener((PropertyChangeListener)this);
                this.filter.addListener(this);
            } else {
                this.clearComponents();
            }
            this.firePropertyChange("filter", oldFilter, this.filter);
        }
    }

    @Override
    public void filterChanged(Filter filter, String propertyName) {
        if (this.filter == filter) {
            this.bindingContext.adjustComponents();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.filter != null) {
            this.filter.fireChange(evt.getPropertyName());
        }
    }

    private void clearComponents() {
        this.operationComboBox.setSelectedItem(null);
        this.nameField.setText(null);
        this.shorthandField.setText(null);
        this.tagsField.setText(null);
        this.kernelQuotientField.setText(null);
        this.kernelOffsetXField.setText(null);
        this.kernelOffsetYField.setText(null);
        this.kernelWidthField.setText(null);
        this.kernelHeightField.setText(null);
    }

    void createUI() {
        this.operationComboBox = new JComboBox<Filter.Operation>(Filter.Operation.values());
        this.nameField = new JTextField(12);
        this.shorthandField = new JTextField(6);
        this.tagsField = new JTextField(16);
        this.kernelQuotientField = new JTextField(8);
        this.kernelOffsetXField = new JTextField(8);
        this.kernelOffsetYField = new JTextField(8);
        this.kernelWidthField = new JTextField(8);
        this.kernelHeightField = new JTextField(8);
        TableLayout layout = (TableLayout)this.getLayout();
        layout.setColumnCount(2);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableWeightX(Double.valueOf(0.5));
        layout.setTablePadding(2, 2);
        int row = 0;
        this.add((Component)new JLabel("Operation:"), TableLayout.cell((int)row, (int)0));
        this.add(this.operationComboBox, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Name:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.nameField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Shorthand:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.shorthandField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Tags:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.tagsField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Kernel quotient:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.kernelQuotientField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Kernel offset X:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.kernelOffsetXField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Kernel offset Y:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.kernelOffsetYField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Kernel width:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.kernelWidthField, TableLayout.cell((int)row, (int)1));
        this.add((Component)new JLabel("Kernel height:"), TableLayout.cell((int)(++row), (int)0));
        this.add((Component)this.kernelHeightField, TableLayout.cell((int)row, (int)1));
    }

    private static class TrueCondition
    extends Enablement.Condition {
        private TrueCondition() {
        }

        public boolean evaluate(BindingContext bindingContext) {
            return true;
        }
    }

    private static class TagsConverter
    implements Converter<Object> {
        public static final HashSet<String> EMPTY_TAGS = new HashSet();

        private TagsConverter() {
        }

        public Class<?> getValueType() {
            return HashSet.class;
        }

        public HashSet<String> parse(String text) throws ConversionException {
            if (text == null || text.isEmpty()) {
                return EMPTY_TAGS;
            }
            String[] tagArray = text.split(",");
            LinkedHashSet<String> tags = new LinkedHashSet<String>();
            for (String rawTag : tagArray) {
                String tag = rawTag.trim();
                if (tag.isEmpty()) continue;
                tags.add(tag);
            }
            return tags;
        }

        public String format(Object value) {
            Set set;
            if (value instanceof Set && !(set = (Set)value).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String s : set) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(s);
                }
                return sb.toString();
            }
            return null;
        }
    }
}

