/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.layer.overlay;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import java.util.List;
import org.esa.snap.rcp.actions.layer.overlay.AbstractOverlayAction;
import org.esa.snap.rcp.actions.layer.overlay.Bundle;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;
import org.openide.util.ImageUtilities;

public final class OverlayGeometryLayerAction
extends AbstractOverlayAction {
    private final LayerFilter geometryFilter = VectorDataLayerFilterFactory.createGeometryFilter();

    @Override
    protected void initActionProperties() {
        this.putValue("Name", Bundle.CTL_OverlayGeometryLayerActionName());
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/ShapeOverlay.gif", (boolean)false));
        this.putValue("SwingLargeIconKey", ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/ShapeOverlay24.gif", (boolean)false));
        this.putValue("ShortDescription", Bundle.CTL_OverlayGeometryLayerActionToolTip());
    }

    @Override
    protected boolean getActionSelectionState(ProductSceneView view) {
        List<Layer> childLayers = this.getGeometryLayers(view);
        return childLayers.stream().filter(Layer::isVisible).findAny().isPresent();
    }

    @Override
    protected boolean getActionEnabledState(ProductSceneView view) {
        List<Layer> childLayers = this.getGeometryLayers(view);
        return !childLayers.isEmpty();
    }

    @Override
    protected void setOverlayEnableState(ProductSceneView view) {
        if (view != null) {
            List<Layer> childLayers = this.getGeometryLayers(view);
            childLayers.stream().forEach(layer -> layer.setVisible(this.isSelected()));
        }
    }

    private List<Layer> getGeometryLayers(ProductSceneView sceneView) {
        return LayerUtils.getChildLayers((Layer)sceneView.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)this.geometryFilter);
    }
}

