/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.help;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.Dialogs;

public class ShowLogInExplorer
extends AbstractAction {
    @Override
    public void actionPerformed(ActionEvent e) {
        this.openLogFile();
    }

    private void openLogFile() {
        String os = System.getProperty("os.name").toLowerCase();
        Path userHomeDir = SystemUtils.getUserHomeDir().toPath();
        Path logDir = null;
        if (this.isLinuxOrMac(os)) {
            logDir = userHomeDir.resolve(".snap/system/var/log");
        } else if (os.startsWith("windows")) {
            logDir = userHomeDir.resolve("AppData/Roaming/SNAP/var/log");
        }
        if (logDir != null && Files.exists(logDir, new LinkOption[0])) {
            try {
                Desktop.getDesktop().open(logDir.toFile());
            }
            catch (IOException e) {
                Dialogs.showError("Could not open log directory!");
            }
        }
    }

    private boolean isLinuxOrMac(String os) {
        return os.startsWith("darwin") || os.startsWith("mac") || os.startsWith("linux");
    }
}

