/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class RoiMaskSelector {
    public static final String PROPERTY_NAME_USE_ROI_MASK = "useRoiMask";
    public static final String PROPERTY_NAME_ROI_MASK = "roiMask";
    final JCheckBox useRoiMaskCheckBox;
    final JComboBox roiMaskComboBox;
    final AbstractButton showMaskManagerButton;
    private final BindingContext bindingContext;
    private final ProductNodeListener productNodeListener;
    private Product product;
    private RasterDataNode raster;
    private Enablement useRoiEnablement;
    private Enablement roiMaskEnablement;

    private AbstractButton createShowMaskManagerButton() {
        AbstractButton showMaskManagerButton = ToolButtonFactory.createButton((Icon)ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/MaskManager24.png", (boolean)false), (boolean)false);
        showMaskManagerButton.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            TopComponent maskManagerTopComponent = WindowManager.getDefault().findTopComponent("MaskManagerTopComponent");
            maskManagerTopComponent.open();
            maskManagerTopComponent.requestActive();
        }));
        return showMaskManagerButton;
    }

    public RoiMaskSelector(BindingContext bindingContext) {
        Property useRoiMaskProperty = bindingContext.getPropertySet().getProperty(PROPERTY_NAME_USE_ROI_MASK);
        Assert.argument((useRoiMaskProperty != null ? 1 : 0) != 0, (String)"bindingContext");
        Assert.argument((useRoiMaskProperty.getType().equals(Boolean.class) || useRoiMaskProperty.getType() == Boolean.TYPE ? 1 : 0) != 0, (String)"bindingContext");
        Assert.argument((bindingContext.getPropertySet().getProperty(PROPERTY_NAME_ROI_MASK) != null ? 1 : 0) != 0, (String)"bindingContext");
        Assert.argument((boolean)bindingContext.getPropertySet().getProperty(PROPERTY_NAME_ROI_MASK).getType().equals(Mask.class), (String)"bindingContext");
        this.productNodeListener = new PNL();
        this.bindingContext = bindingContext;
        this.useRoiMaskCheckBox = new JCheckBox("Use ROI mask:");
        this.roiMaskComboBox = new JComboBox();
        this.roiMaskComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((Mask)value).getName());
                }
                return this;
            }
        });
        this.showMaskManagerButton = this.createShowMaskManagerButton();
        bindingContext.bind(PROPERTY_NAME_USE_ROI_MASK, this.useRoiMaskCheckBox);
        bindingContext.bind(PROPERTY_NAME_ROI_MASK, this.roiMaskComboBox);
        bindingContext.bindEnabledState(PROPERTY_NAME_USE_ROI_MASK, true, this.createUseRoiCondition());
        bindingContext.bindEnabledState(PROPERTY_NAME_ROI_MASK, true, this.createEnableMaskDropDownCondition());
    }

    public JPanel createPanel() {
        JPanel roiMaskPanel = GridBagUtils.createPanel();
        GridBagConstraints roiMaskPanelConstraints = GridBagUtils.createConstraints((String)"anchor=SOUTHWEST,fill=HORIZONTAL,insets.top=2");
        GridBagUtils.addToPanel((JPanel)roiMaskPanel, (Component)this.useRoiMaskCheckBox, (GridBagConstraints)roiMaskPanelConstraints, (String)",gridy=0,gridx=0,weightx=1");
        GridBagUtils.addToPanel((JPanel)roiMaskPanel, (Component)this.roiMaskComboBox, (GridBagConstraints)roiMaskPanelConstraints, (String)"gridy=1,insets.left=4");
        GridBagUtils.addToPanel((JPanel)roiMaskPanel, (Component)this.showMaskManagerButton, (GridBagConstraints)roiMaskPanelConstraints, (String)"gridheight=2,gridy=0,gridx=1,weightx=0,ipadx=5,insets.left=0");
        return roiMaskPanel;
    }

    public void updateMaskSource(Product newProduct, RasterDataNode newRaster) {
        if (this.product != newProduct) {
            if (this.product != null) {
                this.product.removeProductNodeListener(this.productNodeListener);
            }
            if (newProduct != null) {
                newProduct.addProductNodeListener(this.productNodeListener);
            }
            this.product = newProduct;
        }
        if (this.raster != newRaster) {
            this.raster = newRaster;
        }
        this.updateRoiMasks();
    }

    private void updateRoiMasks() {
        Property property = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_ROI_MASK);
        if (this.product != null && this.raster != null) {
            ProductNodeGroup maskGroup = this.product.getMaskGroup();
            ArrayList<Mask> maskList = new ArrayList<Mask>();
            Dimension refRrasterSize = this.raster.getRasterSize();
            for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
                Mask mask = (Mask)maskGroup.get(i);
                if (!refRrasterSize.equals(mask.getRasterSize())) continue;
                maskList.add(mask);
            }
            property.getDescriptor().setValueSet(new ValueSet((Object[])maskList.toArray(new ProductNode[maskList.size()])));
        } else {
            property.getDescriptor().setValueSet(new ValueSet((Object[])new Mask[0]));
        }
        this.useRoiEnablement.apply();
        this.roiMaskEnablement.apply();
    }

    private Enablement.Condition createUseRoiCondition() {
        return new Enablement.Condition(){

            public boolean evaluate(BindingContext bindingContext) {
                return RoiMaskSelector.this.product != null && RoiMaskSelector.this.product.getMaskGroup().getNodeCount() > 0;
            }

            public void install(BindingContext bindingContext, Enablement enablement) {
                RoiMaskSelector.this.useRoiEnablement = enablement;
            }

            public void uninstall(BindingContext bindingContext, Enablement enablement) {
                RoiMaskSelector.this.useRoiEnablement = null;
            }
        };
    }

    private Enablement.Condition createEnableMaskDropDownCondition() {
        return new Enablement.Condition(){

            public boolean evaluate(BindingContext bindingContext) {
                Boolean propertyValue = (Boolean)bindingContext.getPropertySet().getValue(RoiMaskSelector.PROPERTY_NAME_USE_ROI_MASK);
                if (RoiMaskSelector.this.roiMaskComboBox.getItemCount() > 0 && RoiMaskSelector.this.roiMaskComboBox.getSelectedIndex() < 0) {
                    RoiMaskSelector.this.roiMaskComboBox.setSelectedIndex(0);
                }
                return Boolean.TRUE.equals(propertyValue) && RoiMaskSelector.this.product != null && RoiMaskSelector.this.product.getMaskGroup().getNodeCount() > 0;
            }

            public void install(BindingContext bindingContext, Enablement enablement) {
                bindingContext.addPropertyChangeListener(RoiMaskSelector.PROPERTY_NAME_USE_ROI_MASK, (PropertyChangeListener)enablement);
                RoiMaskSelector.this.roiMaskEnablement = enablement;
            }

            public void uninstall(BindingContext bindingContext, Enablement enablement) {
                bindingContext.removePropertyChangeListener(RoiMaskSelector.PROPERTY_NAME_USE_ROI_MASK, (PropertyChangeListener)enablement);
                RoiMaskSelector.this.roiMaskEnablement = null;
            }
        };
    }

    private class PNL
    implements ProductNodeListener {
        private PNL() {
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleEvent(event);
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.handleEvent(event);
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handleEvent(event);
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleEvent(event);
        }

        private void handleEvent(ProductNodeEvent event) {
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Mask) {
                RoiMaskSelector.this.updateRoiMasks();
            }
        }
    }
}

