/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import com.bc.ceres.swing.figure.FigureEditorInteractor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoableEdit;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkNameFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.placemark.UndoablePlacemarkActionFactory;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductSceneView;
import org.opengis.referencing.operation.TransformException;
import org.openide.awt.UndoRedo;

public abstract class InsertPlacemarkInteractor
extends FigureEditorInteractor {
    private final PlacemarkDescriptor placemarkDescriptor;
    private final Cursor cursor;
    private boolean started;

    protected InsertPlacemarkInteractor(PlacemarkDescriptor placemarkDescriptor) {
        this.placemarkDescriptor = placemarkDescriptor;
        this.cursor = this.createCursor();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void mousePressed(MouseEvent event) {
        this.started = false;
        ProductSceneView sceneView = this.getProductSceneView(event);
        if (sceneView != null) {
            this.started = this.startInteraction(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        ProductSceneView sceneView;
        if (this.started && (sceneView = this.getProductSceneView(event)) != null) {
            sceneView.selectVectorDataLayer(this.placemarkDescriptor.getPlacemarkGroup(sceneView.getProduct()).getVectorDataNode());
            if (InsertPlacemarkInteractor.isSingleButton1Click((MouseEvent)event)) {
                this.insertPlacemark(sceneView);
            }
            this.stopInteraction(event);
        }
    }

    private void insertPlacemark(ProductSceneView view) {
        Product product = view.getProduct();
        String[] uniqueNameAndLabel = PlacemarkNameFactory.createUniqueNameAndLabel((PlacemarkDescriptor)this.placemarkDescriptor, (Product)product);
        String name = uniqueNameAndLabel[0];
        String label = uniqueNameAndLabel[1];
        PixelPos rasterPos = new PixelPos((double)((float)view.getCurrentPixelX() + 0.5f), (double)((float)view.getCurrentPixelY() + 0.5f));
        Point2D modelPos = view.getRaster().getImageToModelTransform().transform((Point2D)rasterPos, new Point2D.Double());
        Point2D.Double scenePos = new Point2D.Double();
        try {
            view.getRaster().getModelToSceneTransform().transform(modelPos, (Point2D)scenePos);
            AffineTransform sceneToImage = Product.findImageToModelTransform((GeoCoding)product.getSceneGeoCoding()).createInverse();
            rasterPos = (PixelPos)sceneToImage.transform(modelPos, (Point2D)new PixelPos());
        }
        catch (NoninvertibleTransformException | TransformException e) {
            Dialogs.showError("Could not place pin in image due to transformation exception: " + e.getMessage());
            return;
        }
        Placemark newPlacemark = Placemark.createPointPlacemark((PlacemarkDescriptor)this.placemarkDescriptor, (String)name, (String)label, (String)"", (PixelPos)rasterPos, null, (GeoCoding)product.getSceneGeoCoding());
        this.placemarkDescriptor.getPlacemarkGroup(product).add(newPlacemark);
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(product);
        if (undoManager != null) {
            undoManager.addEdit((UndoableEdit)UndoablePlacemarkActionFactory.createUndoablePlacemarkInsertion(product, newPlacemark, this.placemarkDescriptor));
        }
    }

    private Cursor createCursor() {
        Image cursorImage = this.placemarkDescriptor.getCursorImage();
        if (cursorImage == null) {
            return Cursor.getPredefinedCursor(1);
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, this.placemarkDescriptor.getCursorHotSpot(), this.placemarkDescriptor.getRoleName());
    }

    private ProductSceneView getProductSceneView(MouseEvent event) {
        Component eventComponent = event.getComponent();
        if (eventComponent instanceof ProductSceneView) {
            return (ProductSceneView)eventComponent;
        }
        Container parentComponent = eventComponent.getParent();
        if (parentComponent instanceof ProductSceneView) {
            return (ProductSceneView)parentComponent;
        }
        if (parentComponent.getParent() instanceof ProductSceneView) {
            return (ProductSceneView)parentComponent.getParent();
        }
        return null;
    }
}

