/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.esa.snap.rcp.imgfilter.model.Filter;

public class FilterKernelCanvas
extends JPanel
implements Filter.Listener {
    private final Filter filter;
    private double maxAbsElementValue;

    public FilterKernelCanvas(Filter filter) {
        this.filter = filter;
        this.setFont(new Font("Verdana", 0, 10));
        this.filter.addListener(this);
        this.maxAbsElementValue = -1.0;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void filterChanged(Filter filter, String propertyName) {
        this.updateMaxAbsElementValue();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Math.max(this.filter.getKernelWidth() * 16, 200), Math.max(this.filter.getKernelHeight() * 16, 200));
    }

    public int getKernelElementIndex(int x, int y) {
        Insets insets = this.getInsets();
        int w = this.getWidth() - (insets.left + insets.right);
        int h = this.getHeight() - (insets.top + insets.bottom);
        int kernelWidth = this.filter.getKernelWidth();
        int kernelHeight = this.filter.getKernelHeight();
        int cellSize = Math.min(w / kernelWidth, h / kernelHeight);
        int x0 = insets.left + (w - cellSize * kernelWidth) / 2;
        int y0 = insets.top + (h - cellSize * kernelHeight) / 2;
        int i = (x - x0) / cellSize;
        int j = (y - y0) / cellSize;
        if (i >= 0 && i < kernelWidth && j >= 0 && j < kernelHeight) {
            return j * kernelWidth + i;
        }
        return -1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.filter == null) {
            return;
        }
        if (this.maxAbsElementValue < 0.0) {
            this.updateMaxAbsElementValue();
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        int w = this.getWidth() - (insets.left + insets.right);
        int h = this.getHeight() - (insets.top + insets.bottom);
        int kernelWidth = this.filter.getKernelWidth();
        int kernelHeight = this.filter.getKernelHeight();
        int cellSize = Math.min(w / kernelWidth, h / kernelHeight);
        int x0 = insets.left + (w - cellSize * kernelWidth) / 2;
        int y0 = insets.top + (h - cellSize * kernelHeight) / 2;
        for (int j = 0; j < kernelHeight; ++j) {
            int y = y0 + j * cellSize;
            for (int i = 0; i < kernelWidth; ++i) {
                int x = x0 + i * cellSize;
                this.paintKernelElement(g, x, y, cellSize, cellSize, j * kernelWidth + i);
            }
        }
        g.setColor(Color.GRAY);
        g.drawRect(x0, y0, kernelWidth * cellSize, kernelHeight * cellSize);
    }

    private void paintKernelElement(Graphics g, int x, int y, int cw, int ch, int index) {
        if (this.filter.getOperation() == Filter.Operation.CONVOLVE) {
            this.paintConvolutionElement(g, x, y, cw, ch, index);
        } else {
            this.paintStructuringElement(g, x, y, cw, ch, index);
        }
    }

    private void paintConvolutionElement(Graphics g, int x, int y, int cw, int ch, int index) {
        int comp;
        double value = this.filter.getKernelElement(index);
        Color color = Color.WHITE;
        if (value > 0.0) {
            comp = 255 - (int)(this.maxAbsElementValue == 0.0 ? 0.0 : 100.0 * value / this.maxAbsElementValue);
            color = new Color(255, comp, comp);
        } else if (value < 0.0) {
            comp = 255 - (int)(this.maxAbsElementValue == 0.0 ? 0.0 : 100.0 * -value / this.maxAbsElementValue);
            color = new Color(comp, comp, 255);
        }
        g.setColor(color);
        g.fillRect(x, y, cw, ch);
        int cellSize = Math.min(cw, ch);
        if (cellSize >= 4) {
            g.setColor(Color.GRAY);
            g.drawRect(x, y, cw, ch);
            if (this.isOffsetIndex(index)) {
                g.setColor(Color.GRAY);
                g.drawRect(x + 1, y + 1, cw - 2, ch - 2);
            }
        }
        if (cellSize > 12) {
            float fontSize = Math.min(16.0f, 0.5f * (float)cellSize);
            String text = value == (double)((int)value) ? String.valueOf((int)value) : String.valueOf(value);
            g.setFont(this.getFont().deriveFont(fontSize));
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(text, g);
            int x1 = x + (int)(0.5 * (double)cw - 0.5 * bounds.getWidth());
            int y1 = y + (int)((double)ch - 0.5 * bounds.getHeight());
            g.setColor(this.filter.isEditable() ? this.getForeground() : Color.DARK_GRAY);
            g.drawString(text, x1, y1);
        }
    }

    private boolean isOffsetIndex(int index) {
        return index == this.filter.getKernelOffsetY() * this.filter.getKernelWidth() + this.filter.getKernelOffsetX();
    }

    private void paintStructuringElement(Graphics g, int x, int y, int cw, int ch, int index) {
        g.setColor(this.filter.getKernelElement(index) != 0.0 ? Color.DARK_GRAY : Color.WHITE);
        g.fillRect(x, y, cw, ch);
        int cellSize = Math.min(cw, ch);
        if (cellSize >= 4) {
            g.setColor(Color.GRAY);
            g.drawRect(x, y, cw, ch);
            if (this.isOffsetIndex(index)) {
                g.setColor(Color.GRAY);
                g.drawRect(x + 1, y + 1, cw - 2, ch - 2);
            }
        }
    }

    private void updateMaxAbsElementValue() {
        this.maxAbsElementValue = 0.0;
        if (this.filter != null) {
            for (double v : this.filter.getKernelElements()) {
                this.maxAbsElementValue = Math.max(this.maxAbsElementValue, Math.abs(v));
            }
        }
    }
}

