/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.Cancellable;

class ReadProductOperation
implements Runnable,
Cancellable {
    private final File file;
    private final String formatName;
    private Boolean status;

    public ReadProductOperation(File file, String formatName) {
        Assert.notNull((Object)file, (String)"file");
        Assert.notNull((Object)formatName, (String)"formatName");
        this.file = file;
        this.formatName = formatName;
    }

    public Boolean getStatus() {
        return this.status;
    }

    @Override
    public void run() {
        try {
            Product product = ProductIO.readProduct((File)this.file, (String[])new String[]{this.formatName});
            if (!Thread.interrupted()) {
                if (product == null) {
                    this.status = false;
                    SwingUtilities.invokeLater(() -> Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nFile '%s' can not be opened.", this.file)));
                } else {
                    this.status = true;
                    OpenProductAction.getRecentProductPaths().add(this.file.getPath());
                    SwingUtilities.invokeLater(() -> SnapApp.getDefault().getProductManager().addProduct(product));
                }
            } else {
                this.status = null;
            }
        }
        catch (IOException problem) {
            this.status = false;
            SwingUtilities.invokeLater(() -> Dialogs.showError(Bundle.CTL_OpenProductActionName(), problem.getMessage()));
        }
    }

    public boolean cancel() {
        boolean cancel;
        Dialogs.Answer answer = Dialogs.requestDecision(Bundle.CTL_OpenProductActionName(), "Do you really want to cancel the read process?", false, null);
        boolean bl = cancel = answer == Dialogs.Answer.YES;
        if (cancel) {
            this.status = null;
        }
        return cancel;
    }
}

