/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSubsetDialog;

public class ProductFileChooser
extends SnapFileChooser {
    private static int numSubsetProducts = 0;
    private JButton subsetButton;
    private Product subsetProduct;
    private JLabel sizeLabel;
    private boolean useSubset;
    private Product productToExport;

    public ProductFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.setDialogType(0);
    }

    public void setProductToExport(Product product) {
        this.productToExport = product;
        if (this.productToExport != null) {
            String fileName = this.productToExport.getFileLocation() != null ? this.productToExport.getFileLocation().getName() : this.productToExport.getName();
            this.setCurrentFilename(fileName);
        }
    }

    public Product getSubsetProduct() {
        return this.subsetProduct;
    }

    public boolean isSubsetEnabled() {
        return this.useSubset;
    }

    public void setSubsetEnabled(boolean useSubset) {
        this.useSubset = useSubset;
    }

    public int showDialog(Component parent, String approveButtonText) {
        this.initUI();
        this.clearCurrentSubsetProduct();
        this.updateState();
        return super.showDialog(parent, approveButtonText);
    }

    private void initUI() {
        if (this.getDialogType() == 0) {
            this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Open Product");
            if (this.isSubsetEnabled()) {
                this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Import Product");
                this.setApproveButtonText("Import Product");
                this.setApproveButtonMnemonic('I');
                this.setApproveButtonToolTipText("Imports the product.");
            }
        } else {
            this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Save Product");
            if (this.isSubsetEnabled()) {
                this.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - Export Product");
                this.setApproveButtonText("Export Product");
                this.setApproveButtonMnemonic('E');
                this.setApproveButtonToolTipText("Exports the product.");
            }
        }
        if (this.isSubsetEnabled()) {
            this.addSubsetAcessory();
        }
    }

    private void addSubsetAcessory() {
        this.subsetButton = new JButton("Subset...");
        this.subsetButton.setMnemonic('S');
        this.subsetButton.addActionListener(e -> this.openProductSubsetDialog());
        this.subsetButton.setEnabled(this.getSelectedFile() != null || this.productToExport != null);
        this.sizeLabel = new JLabel("0 M");
        this.sizeLabel.setHorizontalAlignment(4);
        JPanel panel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"fill=HORIZONTAL,weightx=1,anchor=NORTHWEST,insets.left=7,insets.right=7,insets.bottom=4");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.subsetButton, (GridBagConstraints)gbc, (String)"gridy=0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.sizeLabel, (GridBagConstraints)gbc, (String)"gridy=1");
        GridBagUtils.addVerticalFiller((JPanel)panel, (GridBagConstraints)gbc);
        this.setAccessory(panel);
        this.addPropertyChangeListener(e -> this.updateState());
    }

    private void updateState() {
        if (this.isSubsetEnabled()) {
            this.subsetButton.setEnabled(this.getSelectedFile() != null || this.productToExport != null);
            File file = this.getSelectedFile();
            if (file != null && file.isFile()) {
                long fileSize = Math.round((double)file.length() / 1048576.0);
                if (fileSize >= 1L) {
                    this.sizeLabel.setText("File size: " + fileSize + " M");
                } else {
                    this.sizeLabel.setText("File size: < 1 M");
                }
            } else {
                this.sizeLabel.setText("");
            }
        }
    }

    private void clearCurrentSubsetProduct() {
        this.subsetProduct = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProductSubsetDialog() {
        boolean approve;
        Product product = null;
        String newProductName = null;
        if (this.getDialogType() == 0) {
            File file = this.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                FileFilter fileFilter = this.getFileFilter();
                String formatName = fileFilter instanceof SnapFileFilter ? ((SnapFileFilter)fileFilter).getFormatName() : null;
                product = ProductIO.readProduct((File)file, (String[])new String[]{formatName});
                newProductName = this.createNewProductName(product.getName(), numSubsetProducts++);
            }
            catch (IOException e) {
                Dialogs.showError("The product could not be read:\n" + e.getMessage());
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            product = this.productToExport;
            newProductName = StringUtils.isNotNullAndNotEmpty((String)this.getCurrentFilename()) ? this.getCurrentFilename() : this.createNewProductName(product.getName(), numSubsetProducts++);
        }
        if (product != null && (approve = this.openProductSubsetDialog(product, newProductName)) && this.getDialogType() == 0) {
            this.approveSelection();
        }
        this.updateState();
    }

    private boolean openProductSubsetDialog(Product product, String newProductName) {
        this.clearCurrentSubsetProduct();
        if (product != null) {
            if (product.isMultiSize()) {
                Dialogs.showError("No subset can be created of a multi-size products.");
                return false;
            }
            ProductSubsetDialog productSubsetDialog = new ProductSubsetDialog((Window)SnapApp.getDefault().getMainFrame(), product);
            if (productSubsetDialog.show() == 1) {
                try {
                    this.subsetProduct = product.createSubset(productSubsetDialog.getProductSubsetDef(), newProductName, null);
                    if (this.getCurrentFilename() != null && !this.getCurrentFilename().startsWith("subset_")) {
                        this.setCurrentFilename("subset_" + this.getCurrentFilename());
                    }
                    return true;
                }
                catch (IOException e) {
                    Dialogs.showError("Could not create subset:\n" + e.getMessage());
                }
            }
        }
        return false;
    }

    private String createNewProductName(String sourceProductName, int productIndex) {
        String newNameBase = "";
        if (sourceProductName != null && sourceProductName.length() > 0) {
            newNameBase = FileUtils.exchangeExtension((String)sourceProductName, (String)"");
        }
        String newNamePrefix = "subset";
        String newProductName = newNameBase.length() > 0 ? newNamePrefix + "_" + productIndex + "_" + newNameBase : newNamePrefix + "_" + productIndex;
        return newProductName;
    }
}

