/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.CloseAllProductsAction;
import org.esa.snap.rcp.session.Bundle;
import org.esa.snap.rcp.session.SessionManager;

public class CloseSessionAction
extends AbstractAction {
    public static final String ID = "closeSession";
    final SessionManager sessionManager = SessionManager.getDefault();

    public CloseSessionAction() {
        super(Bundle.CTL_CloseSessionAction_MenuText());
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        productManager.addListener((ProductManager.Listener)new CloseSessionListener());
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.sessionManager.setSessionFile(null);
        CloseAllProductsAction closeProductAction = new CloseAllProductsAction();
        closeProductAction.execute();
    }

    private class CloseSessionListener
    implements ProductManager.Listener {
        private CloseSessionListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            CloseSessionAction.this.setEnabled(SnapApp.getDefault().getProductManager().getProductCount() > 0 || CloseSessionAction.this.sessionManager.getSessionFile() != null);
        }
    }
}

