/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.OpenImageViewAction;
import org.esa.snap.rcp.actions.window.OpenMetadataViewAction;
import org.esa.snap.rcp.actions.window.OpenPlacemarkViewAction;
import org.esa.snap.rcp.actions.window.OpenQuicklookViewAction;
import org.esa.snap.rcp.nodes.PNGGroup;
import org.esa.snap.rcp.nodes.PNGroupBase;
import org.esa.snap.rcp.nodes.PNNodeBase;
import org.esa.snap.rcp.nodes.PNNodeSupport;
import org.esa.snap.rcp.nodes.RastersPropertyEditor;
import org.esa.snap.rcp.nodes.UndoableProductNodeDeletion;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.lookup.Lookups;

abstract class PNNode<T extends ProductNode>
extends PNNodeBase {
    private final T productNode;
    private final PNNodeSupport nodeSupport;

    public PNNode(T productNode) {
        this(productNode, null);
    }

    public PNNode(T productNode, PNGroupBase childFactory) {
        super(childFactory, Lookups.singleton(productNode));
        this.productNode = productNode;
        this.setDisplayName(productNode.getName());
        this.setShortDescription(productNode.getDescription());
        this.nodeSupport = PNNodeSupport.create(this, childFactory);
    }

    public T getProductNode() {
        return this.productNode;
    }

    public void nodeChanged(ProductNodeEvent event) {
        if (event.getSourceNode() == this.getProductNode()) {
            if ("name".equals(event.getPropertyName())) {
                this.setDisplayName(this.getProductNode().getName());
            }
            if ("description".equals(event.getPropertyName())) {
                this.setShortDescription(this.getProductNode().getDescription());
            }
        }
        this.nodeSupport.nodeChanged(event);
    }

    public void nodeDataChanged(ProductNodeEvent event) {
        this.nodeSupport.nodeDataChanged(event);
    }

    public void nodeAdded(ProductNodeEvent event) {
        this.nodeSupport.nodeAdded(event);
    }

    public void nodeRemoved(ProductNodeEvent event) {
        this.nodeSupport.nodeRemoved(event);
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet.Set set = new Sheet.Set();
        set.setDisplayName("Product Node Properties");
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("name", String.class, "Name", "Name of the element"){

            public String getValue() {
                return PNNode.this.getProductNode().getName();
            }

            public void setValue(String newValue) {
                String oldValue = PNNode.this.productNode.getName();
                PNNodeSupport.performUndoableProductNodeEdit("Rename", PNNode.this.productNode, node -> node.setName(newValue), node -> node.setName(oldValue));
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("description", String.class, "Description", "Human-readable description of the element"){

            public String getValue() {
                return PNNode.this.getProductNode().getDescription();
            }

            public void setValue(String newValue) {
                String oldValue = PNNode.this.productNode.getDescription();
                PNNodeSupport.performUndoableProductNodeEdit("Edit Description", PNNode.this.productNode, node -> node.setDescription(newValue), node -> node.setDescription(oldValue));
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly<Boolean>("modified", Boolean.class, "Modified", "Has the element been modified?"){

            public Boolean getValue() {
                return PNNode.this.getProductNode().isModified();
            }
        });
        return new Node.PropertySet[]{set};
    }

    public Action[] getActions(boolean context) {
        T productNode1 = this.getProductNode();
        return PNNodeSupport.getContextActions(productNode1);
    }

    public static Node create(ProductNode productNode) {
        if (productNode instanceof FlagCoding) {
            return new FC((FlagCoding)productNode);
        }
        if (productNode instanceof IndexCoding) {
            return new IC((IndexCoding)productNode);
        }
        if (productNode instanceof MetadataElement) {
            return new ME((MetadataElement)productNode);
        }
        if (productNode instanceof VectorDataNode) {
            return new VDN((VectorDataNode)productNode);
        }
        if (productNode instanceof TiePointGrid) {
            return new TPG((TiePointGrid)productNode);
        }
        if (productNode instanceof Mask) {
            return new M((Mask)productNode);
        }
        if (productNode instanceof Band) {
            return new B((Band)productNode);
        }
        if (productNode instanceof Quicklook) {
            return new QL((Quicklook)productNode);
        }
        throw new IllegalStateException("unhandled product node type: " + productNode.getClass() + " named '" + productNode.getName() + "'");
    }

    private static <T extends ProductNode> void closeDocumentWindow(T productNode) {
        WindowUtilities.getOpened(DocumentWindow.class).filter(dw -> dw.getDocument() instanceof ProductNode && dw.getDocument() == productNode).forEach(dw -> DocumentWindowManager.getDefault().closeWindow(dw));
    }

    private static <T extends ProductNode> void deleteProductNode(Product product, ProductNodeGroup<T> group, T productNode) {
        PNNode.closeDocumentWindow(productNode);
        int index = group.indexOf(productNode);
        group.remove(productNode);
        UndoRedo.Manager manager = SnapApp.getDefault().getUndoManager(product);
        if (manager != null) {
            manager.addEdit(new UndoableProductNodeDeletion<T>(group, productNode, index));
        }
    }

    private static StringBuilder append(StringBuilder stringBuilder, String text) {
        if (StringUtils.isNotNullAndNotEmpty((String)text)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(text);
        }
        return stringBuilder;
    }

    private static void setAncillaryVariables(Band band, WeakHashMap<RasterDataNode, Integer> newNodes, WeakHashMap<RasterDataNode, Integer> oldNodes) {
        ArrayList<RasterDataNode> nodes = new ArrayList<RasterDataNode>(newNodes.keySet());
        Collections.sort(nodes, (n1, n2) -> (Integer)newNodes.get(n1) - (Integer)newNodes.get(n2));
        for (RasterDataNode node : nodes) {
            band.addAncillaryVariable(node, new String[0]);
        }
        oldNodes.keySet().stream().filter(oldVar -> !newNodes.containsKey(oldVar)).forEach(arg_0 -> ((Band)band).removeAncillaryVariable(arg_0));
    }

    private static WeakHashMap<RasterDataNode, Integer> toWeakMap(RasterDataNode[] oldValue) {
        WeakHashMap<RasterDataNode, Integer> oldNodes = new WeakHashMap<RasterDataNode, Integer>();
        for (int i = 0; i < oldValue.length; ++i) {
            RasterDataNode rasterDataNode = oldValue[i];
            oldNodes.put(rasterDataNode, i);
        }
        return oldNodes;
    }

    private static void updateImages(RasterDataNode rasterDataNode, boolean validMaskPropertyChanged) {
        VirtualBand virtualBand;
        if (rasterDataNode instanceof VirtualBand && (virtualBand = (VirtualBand)rasterDataNode).hasRasterData()) {
            String title = "Recomputing Raster Data";
            ProgressHandleMonitor pm = ProgressHandleMonitor.create(title);
            Runnable operation = () -> {
                try {
                    virtualBand.readRasterDataFully((ProgressMonitor)pm);
                }
                catch (IOException e) {
                    Dialogs.showError(e.getMessage());
                }
            };
            ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)title, (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
        }
        OpenImageViewAction.updateProductSceneViewImages(new RasterDataNode[]{rasterDataNode}, view -> {
            if (validMaskPropertyChanged) {
                view.updateNoDataImage();
            }
            view.updateImage();
        });
    }

    private static class NoDataValueUsedProperty
    extends PropertySupport.ReadWrite<Boolean> {
        private final RasterDataNode raster;

        public NoDataValueUsedProperty(RasterDataNode raster) {
            super("noDataValueUsed", Boolean.class, "No-Data Value Used", "Is the no-data value in use?");
            this.raster = raster;
        }

        public Boolean getValue() {
            return this.raster.isNoDataValueUsed();
        }

        public void setValue(Boolean newValue) {
            Boolean oldValue = this.raster.isNoDataValueUsed();
            PNNodeSupport.performUndoableProductNodeEdit("Edit No-Data Value Used", this.raster, node -> {
                node.setNoDataValueUsed(newValue.booleanValue());
                PNNode.updateImages(node, true);
            }, node -> {
                node.setNoDataValueUsed(oldValue.booleanValue());
                PNNode.updateImages(node, true);
            });
        }
    }

    private static class NoDataValueProperty
    extends PropertySupport.ReadWrite<Double> {
        private final RasterDataNode raster;

        public NoDataValueProperty(RasterDataNode raster) {
            super("noDataValue", Double.class, "No-Data Value", "No-data value used to indicate missing pixels");
            this.raster = raster;
        }

        public Double getValue() {
            return this.raster.getNoDataValue();
        }

        public void setValue(Double newValue) {
            double oldValue = this.raster.getNoDataValue();
            PNNodeSupport.performUndoableProductNodeEdit("Edit No-Data Value", this.raster, node -> {
                node.setNoDataValue(newValue.doubleValue());
                PNNode.updateImages(node, true);
            }, node -> {
                node.setNoDataValue(oldValue);
                PNNode.updateImages(node, true);
            });
        }
    }

    private static class ValidPixelExpressionProperty
    extends PropertySupport.ReadWrite<String> {
        private final RasterDataNode raster;

        public ValidPixelExpressionProperty(RasterDataNode raster) {
            super("validPixelExpression", String.class, "Valid-Pixel Expression", "Boolean expression which is used to identify valid pixels");
            this.raster = raster;
        }

        public String getValue() {
            String expression = this.raster.getValidPixelExpression();
            if (expression != null) {
                return expression;
            }
            return "";
        }

        public void setValue(String newValue) {
            try {
                Product product = this.raster.getProduct();
                RasterDataNode[] refRasters = BandArithmetic.getRefRasters((String)newValue, (Product[])new Product[]{product});
                if (!(refRasters.length <= 0 || BandArithmetic.areRastersEqualInSize((Product)product, (String[])new String[]{newValue}) && refRasters[0].getRasterHeight() == this.raster.getRasterHeight() && refRasters[0].getRasterWidth() == this.raster.getRasterWidth())) {
                    Dialogs.showInformation("Referenced rasters must all be the same size", null);
                } else {
                    String oldValue = this.raster.getValidPixelExpression();
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Valid-Pixel Expression", this.raster, node -> {
                        node.setValidPixelExpression(newValue);
                        PNNode.updateImages(node, true);
                    }, node -> {
                        node.setValidPixelExpression(oldValue);
                        PNNode.updateImages(node, true);
                    });
                }
            }
            catch (ParseException e) {
                Dialogs.showError("Expression is invalid: " + e.getMessage());
            }
        }
    }

    private static class UnitProperty
    extends PropertySupport.ReadWrite<String> {
        private final RasterDataNode raster;

        public UnitProperty(RasterDataNode raster) {
            super("unit", String.class, "Unit", "Geophysical Unit");
            this.raster = raster;
        }

        public String getValue() {
            return this.raster.getUnit();
        }

        public void setValue(String newValue) {
            String oldValue = this.raster.getUnit();
            PNNodeSupport.performUndoableProductNodeEdit("Edit Unit", this.raster, node -> node.setUnit(newValue), node -> node.setUnit(oldValue));
        }
    }

    private static class RasterSizeProperty
    extends PropertySupport.ReadOnly<String> {
        private final RasterDataNode raster;

        public RasterSizeProperty(RasterDataNode raster) {
            super("rasterSize", String.class, "Raster size", "Width and height of the raster in pixels");
            this.raster = raster;
        }

        public String getValue() {
            return String.format("%d x %d", this.raster.getRasterWidth(), this.raster.getRasterHeight());
        }
    }

    private static class DataTypeProperty
    extends PropertySupport.ReadOnly<String> {
        private final RasterDataNode raster;

        public DataTypeProperty(RasterDataNode raster) {
            super("dataType", String.class, "Data Type", "Raster data type");
            this.raster = raster;
        }

        public String getValue() {
            return ProductData.getTypeString((int)this.raster.getDataType());
        }
    }

    static class QL
    extends PNNode<Quicklook> {
        public QL(Quicklook ql) {
            super(ql);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/quicklook16.png");
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((Quicklook)this.getProductNode()).getProduct(), ((Quicklook)this.getProductNode()).getProduct().getQuicklookGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return new OpenQuicklookViewAction();
        }
    }

    static class B
    extends PNNode<Band> {
        public B(Band band) {
            super(band);
            if (band instanceof VirtualBand) {
                this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsBandVirtual16.gif");
            } else if (band.isFlagBand()) {
                this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsBandFlags16.gif");
            } else {
                this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsBandAsSwath.gif");
            }
            if ((double)band.getSpectralWavelength() > 0.0) {
                if (band.getSpectralWavelength() == (float)Math.round(band.getSpectralWavelength())) {
                    this.setDisplayName(String.format("%s (%d nm)", band.getName(), (int)band.getSpectralWavelength()));
                } else {
                    this.setDisplayName(String.format("%s (%s nm)", band.getName(), String.valueOf(band.getSpectralWavelength())));
                }
            }
            this.setShortDescription(this.createToolTip(band));
        }

        private String createToolTip(Band band) {
            StringBuilder tooltip = new StringBuilder();
            PNNode.append(tooltip, band.getDescription());
            if ((double)band.getSpectralWavelength() > 0.0) {
                PNNode.append(tooltip, String.format("%s nm", Float.valueOf(band.getSpectralWavelength())));
                if ((double)band.getSpectralBandwidth() > 0.0) {
                    PNNode.append(tooltip, String.format("+/-%s nm", 0.5 * (double)band.getSpectralBandwidth()));
                }
            }
            PNNode.append(tooltip, String.format("%d x %d pixels", band.getRasterWidth(), band.getRasterHeight()));
            if (band instanceof VirtualBand) {
                PNNode.append(tooltip, String.format("Expr.: %s", ((VirtualBand)band).getExpression()));
            }
            if (band.getUnit() != null) {
                PNNode.append(tooltip, String.format(" (%s)", band.getUnit()));
            }
            return tooltip.toString();
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((Band)this.getProductNode()).getProduct(), ((Band)this.getProductNode()).getProduct().getBandGroup(), this.getProductNode());
        }

        public Transferable clipboardCopy() throws IOException {
            return super.clipboardCopy();
        }

        public boolean canCopy() {
            return true;
        }

        public Transferable clipboardCut() throws IOException {
            return super.clipboardCut();
        }

        public boolean canCut() {
            return true;
        }

        public Action getPreferredAction() {
            return OpenImageViewAction.create((RasterDataNode)this.getProductNode(), true);
        }

        @Override
        public Node.PropertySet[] getPropertySets() {
            Sheet.Set set = new Sheet.Set();
            final Band band = (Band)this.getProductNode();
            set.setDisplayName("Raster Band Properties");
            set.put((Node.Property)new UnitProperty((RasterDataNode)band));
            set.put((Node.Property)new DataTypeProperty((RasterDataNode)band));
            set.put((Node.Property)new RasterSizeProperty((RasterDataNode)band));
            if (band instanceof VirtualBand) {
                final VirtualBand virtualBand = (VirtualBand)band;
                set.put((Node.Property)new PropertySupport.ReadWrite<String>("expression", String.class, "Pixel-Value Expression", "Mathematical expression used to compute the raster's pixel values"){

                    public String getValue() {
                        return virtualBand.getExpression();
                    }

                    public void setValue(String newValue) {
                        String oldValue = virtualBand.getExpression();
                        PNNodeSupport.performUndoableProductNodeEdit("Edit Pixel-Value Expression", virtualBand, node -> {
                            node.setExpression(newValue);
                            PNNode.updateImages((RasterDataNode)node, false);
                        }, node -> {
                            node.setExpression(oldValue);
                            PNNode.updateImages((RasterDataNode)node, false);
                        });
                    }
                });
            }
            set.put((Node.Property)new ValidPixelExpressionProperty((RasterDataNode)band));
            set.put((Node.Property)new NoDataValueUsedProperty((RasterDataNode)band));
            set.put((Node.Property)new NoDataValueProperty((RasterDataNode)band));
            set.put((Node.Property)new PropertySupport.ReadWrite<Float>("spectralWavelength", Float.class, "Spectral Wavelength", "The spectral wavelength in nanometers"){

                public Float getValue() {
                    return Float.valueOf(band.getSpectralWavelength());
                }

                public void setValue(Float newValue) {
                    float oldValue = band.getSpectralWavelength();
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Spectral Wavelength", band, node -> node.setSpectralWavelength(newValue.floatValue()), node -> node.setSpectralWavelength(oldValue));
                }
            });
            set.put((Node.Property)new PropertySupport.ReadWrite<Float>("spectralBandWidth", Float.class, "Spectral Bandwidth", "The spectral bandwidth in nanometers"){

                public Float getValue() {
                    return Float.valueOf(band.getSpectralBandwidth());
                }

                public void setValue(Float newValue) {
                    float oldValue = band.getSpectralBandwidth();
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Spectral Bandwidth", band, node -> node.setSpectralBandwidth(newValue.floatValue()), node -> node.setSpectralBandwidth(oldValue));
                }
            });
            PropertySupport.ReadWrite<RasterDataNode[]> ancillaryVariables = new PropertySupport.ReadWrite<RasterDataNode[]>("ancillaryVariables", RasterDataNode[].class, "Ancillary Variables", "Other rasters that are ancillary variables for this raster (NetCDF-U 'ancillary_variables' attribute)"){
                private WeakReference<RastersPropertyEditor> propertyEditorRef;

                public RasterDataNode[] getValue() {
                    return band.getAncillaryVariables(new String[0]);
                }

                public void setValue(RasterDataNode[] newValue) {
                    WeakHashMap oldNodes = PNNode.toWeakMap(band.getAncillaryVariables(new String[0]));
                    WeakHashMap newNodes = PNNode.toWeakMap(newValue);
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Ancillary Variables", band, node -> PNNode.setAncillaryVariables(node, newNodes, oldNodes), node -> PNNode.setAncillaryVariables(node, oldNodes, newNodes));
                }

                public PropertyEditor getPropertyEditor() {
                    RastersPropertyEditor propertyEditor = null;
                    if (this.propertyEditorRef != null) {
                        propertyEditor = (RastersPropertyEditor)this.propertyEditorRef.get();
                    }
                    if (propertyEditor == null) {
                        propertyEditor = new RastersPropertyEditor((RasterDataNode[])band.getProduct().getBands());
                        this.propertyEditorRef = new WeakReference<RastersPropertyEditor>(propertyEditor);
                    }
                    return propertyEditor;
                }
            };
            set.put((Node.Property)ancillaryVariables);
            set.put((Node.Property)new PropertySupport.ReadWrite<String[]>("ancillaryRelations", String[].class, "Ancillary Relations", "Relation names if this raster is an ancillary variable (NetCDF-U 'rel' attribute)"){

                public String[] getValue() {
                    return band.getAncillaryRelations();
                }

                public void setValue(String[] newValue) {
                    String[] oldValue = band.getAncillaryRelations();
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Ancillary Relations", band, node -> node.setAncillaryRelations(newValue), node -> node.setAncillaryRelations(oldValue));
                }
            });
            return (Node.PropertySet[])Stream.concat(Stream.of(super.getPropertySets()), Stream.of(set)).toArray(Node.PropertySet[]::new);
        }
    }

    static class M
    extends PNNode<Mask> {
        public M(Mask mask) {
            super(mask);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsMask16.gif");
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((Mask)this.getProductNode()).getProduct(), ((Mask)this.getProductNode()).getProduct().getMaskGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return OpenImageViewAction.create((RasterDataNode)this.getProductNode(), true);
        }
    }

    static class TPG
    extends PNNode<TiePointGrid> {
        public TPG(TiePointGrid tiePointGrid) {
            super(tiePointGrid);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsBandAsTiePoint16.gif");
            this.setShortDescription(this.createToolTip(tiePointGrid));
        }

        private String createToolTip(TiePointGrid tiePointGrid) {
            StringBuilder tooltip = new StringBuilder();
            PNNode.append(tooltip, tiePointGrid.getDescription());
            PNNode.append(tooltip, String.format("%d x %d --> %d x %d pixels", tiePointGrid.getGridWidth(), tiePointGrid.getGridHeight(), tiePointGrid.getRasterWidth(), tiePointGrid.getRasterHeight()));
            if (tiePointGrid.getUnit() != null) {
                PNNode.append(tooltip, String.format(" (%s)", tiePointGrid.getUnit()));
            }
            return tooltip.toString();
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((TiePointGrid)this.getProductNode()).getProduct(), ((TiePointGrid)this.getProductNode()).getProduct().getTiePointGridGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return OpenImageViewAction.create((RasterDataNode)this.getProductNode(), true);
        }

        @Override
        public Node.PropertySet[] getPropertySets() {
            Sheet.Set set = new Sheet.Set();
            TiePointGrid tpg = (TiePointGrid)this.getProductNode();
            set.setDisplayName("Tie-Point Grid Properties");
            set.put((Node.Property)new UnitProperty((RasterDataNode)tpg));
            set.put((Node.Property)new RasterSizeProperty((RasterDataNode)tpg));
            set.put((Node.Property)new ValidPixelExpressionProperty((RasterDataNode)tpg));
            set.put((Node.Property)new NoDataValueUsedProperty((RasterDataNode)tpg));
            set.put((Node.Property)new NoDataValueProperty((RasterDataNode)tpg));
            return (Node.PropertySet[])Stream.concat(Stream.of(super.getPropertySets()), Stream.of(set)).toArray(Node.PropertySet[]::new);
        }
    }

    static class VDN
    extends PNNode<VectorDataNode> {
        public VDN(VectorDataNode vectorDataNode) {
            super(vectorDataNode);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsVectorData16.gif");
            this.setShortDescription(this.createToolTip(vectorDataNode));
        }

        private String createToolTip(VectorDataNode vectorDataNode) {
            StringBuilder tooltip = new StringBuilder();
            PNNode.append(tooltip, vectorDataNode.getDescription());
            PNNode.append(tooltip, String.format("type %s, %d feature(s)", vectorDataNode.getFeatureType().getTypeName(), vectorDataNode.getFeatureCollection().size()));
            return tooltip.toString();
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((VectorDataNode)this.getProductNode()).getProduct(), ((VectorDataNode)this.getProductNode()).getProduct().getVectorDataGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return new OpenPlacemarkViewAction();
        }

        @Override
        public Node.PropertySet[] getPropertySets() {
            Sheet.Set set = new Sheet.Set();
            final VectorDataNode vdn = (VectorDataNode)this.getProductNode();
            set.setDisplayName("Vector Data Properties");
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("featureType", String.class, "Feature type", "The feature type schema used for all features in the collection"){

                public String getValue() {
                    return vdn.getFeatureType().getTypeName();
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("featureGeomType", String.class, "Feature geometry type", "The geometry type used used for all feature geometries in the collection"){

                public String getValue() {
                    GeometryDescriptor geometryDescriptor = vdn.getFeatureType().getGeometryDescriptor();
                    Class binding = geometryDescriptor != null ? geometryDescriptor.getType().getBinding() : null;
                    return binding != null ? binding.getName() : "<unknown>";
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("featureCRS", String.class, "Feature geometry CRS", "The coordinate reference system used used for all feature geometries in the collection"){

                public String getValue() {
                    GeometryDescriptor geometryDescriptor = vdn.getFeatureType().getGeometryDescriptor();
                    CoordinateReferenceSystem crs = geometryDescriptor != null ? geometryDescriptor.getType().getCoordinateReferenceSystem() : null;
                    return crs != null ? crs.toString() : "<unknown>";
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<Integer>("featureCount", Integer.class, "Feature count", "The number of features in this collection"){

                public Integer getValue() {
                    return vdn.getFeatureCollection().size();
                }
            });
            return (Node.PropertySet[])Stream.concat(Stream.of(super.getPropertySets()), Stream.of(set)).toArray(Node.PropertySet[]::new);
        }
    }

    static class FC
    extends PNNode<FlagCoding> {
        public FC(FlagCoding flagCoding) {
            super(flagCoding);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsBandFlags16.gif");
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((FlagCoding)this.getProductNode()).getProduct(), ((FlagCoding)this.getProductNode()).getProduct().getFlagCodingGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return new OpenMetadataViewAction();
        }
    }

    static class IC
    extends PNNode<IndexCoding> {
        public IC(IndexCoding indexCoding) {
            super(indexCoding);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsBandIndexes16.gif");
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((IndexCoding)this.getProductNode()).getProduct(), ((IndexCoding)this.getProductNode()).getProduct().getIndexCodingGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return new OpenMetadataViewAction();
        }
    }

    static class ME
    extends PNNode<MetadataElement> {
        public ME(MetadataElement element) {
            super(element, element.getElementGroup() != null ? new PNGGroup.ME((ProductNodeGroup<MetadataElement>)element.getElementGroup()) : null);
            this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsMetaData16.gif");
        }

        public boolean canDestroy() {
            return ((MetadataElement)this.getProductNode()).getParentElement() != null;
        }

        public void destroy() throws IOException {
            PNNode.deleteProductNode(((MetadataElement)this.getProductNode()).getProduct(), ((MetadataElement)this.getProductNode()).getParentElement().getElementGroup(), this.getProductNode());
        }

        public Action getPreferredAction() {
            return new OpenMetadataViewAction();
        }
    }
}

