/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.metadata.MetadataViewTopComponent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class OpenMetadataViewAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private Lookup lookup;
    private final Lookup.Result<ProductNode> result;

    public OpenMetadataViewAction() {
        this(Utilities.actionsGlobalContext());
    }

    public OpenMetadataViewAction(Lookup lookup) {
        this.lookup = lookup;
        this.result = lookup.lookupResult(ProductNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_OpenMetadataViewAction_MenuText());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new OpenMetadataViewAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        this.setEnabled(productNode != null && productNode instanceof MetadataElement);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openMetadataView((MetadataElement)SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER));
    }

    public void openMetadataView(MetadataElement element) {
        this.openDocumentWindow(element);
    }

    private MetadataViewTopComponent openDocumentWindow(MetadataElement element) {
        MetadataViewTopComponent metadataViewTopComponent = new MetadataViewTopComponent(element);
        DocumentWindowManager.getDefault().openWindow((DocumentWindow)metadataViewTopComponent);
        metadataViewTopComponent.requestSelected();
        return metadataViewTopComponent;
    }
}

