/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.actions.window.OpenRGBImageViewAction;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.HSVImageProfilePane;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.HelpCtx;

public class OpenHSVImageViewAction
extends AbstractAction
implements HelpCtx.Provider {
    private static final String HELP_ID = "hsvImageProfile";
    private Product product;
    private static final String r = "min(round( (floor((6*(h))%6)==0?(v): (floor((6*(h))%6)==1?((1-((s)*((6*(h))%6)-floor((6*(h))%6)))*(v)): (floor((6*(h))%6)==2?((1-(s))*(v)): (floor((6*(h))%6)==3?((1-(s))*(v)): (floor((6*(h))%6)==4?((1-((s)*(1-((6*(h))%6)-floor((6*(h))%6))))*(v)): (floor((6*(h))%6)==5?(v):0)))))) *256), 255)";
    private static final String g = "min(round( (floor((6*(h))%6)==0?((1-((s)*(1-((6*(h))%6)-floor((6*(h))%6))))*(v)): (floor((6*(h))%6)==1?(v): (floor((6*(h))%6)==2?(v): (floor((6*(h))%6)==3?((1-((s)*((6*(h))%6)-floor((6*(h))%6)))*(v)): (floor((6*(h))%6)==4?((1-(s))*(v)): (floor((6*(h))%6)==5?((1-(s))*(v)):0)))))) *256), 255)";
    private static final String b = "min(round( (floor((6*(h))%6)==0?((1-(s))*(v)): (floor((6*(h))%6)==1?((1-(s))*(v)): (floor((6*(h))%6)==2?((1-((s)*(1-((6*(h))%6)-floor((6*(h))%6))))*(v)): (floor((6*(h))%6)==3?(v): (floor((6*(h))%6)==4?(v): (floor((6*(h))%6)==5?((1-((s)*((6*(h))%6)-floor((6*(h))%6)))*(v)):0)))))) *256), 255)";

    public OpenHSVImageViewAction(ProductNode node) {
        super(Bundle.CTL_OpenHSVImageViewAction_MenuText());
        this.product = node.getProduct();
        this.putValue("ShortDescription", Bundle.CTL_OpenHSVImageViewAction_ShortDescription());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.product != null) {
            this.openProductSceneViewHSV(this.product, HELP_ID);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public void openProductSceneViewHSV(Product hsvProduct, String helpId) {
        Product[] openedProducts = SnapApp.getDefault().getProductManager().getProducts();
        int[] defaultBandIndices = OpenRGBImageViewAction.getDefaultBandIndices(hsvProduct);
        HSVImageProfilePane profilePane = new HSVImageProfilePane(SnapApp.getDefault().getPreferencesPropertyMap(), hsvProduct, openedProducts, defaultBandIndices);
        String title = "Select HSV-Image Channels";
        boolean ok = profilePane.showDialog((Window)SnapApp.getDefault().getMainFrame(), "Select HSV-Image Channels", helpId);
        if (!ok) {
            return;
        }
        String[] hsvExpressions = profilePane.getRgbaExpressions();
        OpenHSVImageViewAction.nomalizeHSVExpressions(hsvProduct, hsvExpressions);
        if (profilePane.getStoreProfileInProduct()) {
            RGBImageProfile.storeRgbaExpressions((Product)hsvProduct, (String[])hsvExpressions, (String[])HSVImageProfilePane.HSV_COMP_NAMES);
        }
        String sceneName = OpenRGBImageViewAction.createSceneName(hsvProduct, profilePane.getSelectedProfile(), "HSV");
        this.openProductSceneViewHSV(sceneName, hsvProduct, hsvExpressions);
    }

    public void openProductSceneViewHSV(final String name, final Product product, final String[] hsvExpressions) {
        ProgressMonitorSwingWorker<ProductSceneImage, Object> worker = new ProgressMonitorSwingWorker<ProductSceneImage, Object>((Component)SnapApp.getDefault().getMainFrame(), SnapApp.getDefault().getInstanceName() + " - Creating image for '" + name + '\''){

            protected ProductSceneImage doInBackground(ProgressMonitor pm) throws Exception {
                return OpenHSVImageViewAction.createProductSceneImageHSV(name, product, hsvExpressions, pm);
            }

            protected void done() {
                SnapApp.getDefault().getMainFrame().setCursor(Cursor.getDefaultCursor());
                String errorMsg = "The HSV image view could not be created.";
                try {
                    ProductSceneView productSceneView = new ProductSceneView((ProductSceneImage)this.get());
                    OpenRGBImageViewAction.openDocumentWindow(productSceneView);
                }
                catch (OutOfMemoryError e) {
                    Dialogs.showOutOfMemoryError(errorMsg);
                    return;
                }
                catch (Exception e) {
                    SnapApp.getDefault().handleError(errorMsg, e);
                    return;
                }
                SnapApp.getDefault().setStatusBarMessage("");
            }
        };
        SnapApp.getDefault().setStatusBarMessage("Creating HSV image view...");
        UIUtils.setRootFrameWaitCursor((Component)SnapApp.getDefault().getMainFrame());
        worker.execute();
    }

    private static ProductSceneImage createProductSceneImageHSV(String name, Product product, String[] hsvExpressions, ProgressMonitor pm) throws Exception {
        UIUtils.setRootFrameWaitCursor((Component)SnapApp.getDefault().getMainFrame());
        Band[] rgbBands = null;
        boolean errorOccured = false;
        ProductSceneImage productSceneImage = null;
        try {
            pm.beginTask("Creating HSV image...", 2);
            String[] rgbaExpressions = OpenHSVImageViewAction.convertHSVToRGBExpressions(hsvExpressions);
            rgbBands = OpenRGBImageViewAction.allocateRgbBands(product, rgbaExpressions);
            productSceneImage = new ProductSceneImage(name, (RasterDataNode)rgbBands[0], (RasterDataNode)rgbBands[1], (RasterDataNode)rgbBands[2], SnapApp.getDefault().getPreferencesPropertyMap(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            productSceneImage.initVectorDataCollectionLayer();
            productSceneImage.initMaskCollectionLayer();
        }
        catch (Exception e) {
            try {
                errorOccured = true;
                throw e;
            }
            catch (Throwable throwable) {
                pm.done();
                if (rgbBands != null) {
                    OpenRGBImageViewAction.releaseRgbBands(rgbBands, errorOccured);
                }
                throw throwable;
            }
        }
        pm.done();
        if (rgbBands != null) {
            OpenRGBImageViewAction.releaseRgbBands(rgbBands, errorOccured);
        }
        return productSceneImage;
    }

    private static void nomalizeHSVExpressions(Product product, String[] hsvExpressions) {
        boolean modified = product.isModified();
        int i = 0;
        for (String exp : hsvExpressions) {
            if (exp.isEmpty()) continue;
            String checkForNoDataValue = "";
            Band virtBand = OpenHSVImageViewAction.createVirtualBand(product, exp, "tmpVirtBand" + i);
            Stx stx = virtBand.getStx(false, ProgressMonitor.NULL);
            if (stx != null) {
                double min = stx.getMinimum();
                double range = stx.getMaximum() - min;
                hsvExpressions[i] = "min(max((((" + exp + ")- " + min + ")/" + range + "), 0), 1)";
            }
            product.removeBand(virtBand);
            ++i;
        }
        product.setModified(modified);
    }

    private static String getCheckForNoDataExpression(Product product, String exp) {
        String[] bandNames = product.getBandNames();
        StringBuilder checkForNoData = new StringBuilder("(" + exp + " == NaN");
        if (StringUtils.contains((String[])bandNames, (String)exp)) {
            double nodatavalue = product.getBand(exp).getNoDataValue();
            checkForNoData.append(" or " + exp + " == " + nodatavalue);
        }
        checkForNoData.append(") ? NaN : ");
        return checkForNoData.toString();
    }

    public static Band createVirtualBand(Product product, String expression, String name) {
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        try {
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters((String)expression, (Product[])new Product[]{product});
            if (refRasters.length > 0) {
                width = refRasters[0].getRasterWidth();
                height = refRasters[0].getRasterHeight();
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + expression);
        }
        VirtualBand virtBand = new VirtualBand(name, 31, width, height, expression);
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
        return virtBand;
    }

    private static String[] convertHSVToRGBExpressions(String[] hsvExpressions) {
        String h = hsvExpressions[0].isEmpty() ? "0" : hsvExpressions[0];
        String s = hsvExpressions[1].isEmpty() ? "0" : hsvExpressions[1];
        String v = hsvExpressions[2].isEmpty() ? "0" : hsvExpressions[2];
        String[] rgbExpressions = new String[]{r.replace("(h)", '(' + h + ')').replace("(s)", '(' + s + ')').replace("(v)", '(' + v + ')'), g.replace("(h)", '(' + h + ')').replace("(s)", '(' + s + ')').replace("(v)", '(' + v + ')'), b.replace("(h)", '(' + h + ')').replace("(s)", '(' + s + ')').replace("(v)", '(' + v + ')')};
        return rgbExpressions;
    }
}

