/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportGeometryAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
HelpCtx.Provider {
    private static final String ESRI_SHAPEFILE = "ESRI Shapefile";
    private static final String FILE_EXTENSION_SHAPEFILE = ".shp";
    private final Lookup.Result<VectorDataNode> result;
    private final Lookup lookup;
    private String HELP_ID = "exportShapefile";
    private VectorDataNode vectorDataNode;

    public ExportGeometryAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportGeometryAction(Lookup lookup) {
        super(Bundle.CTL_ExportGeometryAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(VectorDataNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.vectorDataNode = (VectorDataNode)lookup.lookup(VectorDataNode.class);
        this.setEnabled(this.vectorDataNode != null);
    }

    private static File promptForFile(String defaultFileName) {
        return Dialogs.requestFileForSave(Bundle.CTL_ExportGeometryAction_DialogTitle(), false, (FileFilter)new SnapFileFilter(ESRI_SHAPEFILE, FILE_EXTENSION_SHAPEFILE, ESRI_SHAPEFILE), FILE_EXTENSION_SHAPEFILE, defaultFileName, null, "exportVectorDataNode.lastDir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportVectorDataNode(VectorDataNode vectorNode, File file, ProgressMonitor pm) throws IOException {
        Map<Class<?>, List<SimpleFeature>> featureListMap = ExportGeometryAction.createGeometryToFeaturesListMap(vectorNode);
        if (featureListMap.size() > 1) {
            String msg = "The selected geometry contains different types of shapes.\nEach type of shape will be exported as a separate shapefile.";
            Dialogs.showInformation(Bundle.CTL_ExportGeometryAction_DialogTitle(), "The selected geometry contains different types of shapes.\nEach type of shape will be exported as a separate shapefile.", ExportGeometryAction.class.getName() + ".exportInfo");
        }
        Set<Map.Entry<Class<?>, List<SimpleFeature>>> entries = featureListMap.entrySet();
        pm.beginTask("Writing ESRI Shapefiles...", featureListMap.size());
        try {
            for (Map.Entry<Class<?>, List<SimpleFeature>> entry : entries) {
                ExportGeometryAction.writeEsriShapefile(entry.getKey(), entry.getValue(), file);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private static void writeEsriShapefile(Class<?> geomType, List<SimpleFeature> features, File file) throws IOException {
        String geomName = geomType.getSimpleName();
        String basename = file.getName();
        if (basename.endsWith(FILE_EXTENSION_SHAPEFILE)) {
            basename = basename.substring(0, basename.length() - 4);
        }
        File file1 = new File(file.getParentFile(), basename + "_" + geomName + FILE_EXTENSION_SHAPEFILE);
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        Map<String, URL> map = Collections.singletonMap("url", file1.toURI().toURL());
        DataStore dataStore = factory.createNewDataStore(map);
        SimpleFeature simpleFeature = features.get(0);
        SimpleFeatureType simpleFeatureType = ExportGeometryAction.changeGeometryType(simpleFeature.getType(), geomType);
        String typeName = simpleFeatureType.getName().getLocalPart();
        dataStore.createSchema((FeatureType)simpleFeatureType);
        FeatureStore featureStore = (FeatureStore)dataStore.getFeatureSource(typeName);
        DefaultTransaction transaction = new DefaultTransaction("X");
        featureStore.setTransaction((Transaction)transaction);
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        featureStore.addFeatures((FeatureCollection)featureCollection);
        try {
            transaction.commit();
        }
        catch (IOException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    private static Map<Class<?>, List<SimpleFeature>> createGeometryToFeaturesListMap(VectorDataNode vectorNode) {
        Object modelCrs;
        FeatureCollection featureCollection = vectorNode.getFeatureCollection();
        CoordinateReferenceSystem crs = vectorNode.getFeatureType().getCoordinateReferenceSystem();
        if (crs == null) {
            crs = vectorNode.getProduct().getSceneGeoCoding().getImageCRS();
        }
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)(modelCrs = vectorNode.getProduct().getSceneGeoCoding() instanceof CrsGeoCoding ? vectorNode.getProduct().getSceneCRS() : DefaultGeographicCRS.WGS84))) {
            featureCollection = new ReprojectingFeatureCollection(featureCollection, crs, (CoordinateReferenceSystem)modelCrs);
        }
        HashMap featureListMap = new HashMap();
        FeatureIterator featureIterator = featureCollection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            Object defaultGeometry = feature.getDefaultGeometry();
            Class<?> geometryType = defaultGeometry.getClass();
            ArrayList<SimpleFeature> featureList = (ArrayList<SimpleFeature>)featureListMap.get(geometryType);
            if (featureList == null) {
                featureList = new ArrayList<SimpleFeature>();
                featureListMap.put(geometryType, featureList);
            }
            featureList.add(feature);
        }
        return featureListMap;
    }

    private static SimpleFeatureType changeGeometryType(SimpleFeatureType original, Class<?> geometryType) {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.setCRS(original.getCoordinateReferenceSystem());
        sftb.setDefaultGeometry(original.getGeometryDescriptor().getLocalName());
        sftb.add(original.getGeometryDescriptor().getLocalName(), geometryType);
        for (AttributeDescriptor descriptor : original.getAttributeDescriptors()) {
            if (original.getGeometryDescriptor().getLocalName().equals(descriptor.getLocalName())) continue;
            sftb.add(descriptor);
        }
        sftb.setName("FT_" + geometryType.getSimpleName());
        return sftb.buildFeatureType();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportVectorDataNode();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.HELP_ID);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ExportGeometryAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.vectorDataNode = (VectorDataNode)this.lookup.lookup(VectorDataNode.class);
        this.setEnabled(this.vectorDataNode != null);
    }

    private void exportVectorDataNode() {
        SnapApp snapApp = SnapApp.getDefault();
        if (this.vectorDataNode.getFeatureCollection().isEmpty()) {
            Dialogs.showInformation(Bundle.CTL_ExportGeometryAction_DialogTitle(), "The selected geometry is empty. Nothing to export.", null);
            return;
        }
        File file = ExportGeometryAction.promptForFile(this.vectorDataNode.getName());
        if (file == null) {
            return;
        }
        ExportVectorNodeSwingWorker swingWorker = new ExportVectorNodeSwingWorker(snapApp, this.vectorDataNode, file);
        UIUtils.setRootFrameWaitCursor((Component)snapApp.getMainFrame());
        snapApp.setStatusBarMessage("Exporting Geometry...");
        ((SwingWorker)((Object)swingWorker)).execute();
    }

    private static class ExportVectorNodeSwingWorker
    extends ProgressMonitorSwingWorker<Exception, Object> {
        private final SnapApp snapApp;
        private final VectorDataNode vectorDataNode;
        private final File file;

        private ExportVectorNodeSwingWorker(SnapApp snapApp, VectorDataNode vectorDataNode, File file) {
            super((Component)snapApp.getMainFrame(), Bundle.CTL_ExportGeometryAction_DialogTitle());
            this.snapApp = snapApp;
            this.vectorDataNode = vectorDataNode;
            this.file = file;
        }

        protected Exception doInBackground(ProgressMonitor pm) throws Exception {
            try {
                ExportGeometryAction.exportVectorDataNode(this.vectorDataNode, this.file, pm);
            }
            catch (IOException e) {
                return e;
            }
            return null;
        }

        public void done() {
            Exception exception = null;
            try {
                UIUtils.setRootFrameDefaultCursor((Component)SnapApp.getDefault().getMainFrame());
                this.snapApp.setStatusBarMessage("");
                exception = (Exception)this.get();
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e;
            }
            finally {
                if (exception != null) {
                    exception.printStackTrace();
                    Dialogs.showError(Bundle.CTL_ExportGeometryAction_DialogTitle(), "Can not export geometry.\n" + exception.getMessage());
                }
            }
        }
    }
}

