/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.DummyProductBuilder;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.esa.snap.rcp.nodes.ProductGroupNode;
import org.esa.snap.rcp.windows.Bundle;
import org.esa.snap.runtime.Config;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ProductExplorerTopComponent", iconBase="org/esa/snap/rcp/icons/RsProduct16.gif", persistenceType=0)
public class ProductExplorerTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private final ExplorerManager explorerManager = new ExplorerManager();
    private DndBeanTreeView treeView;

    public ProductExplorerTopComponent() {
        this.initComponents();
        this.setName("Product_Explorer");
        this.setDisplayName(Bundle.CTL_ProductExplorerTopComponentName());
        this.setToolTipText(Bundle.CTL_ProductExplorerTopComponentDescription());
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.treeView = new DndBeanTreeView();
        this.treeView.setRootVisible(false);
        this.add((Component)((Object)this.treeView), "Center");
        if (Config.instance().preferences().getBoolean("snap.debug.loadTestProducts", false)) {
            Product[] products;
            SystemUtils.LOG.info("Loading test products...");
            for (Product product : products = DummyProductBuilder.createTestProducts()) {
                SystemUtils.LOG.info("Loading test product " + product.getName());
                SnapApp.getDefault().getProductManager().addProduct(product);
            }
        }
        ProductGroupNode rootNode = new ProductGroupNode(SnapApp.getDefault().getProductManager());
        this.explorerManager.setRootContext((Node)rootNode);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map));
        final InputOutput io = IOProvider.getDefault().getIO("Explorer Selection", true);
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){
            final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedNodes")) {
                    Node[] selectedNode;
                    for (Node node : selectedNode = (Node[])evt.getNewValue()) {
                        String timeText = this.timeFormat.format(System.currentTimeMillis());
                        io.getOut().println(timeText + ": " + node.getDisplayName());
                    }
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public boolean isNodeExpanded(Node node) {
        return this.treeView.isExpanded(node);
    }

    public void expandNode(Node node) {
        this.treeView.expandNode(node);
    }

    private static class ProductExplorerDropTarget
    extends DropTargetAdapter {
        private ProductExplorerDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable transferable = dtde.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (fileList.size() > 0) {
                        OpenProductAction open = new OpenProductAction();
                        open.setFiles(fileList.toArray(new File[fileList.size()]));
                        dtde.dropComplete(Boolean.TRUE.equals(open.execute()));
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException | IOException ignored) {
                dtde.rejectDrop();
            }
        }
    }

    private static class DndBeanTreeView
    extends BeanTreeView {
        public DndBeanTreeView() {
            this.tree.setDropTarget(new DropTarget(this.tree, new ProductExplorerDropTarget()));
        }
    }
}

