/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class MultiSizeIssue {
    private MultiSizeIssue() {
    }

    public static void showMultiSizeWarning() {
        boolean storeResult;
        String title = Dialogs.getDialogTitle("Limited Functionality");
        String msgText = "Please note that you have opened a product which contains <br/>raster of different sizes. Not all features of SNAP will work with this product. <br/>More info about this issue and its status can be found in the <a href=\"https://senbox.atlassian.net/browse/SNAP-1\">SNAP Issue Tracker</a>";
        String prefKey = "snap.multiSizeInfo.dontShow";
        String decision = SnapApp.getDefault().getPreferences().get("snap.multiSizeInfo.dontShow", "");
        if ("true".equals(decision)) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        JEditorPane textPane = new JEditorPane("text/html", "Please note that you have opened a product which contains <br/>raster of different sizes. Not all features of SNAP will work with this product. <br/>More info about this issue and its status can be found in the <a href=\"https://senbox.atlassian.net/browse/SNAP-1\">SNAP Issue Tracker</a>");
        MultiSizeIssue.setFont(textPane);
        textPane.setEditable(false);
        textPane.setOpaque(false);
        textPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (IOException | URISyntaxException e1) {
                    Dialogs.showWarning("Could not open URL: " + e.getDescription());
                }
            }
        });
        panel.add((Component)textPane, "Center");
        JCheckBox dontShowCheckBox = new JCheckBox("Don't show this message anymore.", false);
        panel.add((Component)dontShowCheckBox, "South");
        NotifyDescriptor d = new NotifyDescriptor((Object)panel, title, -1, 1, null, null);
        DialogDisplayer.getDefault().notify(d);
        if (d.getValue() != NotifyDescriptor.CANCEL_OPTION && (storeResult = dontShowCheckBox.isSelected())) {
            SnapApp.getDefault().getPreferences().put("snap.multiSizeInfo.dontShow", "true");
        }
    }

    public static boolean isMultiSize(Product selectedProduct) {
        return selectedProduct != null && selectedProduct.isMultiSizeProduct();
    }

    private static void setFont(JEditorPane textPane) {
        if (textPane.getDocument() instanceof HTMLDocument) {
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(bodyRule);
        }
    }
}

