/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import com.bc.ceres.core.Assert;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Bundle;
import org.esa.snap.ui.SnapFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class Dialogs {
    public static final String PREF_KEY_SUFFIX_DONTSHOW = ".dontShow";
    private static final String PREF_KEY_SUFFIX_DECISION = ".decision";
    private static final String PREF_VALUE_YES = "yes";
    private static final String PREF_VALUE_NO = "no";
    private static final String PREF_VALUE_TRUE = "true";

    private Dialogs() {
    }

    public static void showInformation(String message) {
        Dialogs.showInformation(message, null);
    }

    public static void showInformation(String message, String preferencesKey) {
        Dialogs.showInformation(Bundle.LBL_Information(), message, preferencesKey);
    }

    public static void showInformation(String title, String message, String preferencesKey) {
        Dialogs.showMessage(title != null ? title : Bundle.LBL_Information(), message, 1, preferencesKey);
    }

    public static void showWarning(String message) {
        Dialogs.showWarning(null, message, null);
    }

    public static void showWarning(String title, String message, String preferencesKey) {
        Dialogs.showMessage(title != null ? title : Bundle.LBL_Warning(), message, 2, preferencesKey);
    }

    public static void showError(String message) {
        Dialogs.showError(null, message);
    }

    public static void showError(String title, String message) {
        Dialogs.showMessage(title != null ? title : Bundle.LBL_Error(), message, 0, null);
    }

    public static void showOutOfMemoryError(String message) {
        Dialogs.showError("Out of Memory", String.format("%s\n\nYou can try to release memory by closing products or image views which\nyou currently not really need.", message));
    }

    public static void showMessage(String title, String message, int messageType, String preferencesKey) {
        title = Dialogs.getDialogTitle(title != null ? title : Bundle.LBL_Message());
        if (preferencesKey != null) {
            boolean storeResult;
            String decision = Dialogs.getPreferences().get(preferencesKey + PREF_KEY_SUFFIX_DONTSHOW, "");
            if (decision.equals(PREF_VALUE_TRUE)) {
                return;
            }
            JPanel panel = new JPanel(new BorderLayout(4, 4));
            panel.add((Component)new JLabel(message), "Center");
            JCheckBox dontShowCheckBox = new JCheckBox(Bundle.LBL_DoNotShowThisMessage(), false);
            panel.add((Component)dontShowCheckBox, "South");
            NotifyDescriptor d = new NotifyDescriptor((Object)panel, title, -1, messageType, null, null);
            DialogDisplayer.getDefault().notify(d);
            if (d.getValue() != NotifyDescriptor.CANCEL_OPTION && (storeResult = dontShowCheckBox.isSelected())) {
                Dialogs.getPreferences().put(preferencesKey + PREF_KEY_SUFFIX_DONTSHOW, PREF_VALUE_TRUE);
            }
        } else {
            NotifyDescriptor d = new NotifyDescriptor((Object)message, title, -1, messageType, null, null);
            DialogDisplayer.getDefault().notify(d);
        }
    }

    public static Answer requestDecision(String title, String message, boolean allowCancel, String preferencesKey) {
        boolean storeResult;
        Object result;
        int optionType = allowCancel ? 1 : 0;
        title = Dialogs.getDialogTitle(title != null ? title : Bundle.LBL_Question());
        if (preferencesKey != null) {
            String decision = Dialogs.getPreferences().get(preferencesKey + PREF_KEY_SUFFIX_DECISION, "");
            if (decision.equals(PREF_VALUE_YES)) {
                return Answer.YES;
            }
            if (decision.equals(PREF_VALUE_NO)) {
                return Answer.NO;
            }
            JCheckBox decisionCheckBox = new JCheckBox(Bundle.LBL_QuestionRemember(), false);
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)new Object[]{message, decisionCheckBox}, title, optionType);
            result = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            storeResult = decisionCheckBox.isSelected();
        } else {
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)message, title, optionType);
            result = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            storeResult = false;
        }
        if (NotifyDescriptor.YES_OPTION.equals(result)) {
            if (storeResult) {
                Dialogs.getPreferences().put(preferencesKey + PREF_KEY_SUFFIX_DECISION, PREF_VALUE_YES);
            }
            return Answer.YES;
        }
        if (NotifyDescriptor.NO_OPTION.equals(result)) {
            if (storeResult) {
                Dialogs.getPreferences().put(preferencesKey + PREF_KEY_SUFFIX_DECISION, PREF_VALUE_NO);
            }
            return Answer.NO;
        }
        return Answer.CANCELLED;
    }

    public static Boolean requestOverwriteDecision(String title, File file) {
        if (!file.exists()) {
            return Boolean.TRUE;
        }
        Answer answer = Dialogs.requestDecision(Dialogs.getDialogTitle(title), MessageFormat.format("The file ''{0}'' already exists.\nDo you wish to overwrite it?", file), true, null);
        return answer == Answer.YES ? Boolean.TRUE : (answer == Answer.NO ? Boolean.FALSE : null);
    }

    public static File requestFileForOpen(String title, boolean dirsOnly, FileFilter fileFilter, String preferencesKey) {
        Assert.notNull((Object)preferencesKey, (String)"preferencesKey");
        String lastDir = Dialogs.getPreferences().get(preferencesKey, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setCurrentDirectory(currentDir);
        if (fileFilter != null) {
            fileChooser.setFileFilter(fileFilter);
        }
        fileChooser.setDialogTitle(Dialogs.getDialogTitle(title));
        fileChooser.setFileSelectionMode(dirsOnly ? 1 : 0);
        int result = fileChooser.showOpenDialog((Component)SnapApp.getDefault().getMainFrame());
        if (fileChooser.getCurrentDirectory() != null) {
            Dialogs.getPreferences().put(preferencesKey, fileChooser.getCurrentDirectory().getPath());
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().equals("")) {
                return null;
            }
            return file;
        }
        return null;
    }

    public static File requestFileForSave(String title, boolean dirsOnly, FileFilter fileFilter, String defaultExtension, String fileName, JComponent accessory, String preferenceKey) {
        File file;
        do {
            if ((file = Dialogs.requestFileForSave2(title, dirsOnly, fileFilter, defaultExtension, fileName, accessory, preferenceKey)) == null) {
                return null;
            }
            if (!file.exists()) continue;
            Boolean overwrite = Dialogs.requestOverwriteDecision(title, file);
            if (overwrite == null) {
                return null;
            }
            if (overwrite.booleanValue()) continue;
            file = null;
        } while (file == null);
        return file;
    }

    private static File requestFileForSave2(String title, boolean dirsOnly, FileFilter fileFilter, String defaultExtension, String fileName, JComponent accessory, String preferenceKey) {
        Assert.notNull((Object)preferenceKey, (String)"preferenceKey");
        String lastDir = Dialogs.getPreferences().get(preferenceKey, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setCurrentDirectory(currentDir);
        if (fileFilter != null) {
            fileChooser.setFileFilter(fileFilter);
        }
        if (fileName != null) {
            fileChooser.setSelectedFile(new File(FileUtils.exchangeExtension((String)fileName, (String)defaultExtension)));
        }
        fileChooser.setDialogTitle(Dialogs.getDialogTitle(title));
        fileChooser.setFileSelectionMode(dirsOnly ? 1 : 0);
        if (accessory != null) {
            fileChooser.setAccessory(accessory);
        }
        int result = fileChooser.showSaveDialog((Component)SnapApp.getDefault().getMainFrame());
        if (fileChooser.getCurrentDirectory() != null) {
            Dialogs.getPreferences().put(preferenceKey, fileChooser.getCurrentDirectory().getPath());
        }
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            if (file == null || file.getName().equals("")) {
                return null;
            }
            String path = file.getPath();
            if (defaultExtension != null && !path.toLowerCase().endsWith(defaultExtension.toLowerCase())) {
                path = path.concat(defaultExtension);
            }
            return new File(path);
        }
        return null;
    }

    public static String getDialogTitle(String titleText) {
        return MessageFormat.format("{0} - {1}", SnapApp.getDefault().getInstanceName(), titleText);
    }

    private static Preferences getPreferences() {
        return SnapApp.getDefault().getPreferences();
    }

    public static enum Answer {
        YES,
        NO,
        CANCELLED;

    }
}

