/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;

public class DateTimePicker
extends JXDatePicker {
    private JSpinner timeSpinner;
    private DateFormat timeFormat;
    private TimeZone timeZone;

    public DateTimePicker(Date d, Locale l, DateFormat dateFormat, DateFormat timeFormat) {
        super(d, l);
        if (!dateFormat.getTimeZone().equals(timeFormat.getTimeZone())) {
            throw new IllegalStateException(String.format("Time zone mismatch: dateFormat is [%s] but timeFormat is [%s]", dateFormat, timeFormat));
        }
        this.timeZone = timeFormat.getTimeZone();
        this.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.getMonthView().setTimeZone(this.timeZone);
        this.setLinkPanel(this.createTimePanel());
        this.setFormats(new DateFormat[]{dateFormat});
        this.setTimeFormat(timeFormat);
        this.setDateTime(d);
    }

    public void commitEdit() throws ParseException {
        this.commitTime();
        super.commitEdit();
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateFormat timeFormat) {
        this.timeFormat = timeFormat;
        this.updateTextFieldFormat();
    }

    public void setDateTime(Date date) {
        super.setDate(date);
        if (this.timeSpinner != null) {
            if (date != null) {
                this.timeSpinner.setValue(date);
            } else {
                Calendar calendar = Calendar.getInstance(this.timeZone);
                calendar.set(13, 0);
                calendar.set(14, 0);
                this.timeSpinner.setValue(calendar.getTime());
            }
        }
    }

    private JPanel createTimePanel() {
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new FlowLayout());
        Date date = this.getDate();
        if (date == null) {
            Calendar calendar = Calendar.getInstance(this.timeZone);
            date = calendar.getTime();
        }
        SpinnerDateModel dateModel = new SpinnerDateModel(date, null, null, 5);
        this.timeSpinner = new JSpinner(dateModel);
        if (this.timeFormat == null) {
            this.timeFormat = DateFormat.getTimeInstance(3);
        }
        this.updateTextFieldFormat();
        newPanel.add(new JLabel("Time:"));
        newPanel.add(this.timeSpinner);
        newPanel.setBackground(Color.WHITE);
        return newPanel;
    }

    private void updateTextFieldFormat() {
        if (this.timeSpinner == null) {
            return;
        }
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.timeSpinner.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(this.timeFormat);
    }

    private void commitTime() {
        Date date = this.getDate();
        if (date != null) {
            Date time = (Date)this.timeSpinner.getValue();
            Calendar timeCalendar = Calendar.getInstance(this.timeZone);
            timeCalendar.setTime(time);
            Calendar calendar = Calendar.getInstance(this.timeZone);
            calendar.setTime(date);
            calendar.set(11, timeCalendar.get(11));
            calendar.set(12, timeCalendar.get(12));
            calendar.set(13, timeCalendar.get(13));
            calendar.set(14, timeCalendar.get(14));
            Date newDate = calendar.getTime();
            this.setDate(newDate);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            TimeZone utcZone = TimeZone.getTimeZone("UTC");
            Calendar utc = Calendar.getInstance(utcZone);
            Date date = utc.getTime();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            dateFormat.setTimeZone(utcZone);
            DateFormat timeFormat = DateFormat.getTimeInstance(2);
            timeFormat.setTimeZone(utcZone);
            JFrame frame = new JFrame();
            frame.setTitle("Date Time Picker");
            frame.setDefaultCloseOperation(3);
            DateTimePicker dateTimePicker = new DateTimePicker(date, Locale.ENGLISH, dateFormat, timeFormat);
            dateTimePicker.setFormats(new DateFormat[]{dateFormat});
            dateTimePicker.setTimeFormat(timeFormat);
            dateTimePicker.setDateTime(date);
            frame.getContentPane().add((Component)((Object)dateTimePicker));
            frame.pack();
            frame.setVisible(true);
        });
    }
}

