/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class XYPlotMarker
implements ChartMouseListener {
    private final ChartPanel chartPanel;
    private final Listener listener;
    private XYDataset xyDataset;
    private int seriesIndex;
    private ShapeOverlay overlay;
    private Paint fillPaint;
    private Paint outlinePaint;
    private Stroke outlineStroke;
    private double markerSize;

    public XYPlotMarker(ChartPanel chartPanel, Listener listener) {
        this.chartPanel = chartPanel;
        this.listener = listener;
        this.fillPaint = new Color(255, 255, 255, 127);
        this.outlinePaint = new Color(50, 50, 50, 200);
        this.outlineStroke = new BasicStroke(1.5f);
        this.markerSize = 20.0;
    }

    public double getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(double markerSize) {
        this.markerSize = markerSize;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint outlinePaint) {
        this.outlinePaint = outlinePaint;
    }

    public void setInvisible() {
        this.removeDataset();
        this.removeOverlay();
    }

    private void removeDataset() {
        this.xyDataset = null;
        this.seriesIndex = -1;
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        Point point;
        this.removeDataset();
        boolean overlayRemoved = this.removeOverlay();
        if (overlayRemoved) {
            this.listener.pointDeselected();
            return;
        }
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
        if (dataArea.contains(point = event.getTrigger().getPoint())) {
            PlotOrientation orientation = plot.getOrientation();
            RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)plot.getDomainAxisLocation(), (PlotOrientation)orientation);
            RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)plot.getRangeAxisLocation(), (PlotOrientation)orientation);
            double mx = plot.getDomainAxis().java2DToValue((double)point.x, dataArea, domainEdge);
            double my = plot.getRangeAxis().java2DToValue((double)point.y, dataArea, rangeEdge);
            int datasetCount = this.chartPanel.getChart().getXYPlot().getDatasetCount();
            double minDist = Double.POSITIVE_INFINITY;
            for (int datasetIndex = 0; datasetIndex < datasetCount; ++datasetIndex) {
                XYDataset xyDataset = this.chartPanel.getChart().getXYPlot().getDataset(datasetIndex);
                if (xyDataset == null) continue;
                int seriesCount = xyDataset.getSeriesCount();
                for (int seriesIndex = 0; seriesIndex < seriesCount; ++seriesIndex) {
                    int itemCount = xyDataset.getItemCount(seriesIndex);
                    for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
                        double y;
                        double x = xyDataset.getXValue(seriesIndex, itemIndex);
                        double dist = (x - mx) * (x - mx) + ((y = xyDataset.getYValue(seriesIndex, itemIndex)) - my) * (y - my);
                        if (!(dist < minDist)) continue;
                        minDist = dist;
                        this.xyDataset = xyDataset;
                        this.seriesIndex = seriesIndex;
                    }
                }
            }
        }
        if (this.xyDataset != null) {
            this.updatePoint(event);
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        this.updatePoint(event);
    }

    private void updatePoint(ChartMouseEvent event) {
        if (this.xyDataset == null || this.xyDataset.getSeriesCount() == 0 || this.seriesIndex < 0 || this.seriesIndex >= this.xyDataset.getSeriesCount()) {
            if (this.removeOverlay()) {
                // empty if block
            }
            return;
        }
        this.addOverlay();
        XYPlot plot = this.chartPanel.getChart().getXYPlot();
        Rectangle2D dataArea = this.chartPanel.getScreenDataArea();
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)plot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)plot.getRangeAxisLocation(), (PlotOrientation)orientation);
        double xView = event.getTrigger().getPoint().x;
        double xData = plot.getDomainAxis().java2DToValue(xView, dataArea, domainEdge);
        int itemCount = this.xyDataset.getItemCount(this.seriesIndex);
        for (int i = 0; i < itemCount - 1; ++i) {
            double x1 = this.xyDataset.getXValue(this.seriesIndex, i);
            double x2 = this.xyDataset.getXValue(this.seriesIndex, i + 1);
            if (!(xData >= x1) || !(xData <= x2)) continue;
            double y1 = this.xyDataset.getYValue(this.seriesIndex, i);
            double y2 = this.xyDataset.getYValue(this.seriesIndex, i + 1);
            double yData = y1 + (xData - x1) * (y2 - y1) / (x2 - x1);
            double yView = plot.getRangeAxis().valueToJava2D(yData, dataArea, rangeEdge);
            Point2D.Double viewPoint = new Point2D.Double(xView, yView);
            Point2D.Double dataPoint = new Point2D.Double(xData, yData);
            this.overlay.setPoint(viewPoint, dataPoint);
            this.listener.pointSelected(this.xyDataset, this.seriesIndex, dataPoint);
            break;
        }
    }

    private boolean addOverlay() {
        if (this.overlay == null) {
            this.overlay = new ShapeOverlay();
            this.chartPanel.addOverlay((Overlay)this.overlay);
            return true;
        }
        return false;
    }

    private boolean removeOverlay() {
        if (this.overlay != null) {
            this.chartPanel.removeOverlay((Overlay)this.overlay);
            this.overlay = null;
            return true;
        }
        return false;
    }

    private class ShapeOverlay
    extends AbstractOverlay
    implements Overlay {
        Point2D viewPoint;
        Point2D dataPoint;

        private ShapeOverlay() {
        }

        public void setPoint(Point2D viewPoint, Point2D dataPoint) {
            if (this.viewPoint == null || !this.viewPoint.equals(dataPoint)) {
                this.viewPoint = viewPoint;
                this.dataPoint = dataPoint;
                this.fireOverlayChanged();
            }
        }

        public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
            if (this.viewPoint != null) {
                Shape oldClip = g2.getClip();
                Rectangle2D dataArea = chartPanel.getScreenDataArea();
                g2.setClip(dataArea);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Ellipse2D.Double ellipse = new Ellipse2D.Double(this.viewPoint.getX() - 0.5 * XYPlotMarker.this.markerSize, this.viewPoint.getY() - 0.5 * XYPlotMarker.this.markerSize, XYPlotMarker.this.markerSize, XYPlotMarker.this.markerSize);
                g2.setPaint(XYPlotMarker.this.fillPaint);
                g2.fill(ellipse);
                g2.setStroke(XYPlotMarker.this.outlineStroke);
                g2.setPaint(XYPlotMarker.this.outlinePaint);
                g2.draw(ellipse);
                Rectangle2D.Double box = new Rectangle2D.Double(dataArea.getX() + 5.0, dataArea.getY() + 5.0, 100.0, 52.0);
                g2.setPaint(XYPlotMarker.this.fillPaint);
                g2.fill(box);
                g2.setStroke(XYPlotMarker.this.outlineStroke);
                g2.setPaint(XYPlotMarker.this.outlinePaint);
                g2.draw(box);
                g2.drawString(String.format("x = %.3f", this.dataPoint.getX()), (int)(dataArea.getX() + 5.0 + 5.0), (int)(dataArea.getY() + 5.0 + 20.0));
                g2.drawString(String.format("y = %.3f", this.dataPoint.getY()), (int)(dataArea.getX() + 5.0 + 5.0), (int)(dataArea.getY() + 5.0 + 40.0));
                g2.setClip(oldClip);
            }
        }
    }

    public static interface Listener {
        public void pointSelected(XYDataset var1, int var2, Point2D var3);

        public void pointDeselected();
    }
}

