/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.BindingContext;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;

class CorrelativeFieldSelector {
    final JLabel pointDataSourceLabel;
    final JComboBox pointDataSourceList;
    final JLabel dataFieldLabel;
    final JComboBox dataFieldList;
    final Property pointDataSourceProperty;
    final Property dataFieldProperty;
    static final String NULL_NAME = " ";

    CorrelativeFieldSelector(BindingContext bindingContext) {
        Assert.argument((bindingContext.getPropertySet().getProperty("pointDataSource") != null ? 1 : 0) != 0, (String)"bindingContext");
        Assert.argument((bindingContext.getPropertySet().getProperty("dataField") != null ? 1 : 0) != 0, (String)"bindingContext");
        Assert.argument((boolean)bindingContext.getPropertySet().getProperty("pointDataSource").getType().equals(VectorDataNode.class), (String)"bindingContext");
        Assert.argument((boolean)bindingContext.getPropertySet().getProperty("dataField").getType().equals(AttributeDescriptor.class), (String)"bindingContext");
        this.pointDataSourceLabel = new JLabel("Point data source:");
        this.pointDataSourceList = new JComboBox();
        this.dataFieldLabel = new JLabel("Data field:");
        this.dataFieldList = new JComboBox();
        this.pointDataSourceList.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((VectorDataNode)value).getName());
                }
                return this;
            }
        });
        this.dataFieldList.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((AttributeDescriptor)value).getName().getLocalPart());
                }
                return this;
            }
        });
        bindingContext.bind("pointDataSource", this.pointDataSourceList);
        this.pointDataSourceProperty = bindingContext.getPropertySet().getProperty("pointDataSource");
        this.dataFieldProperty = bindingContext.getPropertySet().getProperty("dataField");
        this.pointDataSourceProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CorrelativeFieldSelector.this.updateDataField();
            }
        });
        bindingContext.getBinding("pointDataSource").addComponent((JComponent)this.pointDataSourceLabel);
        bindingContext.bind("dataField", this.dataFieldList);
        bindingContext.getBinding("dataField").addComponent((JComponent)this.dataFieldLabel);
    }

    public void updatePointDataSource(Product product) {
        if (product != null) {
            Class<Point> pointClass = Point.class;
            ProductNodeGroup vectorDataGroup = product.getVectorDataGroup();
            ArrayList<VectorDataNode> vectorDataNodes = new ArrayList<VectorDataNode>();
            for (VectorDataNode vectorDataNode : (VectorDataNode[])vectorDataGroup.toArray((ProductNode[])new VectorDataNode[vectorDataGroup.getNodeCount()])) {
                GeometryDescriptor geometryDescriptor = vectorDataNode.getFeatureType().getGeometryDescriptor();
                if (geometryDescriptor == null || !pointClass.isAssignableFrom(geometryDescriptor.getType().getBinding())) continue;
                vectorDataNodes.add(vectorDataNode);
            }
            ValueSet valueSet = new ValueSet(vectorDataNodes.toArray());
            this.pointDataSourceProperty.getDescriptor().setValueSet(valueSet);
        } else {
            this.pointDataSourceProperty.getDescriptor().setValueSet(null);
            this.dataFieldProperty.getDescriptor().setValueSet(null);
            try {
                this.pointDataSourceProperty.setValue(null);
                this.dataFieldProperty.setValue(null);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
    }

    public void updateDataField() {
        if (this.pointDataSourceProperty.getValue() != null) {
            List attributeDescriptors = ((VectorDataNode)this.pointDataSourceProperty.getValue()).getFeatureType().getAttributeDescriptors();
            ArrayList<AttributeDescriptor> result = new ArrayList<AttributeDescriptor>();
            result.add(new NullAttributeDescriptor());
            for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
                if (!Number.class.isAssignableFrom(attributeDescriptor.getType().getBinding())) continue;
                result.add(attributeDescriptor);
            }
            this.dataFieldProperty.getDescriptor().setValueSet(new ValueSet(result.toArray()));
        } else {
            this.dataFieldProperty.getDescriptor().setValueSet(null);
            try {
                this.dataFieldProperty.setValue(null);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
    }

    public void tryToSelectPointDataSource(VectorDataNode pointDataSource) {
        this.pointDataSourceList.setSelectedItem(pointDataSource);
    }

    public void tryToSelectDataField(AttributeDescriptor dataField) {
        this.dataFieldList.setSelectedItem(dataField);
    }

    private class NullAttributeDescriptor
    implements AttributeDescriptor {
        private NullAttributeDescriptor() {
        }

        public AttributeType getType() {
            return null;
        }

        public String getLocalName() {
            return CorrelativeFieldSelector.NULL_NAME;
        }

        public Object getDefaultValue() {
            return null;
        }

        public Name getName() {
            return new NameImpl(CorrelativeFieldSelector.NULL_NAME);
        }

        public int getMinOccurs() {
            return 0;
        }

        public int getMaxOccurs() {
            return 0;
        }

        public boolean isNillable() {
            return true;
        }

        public Map<Object, Object> getUserData() {
            return null;
        }
    }
}

