/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.spectrum;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.grender.Viewport;
import com.vividsolutions.jts.geom.Point;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.help.HelpAction;
import org.esa.snap.rcp.placemark.PlacemarkUtils;
import org.esa.snap.rcp.spectrum.Bundle;
import org.esa.snap.rcp.spectrum.CursorSpectrumPixelPositionListener;
import org.esa.snap.rcp.spectrum.SpectraExportAction;
import org.esa.snap.rcp.statistics.XYPlotMarker;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.spectrum.DisplayableSpectrum;
import org.esa.snap.ui.product.spectrum.SpectrumBand;
import org.esa.snap.ui.product.spectrum.SpectrumChooser;
import org.esa.snap.ui.product.spectrum.SpectrumShapeProvider;
import org.esa.snap.ui.product.spectrum.SpectrumStrokeProvider;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SpectrumTopComponent", iconBase="org/esa/snap/rcp/icons/Spectrum.gif")
public class SpectrumTopComponent
extends ToolTopComponent {
    public static final String ID = SpectrumTopComponent.class.getName();
    private static final String SUPPRESS_MESSAGE_KEY = "plugin.spectrum.tip";
    private final Map<RasterDataNode, DisplayableSpectrum[]> rasterToSpectraMap;
    private final Map<RasterDataNode, List<SpectrumBand>> rasterToSpectralBandsMap;
    private final ProductNodeListenerAdapter productNodeHandler = new ProductNodeHandler();
    private final PinSelectionChangeListener pinSelectionChangeListener = new PinSelectionChangeListener();
    private final PixelPositionListener pixelPositionListener;
    private AbstractButton filterButton;
    private AbstractButton showSpectrumForCursorButton;
    private AbstractButton showSpectraForSelectedPinsButton;
    private AbstractButton showSpectraForAllPinsButton;
    private AbstractButton showGridButton;
    private boolean tipShown;
    private ProductSceneView currentView;
    private Product currentProduct;
    private ChartPanel chartPanel;
    private ChartHandler chartHandler;
    private boolean domainAxisAdjustmentIsFrozen;
    private boolean rangeAxisAdjustmentIsFrozen;
    private boolean isCodeInducedAxisChange;
    private boolean isUserInducedAutomaticAdjustmentChosen;

    public SpectrumTopComponent() {
        this.rasterToSpectraMap = new HashMap<RasterDataNode, DisplayableSpectrum[]>();
        this.rasterToSpectralBandsMap = new HashMap<RasterDataNode, List<SpectrumBand>>();
        this.pixelPositionListener = new CursorSpectrumPixelPositionListener(this);
        this.initUI();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Bundle.CTL_SpectrumTopComponent_HelpId());
    }

    private void setCurrentView(ProductSceneView view) {
        ProductSceneView oldView = this.currentView;
        this.currentView = view;
        if (oldView != this.currentView) {
            if (oldView != null) {
                oldView.removePropertyChangeListener("selectedPin", (PropertyChangeListener)this.pinSelectionChangeListener);
            }
            if (this.currentView != null) {
                this.currentView.addPropertyChangeListener("selectedPin", (PropertyChangeListener)this.pinSelectionChangeListener);
                this.setCurrentProduct(this.currentView.getProduct());
                if (!this.rasterToSpectraMap.containsKey(this.currentView.getRaster())) {
                    this.setUpSpectra();
                }
                this.recreateChart();
            }
            this.updateUIState();
        }
    }

    private Product getCurrentProduct() {
        return this.currentProduct;
    }

    private void setCurrentProduct(Product product) {
        Product oldProduct = this.currentProduct;
        this.currentProduct = product;
        if (this.currentProduct != oldProduct) {
            if (oldProduct != null) {
                oldProduct.removeProductNodeListener((ProductNodeListener)this.productNodeHandler);
            }
            if (this.currentProduct != null) {
                this.currentProduct.addProductNodeListener((ProductNodeListener)this.productNodeHandler);
            }
            if (this.currentProduct == null) {
                this.chartHandler.setEmptyPlot();
            }
            this.updateUIState();
        }
    }

    private void updateUIState() {
        boolean hasView = this.currentView != null;
        boolean hasProduct = this.getCurrentProduct() != null;
        boolean hasSelectedPins = hasView && this.currentView.getSelectedPins().length > 0;
        boolean hasPins = hasProduct && this.getCurrentProduct().getPinGroup().getNodeCount() > 0;
        this.filterButton.setEnabled(hasProduct);
        this.showSpectrumForCursorButton.setEnabled(hasView);
        this.showSpectraForSelectedPinsButton.setEnabled(hasSelectedPins);
        this.showSpectraForAllPinsButton.setEnabled(hasPins);
        this.showGridButton.setEnabled(hasView);
        this.chartPanel.setEnabled(hasProduct);
        this.showGridButton.setSelected(hasView);
        this.chartHandler.setGridVisible(this.showGridButton.isSelected());
    }

    void setPrepareForUpdateMessage() {
        this.chartHandler.setCollectingSpectralInformationMessage();
    }

    void updateData(int pixelX, int pixelY, int level, boolean pixelPosInRasterBounds) {
        this.chartHandler.setPosition(pixelX, pixelY, level, pixelPosInRasterBounds);
        this.chartHandler.updateData();
    }

    void updateChart(boolean adjustAxes) {
        this.chartHandler.setAutomaticRangeAdjustments(adjustAxes);
        this.updateChart();
    }

    void updateChart() {
        this.maybeShowTip();
        this.chartHandler.updateChart();
        this.chartPanel.repaint();
    }

    private void maybeShowTip() {
        if (!this.tipShown) {
            String message = "<html>Tip: If you press the SHIFT key while moving the mouse cursor over<br/>an image, " + SnapApp.getDefault().getInstanceName() + " adjusts the diagram axes " + "to the local values at the<br/>" + "current pixel position, if you release the SHIFT key again, then the<br/>" + "min/max are accumulated again.</html>";
            Dialogs.showInformation("Spectrum Tip", message, SUPPRESS_MESSAGE_KEY);
            this.tipShown = true;
        }
    }

    private SpectrumBand[] getAvailableSpectralBands(RasterDataNode currentRaster) {
        Band[] bands;
        if (!this.rasterToSpectralBandsMap.containsKey(currentRaster)) {
            this.rasterToSpectralBandsMap.put(currentRaster, new ArrayList());
        }
        List<SpectrumBand> spectrumBands = this.rasterToSpectralBandsMap.get(currentRaster);
        for (Band band : bands = this.currentProduct.getBands()) {
            if (!this.isSpectralBand(band) || band.isFlagBand()) continue;
            boolean isAlreadyIncluded = false;
            for (SpectrumBand spectrumBand : spectrumBands) {
                if (spectrumBand.getOriginalBand() != band) continue;
                isAlreadyIncluded = true;
                break;
            }
            if (isAlreadyIncluded) continue;
            spectrumBands.add(new SpectrumBand(band, true));
        }
        return spectrumBands.toArray(new SpectrumBand[spectrumBands.size()]);
    }

    private boolean isSpectralBand(Band band) {
        return (double)band.getSpectralWavelength() > 0.0;
    }

    private void initUI() {
        JFreeChart chart = ChartFactory.createXYLineChart((String)Bundle.CTL_SpectrumTopComponent_Name(), (String)"Wavelength (nm)", (String)"", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.getXYPlot().getRangeAxis().addChangeListener(axisChangeEvent -> {
            if (!this.isCodeInducedAxisChange) {
                this.rangeAxisAdjustmentIsFrozen = !((ValueAxis)axisChangeEvent.getAxis()).isAutoRange();
            }
        });
        chart.getXYPlot().getDomainAxis().addChangeListener(axisChangeEvent -> {
            if (!this.isCodeInducedAxisChange) {
                this.domainAxisAdjustmentIsFrozen = !((ValueAxis)axisChangeEvent.getAxis()).isAutoRange();
            }
        });
        chart.getXYPlot().getRangeAxis().setAutoRange(false);
        this.rangeAxisAdjustmentIsFrozen = false;
        chart.getXYPlot().getDomainAxis().setAutoRange(false);
        this.domainAxisAdjustmentIsFrozen = false;
        this.chartPanel = new ChartPanel(chart);
        this.chartHandler = new ChartHandler(chart);
        XYPlotMarker plotMarker = new XYPlotMarker(this.chartPanel, new XYPlotMarker.Listener(){

            @Override
            public void pointSelected(XYDataset xyDataset, int seriesIndex, Point2D dataPoint) {
            }

            @Override
            public void pointDeselected() {
            }
        });
        this.filterButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Filter24.gif"), (boolean)false);
        this.filterButton.setName("filterButton");
        this.filterButton.setEnabled(false);
        this.filterButton.addActionListener(e -> {
            this.selectSpectralBands();
            this.recreateChart();
        });
        this.showSpectrumForCursorButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/CursorSpectrum24.gif"), (boolean)true);
        this.showSpectrumForCursorButton.addActionListener(e -> this.recreateChart());
        this.showSpectrumForCursorButton.setName("showSpectrumForCursorButton");
        this.showSpectrumForCursorButton.setSelected(true);
        this.showSpectrumForCursorButton.setToolTipText("Show spectrum at cursor position.");
        this.showSpectraForSelectedPinsButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/SelectedPinSpectra24.gif"), (boolean)true);
        this.showSpectraForSelectedPinsButton.addActionListener(e -> {
            if (this.isShowingSpectraForAllPins()) {
                this.showSpectraForAllPinsButton.setSelected(false);
            } else if (!this.isShowingSpectraForSelectedPins()) {
                plotMarker.setInvisible();
            }
            this.recreateChart();
        });
        this.showSpectraForSelectedPinsButton.setName("showSpectraForSelectedPinsButton");
        this.showSpectraForSelectedPinsButton.setToolTipText("Show spectra for selected pins.");
        this.showSpectraForAllPinsButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/PinSpectra24.gif"), (boolean)true);
        this.showSpectraForAllPinsButton.addActionListener(e -> {
            if (this.isShowingSpectraForSelectedPins()) {
                this.showSpectraForSelectedPinsButton.setSelected(false);
            } else if (!this.isShowingSpectraForAllPins()) {
                plotMarker.setInvisible();
            }
            this.recreateChart();
        });
        this.showSpectraForAllPinsButton.setName("showSpectraForAllPinsButton");
        this.showSpectraForAllPinsButton.setToolTipText("Show spectra for all pins.");
        this.showGridButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/SpectrumGrid24.gif"), (boolean)true);
        this.showGridButton.addActionListener(e -> this.chartHandler.setGridVisible(this.showGridButton.isSelected()));
        this.showGridButton.setName("showGridButton");
        this.showGridButton.setToolTipText("Show diagram grid.");
        AbstractButton exportSpectraButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Export24.gif"), (boolean)false);
        exportSpectraButton.addActionListener(new SpectraExportAction(this));
        exportSpectraButton.setToolTipText("Export spectra to text file.");
        exportSpectraButton.setName("exportSpectraButton");
        AbstractButton helpButton = ToolButtonFactory.createButton((Action)new HelpAction((HelpCtx.Provider)this), (boolean)false);
        helpButton.setName("helpButton");
        helpButton.setToolTipText("Help.");
        JPanel buttonPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets.top = 2;
        gbc.gridy = 0;
        buttonPane.add((Component)this.filterButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showSpectrumForCursorButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showSpectraForSelectedPinsButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showSpectraForAllPinsButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)this.showGridButton, gbc);
        ++gbc.gridy;
        buttonPane.add((Component)exportSpectraButton, gbc);
        ++gbc.gridy;
        gbc.insets.bottom = 0;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        buttonPane.add((Component)new JLabel(" "), gbc);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.gridy = 10;
        gbc.anchor = 13;
        buttonPane.add((Component)helpButton, gbc);
        this.chartPanel.setPreferredSize(new Dimension(300, 200));
        this.chartPanel.setBackground(Color.white);
        this.chartPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.chartPanel.addChartMouseListener((ChartMouseListener)plotMarker);
        JPanel mainPane = new JPanel(new BorderLayout(4, 4));
        mainPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPane.add("Center", (Component)this.chartPanel);
        mainPane.add("East", buttonPane);
        mainPane.setPreferredSize(new Dimension(320, 200));
        SnapApp.getDefault().getProductManager().addListener(new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
            }

            public void productRemoved(ProductManager.Event event) {
                Product product = event.getProduct();
                if (SpectrumTopComponent.this.getCurrentProduct() == product) {
                    SpectrumTopComponent.this.chartPanel.getChart().getXYPlot().setDataset(null);
                    SpectrumTopComponent.this.setCurrentView(null);
                    SpectrumTopComponent.this.setCurrentProduct(null);
                }
                if (SpectrumTopComponent.this.currentView != null) {
                    RasterDataNode currentRaster = SpectrumTopComponent.this.currentView.getRaster();
                    if (SpectrumTopComponent.this.rasterToSpectraMap.containsKey(currentRaster)) {
                        SpectrumTopComponent.this.rasterToSpectraMap.remove(currentRaster);
                    }
                    if (SpectrumTopComponent.this.rasterToSpectralBandsMap.containsKey(currentRaster)) {
                        SpectrumTopComponent.this.rasterToSpectralBandsMap.remove(currentRaster);
                    }
                }
                PlacemarkGroup pinGroup = product.getPinGroup();
                for (int i = 0; i < pinGroup.getNodeCount(); ++i) {
                    SpectrumTopComponent.this.chartHandler.removePinInformation((Placemark)pinGroup.get(i));
                }
            }
        });
        ProductSceneView view = this.getSelectedProductSceneView();
        if (view != null) {
            this.productSceneViewSelected(view);
        }
        this.setDisplayName(Bundle.CTL_SpectrumTopComponent_Name());
        this.setLayout(new BorderLayout());
        this.add(mainPane, "Center");
        this.updateUIState();
    }

    private void selectSpectralBands() {
        RasterDataNode currentRaster = this.currentView.getRaster();
        DisplayableSpectrum[] allSpectra = this.rasterToSpectraMap.get(currentRaster);
        SpectrumChooser spectrumChooser = new SpectrumChooser(SwingUtilities.getWindowAncestor((Component)((Object)this)), allSpectra);
        if (spectrumChooser.show() == 1) {
            DisplayableSpectrum[] spectra = spectrumChooser.getSpectra();
            this.rasterToSpectraMap.put(currentRaster, spectra);
        }
    }

    boolean isShowingCursorSpectrum() {
        return this.showSpectrumForCursorButton.isSelected();
    }

    private boolean isShowingPinSpectra() {
        return this.isShowingSpectraForSelectedPins() || this.isShowingSpectraForAllPins();
    }

    private boolean isShowingSpectraForAllPins() {
        return this.showSpectraForAllPinsButton.isSelected();
    }

    private void recreateChart() {
        this.chartHandler.updateData();
        this.chartHandler.updateChart();
        this.chartPanel.repaint();
        this.updateUIState();
    }

    Placemark[] getDisplayedPins() {
        if (this.isShowingSpectraForSelectedPins() && this.currentView != null) {
            return this.currentView.getSelectedPins();
        }
        if (this.isShowingSpectraForAllPins() && this.getCurrentProduct() != null) {
            PlacemarkGroup pinGroup = this.getCurrentProduct().getPinGroup();
            return (Placemark[])pinGroup.toArray((ProductNode[])new Placemark[pinGroup.getNodeCount()]);
        }
        return new Placemark[0];
    }

    private void setUpSpectra() {
        DisplayableSpectrum[] spectra;
        if (this.currentView == null) {
            return;
        }
        RasterDataNode raster = this.currentView.getRaster();
        SpectrumBand[] availableSpectralBands = this.getAvailableSpectralBands(raster);
        if (availableSpectralBands.length == 0) {
            spectra = new DisplayableSpectrum[]{};
        } else {
            Product.AutoGrouping autoGrouping = this.currentProduct.getAutoGrouping();
            if (autoGrouping != null) {
                int selectedSpectrumIndex = autoGrouping.indexOf(raster.getName());
                DisplayableSpectrum[] autoGroupingSpectra = new DisplayableSpectrum[autoGrouping.size()];
                Iterator iterator = autoGrouping.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    String[] autoGroupingNameAsArray = (String[])iterator.next();
                    StringBuilder spectrumNameBuilder = new StringBuilder(autoGroupingNameAsArray[0]);
                    if (autoGroupingNameAsArray.length > 1) {
                        for (int j = 1; j < autoGroupingNameAsArray.length; ++j) {
                            String autoGroupingNamePart = autoGroupingNameAsArray[j];
                            spectrumNameBuilder.append("_").append(autoGroupingNamePart);
                        }
                    }
                    String spectrumName = spectrumNameBuilder.toString();
                    int symbolIndex = SpectrumShapeProvider.getValidIndex((int)i, (boolean)false);
                    DisplayableSpectrum spectrum = new DisplayableSpectrum(spectrumName, symbolIndex);
                    spectrum.setSelected(i == selectedSpectrumIndex);
                    spectrum.setLineStyle(SpectrumStrokeProvider.getStroke((int)i));
                    autoGroupingSpectra[i++] = spectrum;
                }
                ArrayList<Object> ungroupedBandsList = new ArrayList<Object>();
                for (SpectrumBand availableSpectralBand : availableSpectralBands) {
                    String bandName = availableSpectralBand.getName();
                    int spectrumIndex = autoGrouping.indexOf(bandName);
                    if (spectrumIndex != -1) {
                        autoGroupingSpectra[spectrumIndex].addBand(availableSpectralBand);
                        continue;
                    }
                    ungroupedBandsList.add(availableSpectralBand);
                }
                if (ungroupedBandsList.size() == 0) {
                    spectra = autoGroupingSpectra;
                } else {
                    DisplayableSpectrum[] spectraFromUngroupedBands = SpectrumTopComponent.createSpectraFromUngroupedBands(ungroupedBandsList.toArray(new SpectrumBand[ungroupedBandsList.size()]), SpectrumShapeProvider.getValidIndex((int)i, (boolean)false), i);
                    spectra = new DisplayableSpectrum[autoGroupingSpectra.length + spectraFromUngroupedBands.length];
                    System.arraycopy(autoGroupingSpectra, 0, spectra, 0, autoGroupingSpectra.length);
                    System.arraycopy(spectraFromUngroupedBands, 0, spectra, autoGroupingSpectra.length, spectraFromUngroupedBands.length);
                }
            } else {
                spectra = SpectrumTopComponent.createSpectraFromUngroupedBands(availableSpectralBands, 1, 0);
            }
        }
        this.rasterToSpectraMap.put(raster, spectra);
    }

    static DisplayableSpectrum[] createSpectraFromUngroupedBands(SpectrumBand[] ungroupedBands, int symbolIndex, int strokeIndex) {
        ArrayList<String> knownUnits = new ArrayList<String>();
        ArrayList<DisplayableSpectrum> displayableSpectrumList = new ArrayList<DisplayableSpectrum>();
        DisplayableSpectrum defaultSpectrum = new DisplayableSpectrum("tbd", -1);
        for (SpectrumBand ungroupedBand : ungroupedBands) {
            String unit = ungroupedBand.getOriginalBand().getUnit();
            if (StringUtils.isNullOrEmpty((String)unit)) {
                defaultSpectrum.addBand(ungroupedBand);
                continue;
            }
            if (knownUnits.contains(unit)) {
                ((DisplayableSpectrum)displayableSpectrumList.get(knownUnits.indexOf(unit))).addBand(ungroupedBand);
                continue;
            }
            knownUnits.add(unit);
            DisplayableSpectrum spectrum = new DisplayableSpectrum("Bands measured in " + unit, symbolIndex++);
            spectrum.setLineStyle(SpectrumStrokeProvider.getStroke((int)strokeIndex++));
            spectrum.addBand(ungroupedBand);
            displayableSpectrumList.add(spectrum);
        }
        if (strokeIndex == 0) {
            defaultSpectrum.setName("Bands");
        } else {
            defaultSpectrum.setName("Other");
        }
        defaultSpectrum.setSymbolIndex(symbolIndex);
        defaultSpectrum.setLineStyle(SpectrumStrokeProvider.getStroke((int)strokeIndex));
        displayableSpectrumList.add(defaultSpectrum);
        return displayableSpectrumList.toArray(new DisplayableSpectrum[displayableSpectrumList.size()]);
    }

    private DisplayableSpectrum[] getAllSpectra() {
        if (this.currentView == null || !this.rasterToSpectraMap.containsKey(this.currentView.getRaster())) {
            return new DisplayableSpectrum[0];
        }
        return this.rasterToSpectraMap.get(this.currentView.getRaster());
    }

    private boolean isShowingSpectraForSelectedPins() {
        return this.showSpectraForSelectedPinsButton.isSelected();
    }

    List<DisplayableSpectrum> getSelectedSpectra() {
        ArrayList<DisplayableSpectrum> selectedSpectra = new ArrayList<DisplayableSpectrum>();
        if (this.currentView != null) {
            RasterDataNode currentRaster = this.currentView.getRaster();
            if (this.currentProduct != null && this.rasterToSpectraMap.containsKey(currentRaster)) {
                DisplayableSpectrum[] allSpectra;
                for (DisplayableSpectrum displayableSpectrum : allSpectra = this.rasterToSpectraMap.get(currentRaster)) {
                    if (!displayableSpectrum.isSelected()) continue;
                    selectedSpectra.add(displayableSpectrum);
                }
            }
        }
        return selectedSpectra;
    }

    private void updateSpectraUnits() {
        for (DisplayableSpectrum spectrum : this.getAllSpectra()) {
            spectrum.updateUnit();
        }
    }

    void removeCursorSpectraFromDataset() {
        this.chartHandler.removeCursorSpectraFromDataset();
    }

    @Override
    protected void productSceneViewSelected(ProductSceneView view) {
        view.addPixelPositionListener(this.pixelPositionListener);
        this.setCurrentView(view);
    }

    @Override
    protected void productSceneViewDeselected(ProductSceneView view) {
        view.removePixelPositionListener(this.pixelPositionListener);
        this.setCurrentView(null);
    }

    protected void componentOpened() {
        ProductSceneView selectedProductSceneView = this.getSelectedProductSceneView();
        if (selectedProductSceneView != null) {
            selectedProductSceneView.addPixelPositionListener(this.pixelPositionListener);
            this.setCurrentView(selectedProductSceneView);
        }
    }

    protected void componentClosed() {
        if (this.currentView != null) {
            this.currentView.removePixelPositionListener(this.pixelPositionListener);
        }
    }

    public boolean showsValidCursorSpectra() {
        return this.chartHandler.showsValidCursorSpectra();
    }

    private class PinSelectionChangeListener
    implements PropertyChangeListener {
        private PinSelectionChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SpectrumTopComponent.this.recreateChart();
        }
    }

    private class ProductNodeHandler
    extends ProductNodeListenerAdapter {
        private ProductNodeHandler() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            boolean chartHasChanged = false;
            if (event.getSourceNode() instanceof Band) {
                String propertyName = event.getPropertyName();
                if (propertyName.equals("unit")) {
                    SpectrumTopComponent.this.updateSpectraUnits();
                    chartHasChanged = true;
                } else if (propertyName.equals("spectralWavelength")) {
                    SpectrumTopComponent.this.setUpSpectra();
                    chartHasChanged = true;
                }
            } else if (event.getSourceNode() instanceof Placemark) {
                if (event.getPropertyName().equals("geoPos") || event.getPropertyName().equals("pixelPos")) {
                    SpectrumTopComponent.this.chartHandler.removePinInformation((Placemark)event.getSourceNode());
                }
                if (SpectrumTopComponent.this.isShowingPinSpectra()) {
                    chartHasChanged = true;
                }
            } else if (event.getSourceNode() instanceof Product && event.getPropertyName().equals("autoGrouping")) {
                SpectrumTopComponent.this.setUpSpectra();
                chartHasChanged = true;
            }
            if (this.isActive() && chartHasChanged) {
                SpectrumTopComponent.this.recreateChart();
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            if (!this.isActive()) {
                return;
            }
            if (event.getSourceNode() instanceof Band) {
                Band newBand = (Band)event.getSourceNode();
                if (SpectrumTopComponent.this.isSpectralBand(newBand)) {
                    this.addBandToSpectra((Band)event.getSourceNode());
                    SpectrumTopComponent.this.recreateChart();
                }
            } else if (event.getSourceNode() instanceof Placemark) {
                if (SpectrumTopComponent.this.isShowingPinSpectra()) {
                    SpectrumTopComponent.this.recreateChart();
                } else {
                    SpectrumTopComponent.this.updateUIState();
                }
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            if (!this.isActive()) {
                return;
            }
            if (event.getSourceNode() instanceof Band) {
                Band band = (Band)event.getSourceNode();
                this.removeBandFromSpectra(band);
                SpectrumTopComponent.this.chartHandler.removeBandInformation(band);
                SpectrumTopComponent.this.recreateChart();
            } else if (event.getSourceNode() instanceof Placemark && SpectrumTopComponent.this.isShowingPinSpectra()) {
                SpectrumTopComponent.this.recreateChart();
            }
        }

        private void addBandToSpectra(Band band) {
            DisplayableSpectrum[] allSpectra = (DisplayableSpectrum[])SpectrumTopComponent.this.rasterToSpectraMap.get(SpectrumTopComponent.this.currentView.getRaster());
            Product.AutoGrouping autoGrouping = SpectrumTopComponent.this.currentProduct.getAutoGrouping();
            if (autoGrouping != null) {
                int bandIndex = autoGrouping.indexOf(band.getName());
                DisplayableSpectrum spectrum = bandIndex != -1 ? allSpectra[bandIndex] : allSpectra[allSpectra.length - 1];
                spectrum.addBand(new SpectrumBand(band, spectrum.isSelected()));
            } else {
                allSpectra[0].addBand(new SpectrumBand(band, true));
            }
        }

        private void removeBandFromSpectra(Band band) {
            DisplayableSpectrum[] allSpectra;
            for (DisplayableSpectrum displayableSpectrum : allSpectra = (DisplayableSpectrum[])SpectrumTopComponent.this.rasterToSpectraMap.get(SpectrumTopComponent.this.currentView.getRaster())) {
                Band[] spectralBands = displayableSpectrum.getSpectralBands();
                for (int j = 0; j < spectralBands.length; ++j) {
                    Band spectralBand = spectralBands[j];
                    if (spectralBand != band) continue;
                    displayableSpectrum.remove(j);
                    if (displayableSpectrum.getSelectedBands().length == 0) {
                        displayableSpectrum.setSelected(false);
                    }
                    return;
                }
            }
        }

        private boolean isActive() {
            return SpectrumTopComponent.this.isVisible() && SpectrumTopComponent.this.getCurrentProduct() != null;
        }
    }

    private class SpectrumLegendItemSource
    implements LegendItemSource {
        private SpectrumLegendItemSource() {
        }

        public LegendItemCollection getLegendItems() {
            LegendItemCollection itemCollection = new LegendItemCollection();
            Placemark[] displayedPins = SpectrumTopComponent.this.getDisplayedPins();
            List<DisplayableSpectrum> spectra = SpectrumTopComponent.this.getSelectedSpectra();
            for (Placemark pin : displayedPins) {
                Color pinPaint = PlacemarkUtils.getPlacemarkColor(pin, SpectrumTopComponent.this.currentView);
                spectra.stream().filter(DisplayableSpectrum::hasSelectedBands).forEach(spectrum -> {
                    String legendLabel = pin.getLabel() + "_" + spectrum.getName();
                    LegendItem item = this.createLegendItem((DisplayableSpectrum)spectrum, pinPaint, legendLabel);
                    itemCollection.add(item);
                });
            }
            if (SpectrumTopComponent.this.isShowingCursorSpectrum() && SpectrumTopComponent.this.showsValidCursorSpectra()) {
                spectra.stream().filter(DisplayableSpectrum::hasSelectedBands).forEach(spectrum -> {
                    Color defaultPaint = Color.BLACK;
                    LegendItem item = this.createLegendItem((DisplayableSpectrum)spectrum, defaultPaint, spectrum.getName());
                    itemCollection.add(item);
                });
            }
            return itemCollection;
        }

        private LegendItem createLegendItem(DisplayableSpectrum spectrum, Paint paint, String legendLabel) {
            BasicStroke outlineStroke = new BasicStroke();
            Line2D.Double lineShape = new Line2D.Double(0.0, 5.0, 40.0, 5.0);
            Stroke lineStyle = spectrum.getLineStyle();
            Shape symbol = spectrum.getScaledShape();
            return new LegendItem(legendLabel, legendLabel, legendLabel, legendLabel, true, symbol, false, paint, true, paint, (Stroke)outlineStroke, true, (Shape)lineShape, lineStyle, paint);
        }
    }

    private class ChartUpdater {
        private static final int domain_axis_index = 0;
        private static final int range_axis_index = 1;
        private static final double relativePlotInset = 0.05;
        private final Map<Placemark, Map<Band, Double>> pinToEnergies = new HashMap<Placemark, Map<Band, Double>>();
        private boolean showsValidCursorSpectra;
        private boolean pixelPosInRasterBounds;
        private int rasterPixelX;
        private int rasterPixelY;
        private int rasterLevel;
        private Range[] plotBounds = new Range[2];
        private XYSeriesCollection dataset;
        private Point2D modelP;

        private ChartUpdater() {
            this.invalidatePlotBounds();
        }

        void invalidatePlotBounds() {
            this.plotBounds[0] = null;
            this.plotBounds[1] = null;
        }

        private void setPosition(int pixelX, int pixelY, int level, boolean pixelPosInRasterBounds) {
            this.rasterPixelX = pixelX;
            this.rasterPixelY = pixelY;
            this.rasterLevel = level;
            this.pixelPosInRasterBounds = pixelPosInRasterBounds;
            AffineTransform i2m = SpectrumTopComponent.this.currentView.getBaseImageLayer().getImageToModelTransform(level);
            this.modelP = i2m.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), new Point2D.Double());
        }

        private void updateData(JFreeChart chart, List<DisplayableSpectrum> spectra) {
            this.dataset = new XYSeriesCollection();
            if (this.rasterLevel >= 0) {
                this.fillDatasetWithPinSeries(spectra, this.dataset, chart);
                this.fillDatasetWithCursorSeries(spectra, this.dataset, chart);
            }
        }

        private void updateChart(JFreeChart chart, List<DisplayableSpectrum> spectra) {
            XYPlot plot = chart.getXYPlot();
            if (!SpectrumTopComponent.this.chartHandler.isAutomaticDomainAdjustmentSet() && !SpectrumTopComponent.this.domainAxisAdjustmentIsFrozen) {
                SpectrumTopComponent.this.isCodeInducedAxisChange = true;
                this.updatePlotBounds(this.dataset.getDomainBounds(true), plot.getDomainAxis(), 0);
                SpectrumTopComponent.this.isCodeInducedAxisChange = false;
            }
            if (!SpectrumTopComponent.this.chartHandler.isAutomaticRangeAdjustmentSet() && !SpectrumTopComponent.this.rangeAxisAdjustmentIsFrozen) {
                SpectrumTopComponent.this.isCodeInducedAxisChange = true;
                this.updatePlotBounds(this.dataset.getRangeBounds(true), plot.getRangeAxis(), 1);
                SpectrumTopComponent.this.isCodeInducedAxisChange = false;
            }
            plot.setDataset((XYDataset)this.dataset);
            this.setPlotUnit(spectra, plot);
        }

        private void setPlotUnit(List<DisplayableSpectrum> spectra, XYPlot plot) {
            String unitToBeDisplayed = spectra.get(0).getUnit();
            int i = 1;
            while (i < spectra.size() && !unitToBeDisplayed.equals("mixed units")) {
                DisplayableSpectrum displayableSpectrum;
                if (!(displayableSpectrum = spectra.get(i++)).hasSelectedBands() || unitToBeDisplayed.equals(displayableSpectrum.getUnit())) continue;
                unitToBeDisplayed = "mixed units";
            }
            SpectrumTopComponent.this.isCodeInducedAxisChange = true;
            plot.getRangeAxis().setLabel(unitToBeDisplayed);
            SpectrumTopComponent.this.isCodeInducedAxisChange = false;
        }

        private void updatePlotBounds(Range newBounds, ValueAxis axis, int index) {
            if (newBounds != null) {
                Range axisBounds = axis.getRange();
                Range oldBounds = this.plotBounds[index];
                this.plotBounds[index] = this.getNewRange(newBounds, this.plotBounds[index], axisBounds);
                if (oldBounds != this.plotBounds[index]) {
                    axis.setRange(this.getNewPlotBounds(this.plotBounds[index]));
                }
            }
        }

        private Range getNewRange(Range newBounds, Range currentBounds, Range plotBounds) {
            if (currentBounds == null) {
                currentBounds = newBounds;
            } else if (plotBounds.getLowerBound() > 0.0 && newBounds.getLowerBound() < currentBounds.getLowerBound() || newBounds.getUpperBound() > currentBounds.getUpperBound()) {
                currentBounds = new Range(Math.min(currentBounds.getLowerBound(), newBounds.getLowerBound()), Math.max(currentBounds.getUpperBound(), newBounds.getUpperBound()));
            }
            return currentBounds;
        }

        private Range getNewPlotBounds(Range bounds) {
            double range = bounds.getLength();
            double delta = range * 0.05;
            return new Range(Math.max(0.0, bounds.getLowerBound() - delta), bounds.getUpperBound() + delta);
        }

        private void fillDatasetWithCursorSeries(List<DisplayableSpectrum> spectra, XYSeriesCollection dataset, JFreeChart chart) {
            this.showsValidCursorSpectra = false;
            if (this.modelP == null) {
                return;
            }
            if (SpectrumTopComponent.this.isShowingCursorSpectrum() && SpectrumTopComponent.this.currentView != null) {
                for (DisplayableSpectrum spectrum : spectra) {
                    float wavelength;
                    XYSeries series = new XYSeries((Comparable)((Object)spectrum.getName()));
                    Band[] spectralBands = spectrum.getSelectedBands();
                    if (!SpectrumTopComponent.this.currentProduct.isMultiSizeProduct()) {
                        for (Band spectralBand : spectralBands) {
                            wavelength = spectralBand.getSpectralWavelength();
                            if (!this.pixelPosInRasterBounds || !this.isPixelValid((RasterDataNode)spectralBand, this.rasterPixelX, this.rasterPixelY, this.rasterLevel)) continue;
                            this.addToSeries(spectralBand, this.rasterPixelX, this.rasterPixelY, this.rasterLevel, series, wavelength);
                            this.showsValidCursorSpectra = true;
                        }
                    } else {
                        for (Band spectralBand : spectralBands) {
                            wavelength = spectralBand.getSpectralWavelength();
                            AffineTransform i2m = spectralBand.getImageToModelTransform();
                            if (i2m.equals(SpectrumTopComponent.this.currentView.getRaster().getImageToModelTransform())) {
                                if (!this.pixelPosInRasterBounds || !this.isPixelValid((RasterDataNode)spectralBand, this.rasterPixelX, this.rasterPixelY, this.rasterLevel)) continue;
                                this.addToSeries(spectralBand, this.rasterPixelX, this.rasterPixelY, this.rasterLevel, series, wavelength);
                                this.showsValidCursorSpectra = true;
                                continue;
                            }
                            PixelPos rasterPos = new PixelPos();
                            MultiLevelModel multiLevelModel = spectralBand.getMultiLevelModel();
                            int level = this.getLevel(multiLevelModel);
                            multiLevelModel.getModelToImageTransform(level).transform(this.modelP, (Point2D)rasterPos);
                            int rasterX = (int)rasterPos.getX();
                            int rasterY = (int)rasterPos.getY();
                            if (!this.coordinatesAreInRasterBounds((RasterDataNode)spectralBand, rasterX, rasterY, level) || !this.isPixelValid((RasterDataNode)spectralBand, rasterX, rasterY, level)) continue;
                            this.addToSeries(spectralBand, rasterX, rasterY, level, series, wavelength);
                            this.showsValidCursorSpectra = true;
                        }
                    }
                    this.updateRenderer(dataset.getSeriesCount(), Color.BLACK, spectrum, chart);
                    dataset.addSeries(series);
                }
            }
        }

        private void addToSeries(Band spectralBand, int x, int y, int level, XYSeries series, double wavelength) {
            double energy = ProductUtils.getGeophysicalSampleAsDouble((RasterDataNode)spectralBand, (int)x, (int)y, (int)level);
            if (energy != spectralBand.getGeophysicalNoDataValue()) {
                series.add(wavelength, energy);
            }
        }

        private boolean coordinatesAreInRasterBounds(RasterDataNode raster, int x, int y, int level) {
            RenderedImage levelImage = raster.getSourceImage().getImage(level);
            return x >= 0 && y >= 0 && x < levelImage.getWidth() && y < levelImage.getHeight();
        }

        private void fillDatasetWithPinSeries(List<DisplayableSpectrum> spectra, XYSeriesCollection dataset, JFreeChart chart) {
            Placemark[] pins;
            for (Placemark pin : pins = SpectrumTopComponent.this.getDisplayedPins()) {
                List<XYSeries> pinSeries = this.createXYSeriesFromPin(pin, dataset.getSeriesCount(), spectra, chart);
                pinSeries.forEach(arg_0 -> ((XYSeriesCollection)dataset).addSeries(arg_0));
            }
        }

        private List<XYSeries> createXYSeriesFromPin(Placemark pin, int seriesIndex, List<DisplayableSpectrum> spectra, JFreeChart chart) {
            ArrayList<XYSeries> pinSeries = new ArrayList<XYSeries>();
            Color pinColor = PlacemarkUtils.getPlacemarkColor(pin, SpectrumTopComponent.this.currentView);
            for (DisplayableSpectrum spectrum : spectra) {
                Map<Object, Object> bandToEnergy;
                XYSeries series = new XYSeries((Comparable)((Object)(spectrum.getName() + "_" + pin.getLabel())));
                Band[] spectralBands = spectrum.getSelectedBands();
                if (this.pinToEnergies.containsKey(pin)) {
                    bandToEnergy = this.pinToEnergies.get(pin);
                } else {
                    bandToEnergy = new HashMap();
                    this.pinToEnergies.put(pin, bandToEnergy);
                }
                for (Band spectralBand : spectralBands) {
                    double energy;
                    if (bandToEnergy.containsKey(spectralBand)) {
                        energy = (Double)bandToEnergy.get(spectralBand);
                    } else {
                        energy = this.readEnergy(pin, spectralBand);
                        bandToEnergy.put(spectralBand, energy);
                    }
                    float wavelength = spectralBand.getSpectralWavelength();
                    if (energy == spectralBand.getGeophysicalNoDataValue()) continue;
                    series.add((double)wavelength, energy);
                }
                this.updateRenderer(seriesIndex++, pinColor, spectrum, chart);
                pinSeries.add(series);
            }
            return pinSeries;
        }

        private void updateRenderer(int seriesIndex, Color seriesColor, DisplayableSpectrum spectrum, JFreeChart chart) {
            XYItemRenderer renderer = chart.getXYPlot().getRenderer();
            renderer.setSeriesPaint(seriesIndex, (Paint)seriesColor);
            Stroke lineStyle = spectrum.getLineStyle();
            renderer.setSeriesStroke(seriesIndex, lineStyle);
            Shape symbol = spectrum.getScaledShape();
            renderer.setSeriesShape(seriesIndex, symbol);
        }

        private double readEnergy(Placemark pin, Band spectralBand) {
            Object pinGeometry = pin.getFeature().getDefaultGeometry();
            if (pinGeometry == null || !(pinGeometry instanceof Point)) {
                return spectralBand.getGeophysicalNoDataValue();
            }
            Point2D.Double modelPoint = new Point2D.Double(((Point)pinGeometry).getCoordinate().x, ((Point)pinGeometry).getCoordinate().y);
            MultiLevelModel multiLevelModel = spectralBand.getMultiLevelModel();
            int level = this.getLevel(multiLevelModel);
            AffineTransform m2iTransform = multiLevelModel.getModelToImageTransform(level);
            PixelPos pinLevelRasterPos = new PixelPos();
            m2iTransform.transform(modelPoint, (Point2D)pinLevelRasterPos);
            int pinLevelRasterX = (int)Math.floor(pinLevelRasterPos.getX());
            int pinLevelRasterY = (int)Math.floor(pinLevelRasterPos.getY());
            if (this.coordinatesAreInRasterBounds((RasterDataNode)spectralBand, pinLevelRasterX, pinLevelRasterY, level) && this.isPixelValid((RasterDataNode)spectralBand, pinLevelRasterX, pinLevelRasterY, level)) {
                return ProductUtils.getGeophysicalSampleAsDouble((RasterDataNode)spectralBand, (int)pinLevelRasterX, (int)pinLevelRasterY, (int)level);
            }
            return spectralBand.getGeophysicalNoDataValue();
        }

        private void removePinInformation(Placemark pin) {
            this.pinToEnergies.remove(pin);
        }

        private void removeBandinformation(Band band) {
            for (Placemark pin : this.pinToEnergies.keySet()) {
                Map<Band, Double> bandToEnergiesMap = this.pinToEnergies.get(pin);
                if (!bandToEnergiesMap.containsKey(band)) continue;
                bandToEnergiesMap.remove(band);
            }
        }

        public boolean showsValidCursorSpectra() {
            return this.showsValidCursorSpectra;
        }

        void removeCursorSpectraFromDataset() {
            this.modelP = null;
            if (this.showsValidCursorSpectra) {
                int numberOfSelectedSpectra = SpectrumTopComponent.this.getSelectedSpectra().size();
                int numberOfPins = SpectrumTopComponent.this.getDisplayedPins().length;
                int numberOfDisplayedGraphs = numberOfPins * numberOfSelectedSpectra;
                while (this.dataset.getSeriesCount() > numberOfDisplayedGraphs) {
                    this.dataset.removeSeries(this.dataset.getSeriesCount() - 1);
                }
            }
        }

        public boolean isDatasetEmpty() {
            return this.dataset == null || this.dataset.getSeriesCount() == 0;
        }

        private boolean isPixelValid(RasterDataNode raster, int pixelX, int pixelY, int level) {
            if (raster.isValidMaskUsed()) {
                PlanarImage image = ImageManager.getInstance().getValidMaskImage(raster, level);
                Raster data = this.getRasterTile(image, pixelX, pixelY);
                return data.getSample(pixelX, pixelY, 0) != 0;
            }
            return true;
        }

        private Raster getRasterTile(PlanarImage image, int pixelX, int pixelY) {
            int tileX = image.XToTileX(pixelX);
            int tileY = image.YToTileY(pixelY);
            return image.getTile(tileX, tileY);
        }

        private int getLevel(MultiLevelModel multiLevelModel) {
            if (this.rasterLevel < multiLevelModel.getLevelCount()) {
                return this.rasterLevel;
            }
            return ImageLayer.getLevel((MultiLevelModel)multiLevelModel, (Viewport)SpectrumTopComponent.this.currentView.getViewport());
        }
    }

    private class ChartHandler {
        private static final String MESSAGE_NO_SPECTRAL_BANDS = "No spectral bands available";
        private static final String MESSAGE_NO_PRODUCT_SELECTED = "No product selected";
        private static final String MESSAGE_NO_SPECTRA_SELECTED = "No spectra selected";
        private static final String MESSAGE_COLLECTING_SPECTRAL_INFORMATION = "Collecting spectral information...";
        private final JFreeChart chart;
        private final ChartUpdater chartUpdater;

        private ChartHandler(JFreeChart chart) {
            this.chartUpdater = new ChartUpdater();
            this.chart = chart;
            this.setLegend(chart);
            this.setAutomaticRangeAdjustments(false);
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(false);
            this.setPlotMessage(MESSAGE_NO_PRODUCT_SELECTED);
        }

        private void setAutomaticRangeAdjustments(boolean userInducesAutomaticAdjustment) {
            XYPlot plot = this.chart.getXYPlot();
            boolean adjustmentHasChanged = false;
            if (userInducesAutomaticAdjustment) {
                if (!SpectrumTopComponent.this.isUserInducedAutomaticAdjustmentChosen) {
                    SpectrumTopComponent.this.isUserInducedAutomaticAdjustmentChosen = true;
                    if (!this.isAutomaticDomainAdjustmentSet()) {
                        plot.getDomainAxis().setAutoRange(true);
                        SpectrumTopComponent.this.domainAxisAdjustmentIsFrozen = false;
                        adjustmentHasChanged = true;
                    }
                    if (!this.isAutomaticRangeAdjustmentSet()) {
                        plot.getRangeAxis().setAutoRange(true);
                        SpectrumTopComponent.this.rangeAxisAdjustmentIsFrozen = false;
                        adjustmentHasChanged = true;
                    }
                }
            } else if (SpectrumTopComponent.this.isUserInducedAutomaticAdjustmentChosen) {
                SpectrumTopComponent.this.isUserInducedAutomaticAdjustmentChosen = false;
                if (this.isAutomaticDomainAdjustmentSet()) {
                    plot.getDomainAxis().setAutoRange(false);
                    SpectrumTopComponent.this.domainAxisAdjustmentIsFrozen = false;
                    adjustmentHasChanged = true;
                }
                if (this.isAutomaticRangeAdjustmentSet()) {
                    plot.getRangeAxis().setAutoRange(false);
                    SpectrumTopComponent.this.rangeAxisAdjustmentIsFrozen = false;
                    adjustmentHasChanged = true;
                }
            }
            if (adjustmentHasChanged) {
                this.chartUpdater.invalidatePlotBounds();
            }
        }

        private boolean isAutomaticDomainAdjustmentSet() {
            return this.chart.getXYPlot().getDomainAxis().isAutoRange();
        }

        private boolean isAutomaticRangeAdjustmentSet() {
            return this.chart.getXYPlot().getRangeAxis().isAutoRange();
        }

        private void setLegend(JFreeChart chart) {
            chart.removeLegend();
            LegendTitle legend = new LegendTitle((LegendItemSource)new SpectrumLegendItemSource());
            legend.setPosition(RectangleEdge.BOTTOM);
            LineBorder border = new LineBorder((Paint)Color.BLACK, (Stroke)new BasicStroke(), new RectangleInsets(2.0, 2.0, 2.0, 2.0));
            legend.setFrame((BlockFrame)border);
            chart.addLegend(legend);
        }

        private void setPosition(int pixelX, int pixelY, int level, boolean pixelPosInRasterBounds) {
            this.chartUpdater.setPosition(pixelX, pixelY, level, pixelPosInRasterBounds);
        }

        private void updateChart() {
            if (this.chartUpdater.isDatasetEmpty()) {
                this.setEmptyPlot();
                return;
            }
            List<DisplayableSpectrum> spectra = SpectrumTopComponent.this.getSelectedSpectra();
            this.chartUpdater.updateChart(this.chart, spectra);
            this.chart.getXYPlot().clearAnnotations();
        }

        private void updateData() {
            List<DisplayableSpectrum> spectra = SpectrumTopComponent.this.getSelectedSpectra();
            this.chartUpdater.updateData(this.chart, spectra);
        }

        private void setEmptyPlot() {
            this.chart.getXYPlot().setDataset(null);
            if (SpectrumTopComponent.this.getCurrentProduct() == null) {
                this.setPlotMessage(MESSAGE_NO_PRODUCT_SELECTED);
            } else {
                if (!this.chartUpdater.showsValidCursorSpectra()) {
                    return;
                }
                if (SpectrumTopComponent.this.getAllSpectra().length == 0) {
                    this.setPlotMessage(MESSAGE_NO_SPECTRA_SELECTED);
                } else {
                    this.setPlotMessage(MESSAGE_NO_SPECTRAL_BANDS);
                }
            }
        }

        private void setGridVisible(boolean visible) {
            this.chart.getXYPlot().setDomainGridlinesVisible(visible);
            this.chart.getXYPlot().setRangeGridlinesVisible(visible);
        }

        private void removePinInformation(Placemark pin) {
            this.chartUpdater.removePinInformation(pin);
        }

        private void removeBandInformation(Band band) {
            this.chartUpdater.removeBandinformation(band);
        }

        private void setPlotMessage(String messageText) {
            this.chart.getXYPlot().clearAnnotations();
            TextTitle tt = new TextTitle(messageText);
            tt.setTextAlignment(HorizontalAlignment.RIGHT);
            tt.setFont(this.chart.getLegend().getItemFont());
            tt.setBackgroundPaint((Paint)new Color(200, 200, 255, 50));
            tt.setFrame((BlockFrame)new BlockBorder((Paint)Color.white));
            tt.setPosition(RectangleEdge.BOTTOM);
            XYTitleAnnotation message = new XYTitleAnnotation(0.5, 0.5, (Title)tt, RectangleAnchor.CENTER);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)message);
        }

        public boolean showsValidCursorSpectra() {
            return this.chartUpdater.showsValidCursorSpectra();
        }

        public void removeCursorSpectraFromDataset() {
            this.chartUpdater.removeCursorSpectraFromDataset();
        }

        public void setCollectingSpectralInformationMessage() {
            this.setPlotMessage(MESSAGE_COLLECTING_SPECTRAL_INFORMATION);
        }
    }
}

