/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.esa.snap.rcp.session.Session;
import org.esa.snap.rcp.session.XStreamSessionIO;

public abstract class SessionIO {
    static SessionIO instance = new XStreamSessionIO();

    public static SessionIO getInstance() {
        return instance;
    }

    public static void setInstance(SessionIO instance) {
        Assert.notNull((Object)instance, (String)"instance");
        SessionIO.instance = instance;
    }

    public Session readSession(File file) throws Exception {
        Assert.notNull((Object)file, (String)"file");
        try (FileReader reader = new FileReader(file);){
            Session session = this.readSession(reader);
            return session;
        }
    }

    public abstract Session readSession(Reader var1) throws Exception;

    public void writeSession(Session session, File file) throws Exception {
        Assert.notNull((Object)session, (String)"session");
        Assert.notNull((Object)file, (String)"file");
        try (FileWriter writer = new FileWriter(file);){
            this.writeSession(session, writer);
        }
    }

    public abstract void writeSession(Session var1, Writer var2) throws Exception;
}

