/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.DomElementXStreamConverter;
import com.bc.ceres.core.CanceledException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Viewport;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.layer.MaskCollectionLayerType;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.metadata.MetadataViewTopComponent;
import org.esa.snap.rcp.session.RestoredSession;
import org.esa.snap.rcp.session.dom.SessionDomConverter;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.ProductNodeView;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.ProductSceneView;

@XStreamAlias(value="session")
public class Session {
    public static String CURRENT_MODEL_VERSION = "1.0.0";
    String modelVersion;
    @XStreamAlias(value="products")
    ProductRef[] productRefs;
    @XStreamAlias(value="views")
    ViewRef[] viewRefs;

    public Session() {
    }

    public Session(URI rootURI, Product[] products, ProductNodeView[] views) {
        this.modelVersion = CURRENT_MODEL_VERSION;
        this.productRefs = new ProductRef[products.length];
        for (int i = 0; i < products.length; ++i) {
            Product[] product = products[i];
            URI relativeProductURI = Session.getFileLocationURI(rootURI, (Product)product);
            String productReaderPlugin = product.getProductReader().getReaderPlugIn().getClass().toString();
            this.productRefs[i] = new ProductRef(product.getRefNo(), relativeProductURI, productReaderPlugin);
        }
        ProductManager productManager = new ProductManager();
        for (Product product : products) {
            productManager.addProduct(product);
        }
        this.viewRefs = new ViewRef[views.length];
        for (int i = 0; i < views.length; ++i) {
            ProductNodeView view = views[i];
            ViewportDef viewportDef = null;
            LayerRef[] layerRefs = new LayerRef[]{};
            if (view instanceof ProductSceneView) {
                ProductSceneView sceneView = (ProductSceneView)view;
                Viewport viewport = sceneView.getLayerCanvas().getViewport();
                viewportDef = new ViewportDef(viewport.isModelYAxisDown(), viewport.getOffsetX(), viewport.getOffsetY(), viewport.getZoomFactor(), viewport.getOrientation());
                List layers = sceneView.getRootLayer().getChildren();
                layerRefs = Session.getLayerRefs(layers, productManager);
            }
            Rectangle viewBounds = new Rectangle(0, 0, 200, 200);
            if (view instanceof JComponent) {
                viewBounds = Session.getRootPaneContainer((JComponent)view).getBounds();
            }
            String productNodeName = null;
            String viewName = null;
            String expressionR = null;
            String expressionG = null;
            String expressionB = null;
            int productRefNo = 0;
            if (view instanceof ProductSceneView) {
                ProductSceneView psv = (ProductSceneView)view;
                if (psv.isRGB()) {
                    viewName = psv.getSceneName();
                    RasterDataNode[] rasters = psv.getRasters();
                    expressionR = Session.getExpression(rasters[0]);
                    expressionG = Session.getExpression(rasters[1]);
                    expressionB = Session.getExpression(rasters[2]);
                    productRefNo = rasters[0].getProduct().getRefNo();
                } else {
                    productNodeName = view.getVisibleProductNode().getName();
                    productRefNo = view.getVisibleProductNode().getProduct().getRefNo();
                }
            }
            this.viewRefs[i] = new ViewRef(i, view.getClass().getName(), viewBounds, viewportDef, productRefNo, productNodeName, viewName, expressionR, expressionG, expressionB, layerRefs);
        }
    }

    private static String getExpression(RasterDataNode raster) {
        Product product = raster.getProduct();
        if (product != null) {
            if (product.containsBand(raster.getName())) {
                return raster.getName();
            }
            if (raster instanceof VirtualBand) {
                return ((VirtualBand)raster).getExpression();
            }
        }
        return null;
    }

    private static URI getFileLocationURI(URI rootURI, Product product) {
        File file = product.getFileLocation();
        return FileUtils.getRelativeUri((URI)rootURI, (File)file);
    }

    private static LayerRef[] getLayerRefs(List<Layer> layers, ProductManager productManager) {
        ArrayList<LayerRef> layerRefs = new ArrayList<LayerRef>(layers.size());
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = layers.get(i);
            if (!Session.isSerializableLayer(layer)) continue;
            PropertySet configuration = layer.getConfiguration();
            PropertyContainer configurationCopy = Session.getConfigurationCopy(configuration);
            SessionDomConverter domConverter = new SessionDomConverter(productManager);
            DefaultDomElement element = new DefaultDomElement("configuration");
            try {
                domConverter.convertValueToDom(configurationCopy, (DomElement)element);
            }
            catch (ConversionException e) {
                e.printStackTrace();
            }
            layerRefs.add(new LayerRef(layer, i, (DomElement)element, Session.getLayerRefs(layer.getChildren(), productManager)));
        }
        return layerRefs.toArray(new LayerRef[layerRefs.size()]);
    }

    private static boolean isSerializableLayer(Layer layer) {
        return !(layer.getLayerType() instanceof MaskCollectionLayerType);
    }

    private static PropertyContainer getConfigurationCopy(PropertySet propertyContainer) {
        PropertyContainer configuration = new PropertyContainer();
        for (Property model : propertyContainer.getProperties()) {
            PropertyDescriptor descriptor = new PropertyDescriptor(model.getDescriptor());
            DefaultPropertyAccessor valueAccessor = new DefaultPropertyAccessor();
            valueAccessor.setValue(model.getValue());
            configuration.addProperty(new Property(descriptor, (PropertyAccessor)valueAccessor));
        }
        return configuration;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public int getProductCount() {
        return this.productRefs.length;
    }

    public ProductRef getProductRef(int index) {
        return this.productRefs[index];
    }

    public int getViewCount() {
        return this.viewRefs.length;
    }

    public ViewRef getViewRef(int index) {
        return this.viewRefs[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestoredSession restore(AppContext appContext, URI rootURI, ProgressMonitor pm, ProblemSolver problemSolver) throws CanceledException {
        try {
            pm.beginTask("Restoring session", 100);
            ArrayList<Exception> problems = new ArrayList<Exception>();
            ProductManager productManager = this.restoreProducts(rootURI, SubProgressMonitor.create((ProgressMonitor)pm, (int)80), problemSolver, problems);
            ProductNodeView[] views = this.restoreViews(productManager, appContext.getPreferences(), SubProgressMonitor.create((ProgressMonitor)pm, (int)20), problems);
            RestoredSession restoredSession = new RestoredSession(productManager.getProducts(), views, problems.toArray(new Exception[problems.size()]));
            return restoredSession;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProductManager restoreProducts(URI rootURI, ProgressMonitor pm, ProblemSolver problemSolver, List<Exception> problems) throws CanceledException {
        ProductManager productManager = new ProductManager();
        try {
            pm.beginTask("Restoring products", this.productRefs.length);
            for (ProductRef productRef : this.productRefs) {
                try {
                    Product product = null;
                    File productFile = new File(rootURI.resolve(productRef.uri));
                    if (productFile.exists()) {
                        String productReaderPlugin = productRef.productReaderPlugin;
                        if (StringUtils.isNotNullAndNotEmpty((String)productReaderPlugin)) {
                            Iterator allReaderPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
                            while (allReaderPlugIns.hasNext()) {
                                ProductReaderPlugIn plugIn = (ProductReaderPlugIn)allReaderPlugIns.next();
                                if (!plugIn.getClass().toString().equals(productReaderPlugin)) continue;
                                product = plugIn.createReaderInstance().readProductNodes((Object)productFile, null);
                                break;
                            }
                            if (product == null) {
                                SnapApp.getDefault().getLogger().log(Level.WARNING, "Could not find " + productReaderPlugin + ". " + "Attempting to use other reader to open " + productFile.getName());
                            }
                        }
                        if (product == null) {
                            product = ProductIO.readProduct((File)productFile);
                        }
                    } else {
                        product = problemSolver.solveProductNotFound(productRef.refNo, productFile);
                        if (product == null) {
                            throw new IOException("Product [" + productRef.refNo + "] not found.");
                        }
                    }
                    product.setRefNo(productRef.refNo);
                    productManager.addProduct(product);
                }
                catch (IOException e) {
                    problems.add(e);
                }
                finally {
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
        return productManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductNodeView[] restoreViews(ProductManager productManager, PropertyMap applicationPreferences, ProgressMonitor pm, List<Exception> problems) {
        ArrayList<ProductNodeView> views = new ArrayList<ProductNodeView>();
        try {
            pm.beginTask("Restoring views", this.viewRefs.length);
            for (ViewRef viewRef : this.viewRefs) {
                try {
                    if (ProductSceneView.class.getName().equals(viewRef.type)) {
                        Session.collectSceneView(viewRef, productManager, applicationPreferences, pm, problems, views);
                        continue;
                    }
                    if (MetadataViewTopComponent.class.getName().equals(viewRef.type)) {
                        Session.collectMetadataView(viewRef, productManager, views);
                        continue;
                    }
                    throw new Exception("Unknown view type: " + viewRef.type);
                }
                catch (Exception e) {
                    problems.add(e);
                }
                finally {
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
        return views.toArray(new ProductNodeView[views.size()]);
    }

    private static void collectSceneView(final ViewRef viewRef, final ProductManager productManager, final PropertyMap applicationPreferences, final ProgressMonitor pm, final List<Exception> problems, final List<ProductNodeView> views) throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProductSceneView view;
                try {
                    view = Session.createSceneView(viewRef, productManager, applicationPreferences, pm);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not create scene", e);
                }
                views.add(view);
                for (int i = 0; i < viewRef.getLayerCount(); ++i) {
                    LayerRef ref = viewRef.getLayerRef(i);
                    if (Session.isBaseImageLayerRef(view, ref)) {
                        view.getBaseImageLayer().setTransparency(ref.transparency);
                        view.getBaseImageLayer().setVisible(ref.visible);
                        continue;
                    }
                    try {
                        Session.addLayerRef((LayerContext)view, view.getRootLayer(), ref, productManager);
                        continue;
                    }
                    catch (Exception e) {
                        problems.add(e);
                    }
                }
            }
        });
    }

    private static boolean isBaseImageLayerRef(ProductSceneView view, LayerRef ref) {
        return view.getBaseImageLayer().getId().equals(ref.id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ProductSceneView createSceneView(ViewRef viewRef, ProductManager productManager, PropertyMap applicationPreferences, ProgressMonitor pm) throws Exception {
        ViewportDef viewportDef;
        ProductSceneImage sceneImage;
        Product product = productManager.getProductByRefNo(viewRef.productRefNo);
        if (product == null) {
            throw new Exception("Unknown product reference number: " + viewRef.productRefNo);
        }
        if (viewRef.productNodeName != null) {
            RasterDataNode node = product.getRasterDataNode(viewRef.productNodeName);
            if (node == null) throw new Exception("Unknown raster data source: " + viewRef.productNodeName);
            sceneImage = new ProductSceneImage(node, applicationPreferences, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
        } else {
            Band rBand = Session.getRgbBand(product, viewRef.expressionR, RGBImageProfile.RGB_BAND_NAMES[0]);
            Band gBand = Session.getRgbBand(product, viewRef.expressionG, RGBImageProfile.RGB_BAND_NAMES[1]);
            Band bBand = Session.getRgbBand(product, viewRef.expressionB, RGBImageProfile.RGB_BAND_NAMES[2]);
            sceneImage = new ProductSceneImage(viewRef.viewName, (RasterDataNode)rBand, (RasterDataNode)gBand, (RasterDataNode)bBand, applicationPreferences, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
        }
        ProductSceneView view = new ProductSceneView(sceneImage);
        Rectangle bounds = viewRef.bounds;
        if (bounds != null && !bounds.isEmpty()) {
            view.setBounds(bounds);
        }
        if ((viewportDef = viewRef.viewportDef) == null) return view;
        Viewport viewport = view.getLayerCanvas().getViewport();
        viewport.setModelYAxisDown(viewportDef.modelYAxisDown);
        viewport.setZoomFactor(viewportDef.zoomFactor);
        viewport.setOrientation(viewportDef.orientation);
        viewport.setOffset(viewportDef.offsetX, viewportDef.offsetY);
        return view;
    }

    private static void collectMetadataView(ViewRef viewRef, ProductManager productManager, ArrayList<ProductNodeView> views) throws Exception {
        Product product = productManager.getProductByRefNo(viewRef.productRefNo);
        if (product != null) {
            String[] productNodeNames = viewRef.productNodeName.split("\\|");
            MetadataElement element = product.getMetadataRoot();
            for (int i = productNodeNames.length - 1; i >= 0 && element != null; element = element.getElement(productNodeNames[i]), --i) {
            }
        } else {
            throw new Exception("Unknown product reference number: " + viewRef.productRefNo);
        }
    }

    private static void addLayerRef(LayerContext layerContext, Layer parentLayer, LayerRef layerRef, ProductManager productManager) throws ConversionException, ValidationException {
        LayerType type = LayerTypeRegistry.getLayerType((String)layerRef.layerTypeName);
        if (type != null) {
            SessionDomConverter converter = new SessionDomConverter(productManager);
            PropertySet template = type.createLayerConfig(layerContext);
            converter.convertDomToValue(layerRef.configuration, template);
            Layer layer = type.createLayer(layerContext, template);
            layer.setId(layerRef.id);
            layer.setVisible(layerRef.visible);
            layer.setTransparency(layerRef.transparency);
            layer.setName(layerRef.name);
            parentLayer.getChildren().add(layerRef.zOrder, layer);
            for (LayerRef child : layerRef.children) {
                Session.addLayerRef(layerContext, layer, child, productManager);
            }
        }
    }

    public static Container getRootPaneContainer(JComponent component) {
        JComponent lastParent;
        Container parent = component;
        do {
            if (!(parent instanceof RootPaneContainer)) continue;
            return parent;
        } while ((parent = (lastParent = parent).getParent()) != null);
        return lastParent;
    }

    private static Product getProductForRefNo(Product[] products, int refNo) {
        for (Product product : products) {
            if (product.getRefNo() != refNo) continue;
            return product;
        }
        return null;
    }

    private static Band getRgbBand(Product product, String expression, String bandName) {
        Object band = null;
        if (expression != null && !expression.isEmpty()) {
            band = product.getBand(expression);
        }
        if (band == null) {
            if (expression == null || expression.isEmpty()) {
                expression = "0.0";
            }
            band = new Channel(bandName, product, expression);
        }
        return band;
    }

    public static class URIConverter
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return type.equals(URI.class);
        }

        public Object fromString(String str) {
            try {
                return new URI(str);
            }
            catch (URISyntaxException e) {
                throw new com.thoughtworks.xstream.converters.ConversionException((Throwable)e);
            }
        }
    }

    public static class URIConverterWrapper
    extends SingleValueConverterWrapper {
        public URIConverterWrapper() {
            super((SingleValueConverter)new URIConverter());
        }
    }

    private static class Channel
    extends VirtualBand {
        public Channel(String name, Product product, String expression) {
            super(name, 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), expression);
            this.setOwner((ProductNode)product);
        }
    }

    @XStreamAlias(value="viewport")
    public static class ViewportDef {
        boolean modelYAxisDown;
        double offsetX;
        double offsetY;
        double zoomFactor;
        double orientation;

        public ViewportDef() {
        }

        public ViewportDef(boolean modelYAxisDown, double offsetX, double offsetY, double zoomFactor, double orientation) {
            this.modelYAxisDown = modelYAxisDown;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.zoomFactor = zoomFactor;
            this.orientation = orientation;
        }
    }

    @XStreamAlias(value="layer")
    public static class LayerRef {
        @XStreamAlias(value="type")
        String layerTypeName;
        String id;
        String name;
        boolean visible;
        double transparency;
        int zOrder;
        @XStreamConverter(value=DomElementXStreamConverter.class)
        DomElement configuration;
        LayerRef[] children;

        public LayerRef() {
        }

        public LayerRef(Layer layer, int zOrder, DomElement configuration, LayerRef[] children) {
            this.layerTypeName = layer.getLayerType().getName();
            this.id = layer.getId();
            this.name = layer.getName();
            this.visible = layer.isVisible();
            this.transparency = layer.getTransparency();
            this.zOrder = zOrder;
            this.configuration = configuration;
            this.children = children;
        }
    }

    @XStreamAlias(value="view")
    public static class ViewRef {
        int id;
        String type;
        Rectangle bounds;
        @XStreamAlias(value="viewport")
        ViewportDef viewportDef;
        int productRefNo;
        String productNodeName;
        String viewName;
        String expressionR;
        String expressionG;
        String expressionB;
        @XStreamAlias(value="layers")
        LayerRef[] layerRefs;

        public ViewRef() {
        }

        public ViewRef(int id, String type, Rectangle bounds, ViewportDef viewportDef, int productRefNo, String productNodeName, String viewName, String expressionR, String expressionG, String expressionB, LayerRef[] layerRefs) {
            this.id = id;
            this.type = type;
            this.bounds = bounds;
            this.viewportDef = viewportDef;
            this.productRefNo = productRefNo;
            this.productNodeName = productNodeName;
            this.viewName = viewName;
            this.expressionR = expressionR;
            this.expressionG = expressionG;
            this.expressionB = expressionB;
            this.layerRefs = layerRefs;
        }

        public int getLayerCount() {
            return this.layerRefs.length;
        }

        public LayerRef getLayerRef(int index) {
            return this.layerRefs[index];
        }
    }

    @XStreamAlias(value="product")
    public static class ProductRef {
        int refNo;
        @XStreamConverter(value=URIConverterWrapper.class)
        URI uri;
        String productReaderPlugin;

        public ProductRef() {
        }

        public ProductRef(int refNo, URI uri, String productReaderPlugin) {
            this.refNo = refNo;
            this.uri = uri;
            this.productReaderPlugin = productReaderPlugin;
        }
    }

    public static interface ProblemSolver {
        public Product solveProductNotFound(int var1, File var2) throws CanceledException;
    }
}

