/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.core.layer.NoDataLayerType;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferenceUtils;
import org.openide.util.HelpCtx;

public final class NoDataLayerController
extends DefaultConfigController {
    public static final String PROPERTY_KEY_NO_DATA_OVERLAY_COLOR = "noDataOverlay.color";
    public static final String PROPERTY_KEY_NO_DATA_OVERLAY_TRANSPARENCY = "noDataOverlay.transparency";

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new NoDataBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property noDataOverlayColor = context.getPropertySet().getProperty(PROPERTY_KEY_NO_DATA_OVERLAY_COLOR);
        Property noDataOverlayTransparency = context.getPropertySet().getProperty(PROPERTY_KEY_NO_DATA_OVERLAY_TRANSPARENCY);
        JComponent[] noDataOverlayColorComponents = PreferenceUtils.createColorComponents(noDataOverlayColor);
        JComponent[] noDataOverlayTransparencyComponents = registry.findPropertyEditor(noDataOverlayTransparency.getDescriptor()).createComponents(noDataOverlayTransparency.getDescriptor(), context);
        pageUI.add(noDataOverlayColorComponents[0]);
        pageUI.add(noDataOverlayColorComponents[1]);
        pageUI.add(noDataOverlayTransparencyComponents[1]);
        pageUI.add(noDataOverlayTransparencyComponents[0]);
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(100), "East");
        return parent;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("layer");
    }

    static class NoDataBean {
        @Preference(label="No-data overlay colour", key="noDataOverlay.color")
        Color noDataOverlayColor = NoDataLayerType.DEFAULT_COLOR;
        @Preference(label="No-data overlay transparency", key="noDataOverlay.transparency", interval="[0.0,1.0]")
        double noDataOverlayTransparency = 0.3;

        NoDataBean() {
        }
    }
}

