/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferenceUtils;
import org.openide.util.HelpCtx;

public final class GraticuleLayerController
extends DefaultConfigController {
    private JComponent[] textFgColorComponents;
    private JComponent[] textBgColorComponents;

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new GraticuleBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(0, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(8, 0, Integer.valueOf(2));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property computeLatLonSteps = context.getPropertySet().getProperty("graticule.res.auto");
        Property avgGridSize = context.getPropertySet().getProperty("graticule.res.pixels");
        Property latStep = context.getPropertySet().getProperty("graticule.res.lat");
        Property lonStep = context.getPropertySet().getProperty("graticule.res.lon");
        Property lineColor = context.getPropertySet().getProperty("graticule.line.color");
        Property lineWidth = context.getPropertySet().getProperty("graticule.line.width");
        Property lineTransparency = context.getPropertySet().getProperty("graticule.line.transparency");
        Property showTextLabels = context.getPropertySet().getProperty("graticule.text.enabled");
        Property textFgColor = context.getPropertySet().getProperty("graticule.text.fg.color");
        Property textBgColor = context.getPropertySet().getProperty("graticule.text.bg.color");
        Property textBgTransparency = context.getPropertySet().getProperty("graticule.text.bg.transparency");
        JComponent[] computeLatLonStepsComponents = registry.findPropertyEditor(computeLatLonSteps.getDescriptor()).createComponents(computeLatLonSteps.getDescriptor(), context);
        JComponent[] avgGridSizeComponents = registry.findPropertyEditor(avgGridSize.getDescriptor()).createComponents(avgGridSize.getDescriptor(), context);
        JComponent[] latStepComponents = registry.findPropertyEditor(latStep.getDescriptor()).createComponents(latStep.getDescriptor(), context);
        JComponent[] lonStepComponents = registry.findPropertyEditor(lonStep.getDescriptor()).createComponents(lonStep.getDescriptor(), context);
        JComponent[] lineColorComponents = PreferenceUtils.createColorComponents(lineColor);
        JComponent[] lineWidthComponents = registry.findPropertyEditor(lineWidth.getDescriptor()).createComponents(lineWidth.getDescriptor(), context);
        JComponent[] lineTransparencyComponents = registry.findPropertyEditor(lineTransparency.getDescriptor()).createComponents(lineTransparency.getDescriptor(), context);
        JComponent[] showTextLabelsComponents = registry.findPropertyEditor(showTextLabels.getDescriptor()).createComponents(showTextLabels.getDescriptor(), context);
        this.textFgColorComponents = PreferenceUtils.createColorComponents(textFgColor);
        this.textBgColorComponents = PreferenceUtils.createColorComponents(textBgColor);
        JComponent[] textBgTransparencyComponents = registry.findPropertyEditor(textBgTransparency.getDescriptor()).createComponents(textBgTransparency.getDescriptor(), context);
        pageUI.add(computeLatLonStepsComponents[0]);
        PreferenceUtils.addNote(pageUI, "<html>Note: Deselect this option only very carefully. The latitude and longitude<br>steps you enter will be used for low and high resolution products.</html>");
        pageUI.add(avgGridSizeComponents[1]);
        pageUI.add(avgGridSizeComponents[0]);
        pageUI.add(latStepComponents[1]);
        pageUI.add(latStepComponents[0]);
        pageUI.add(lonStepComponents[1]);
        pageUI.add(lonStepComponents[0]);
        pageUI.add(lineColorComponents[0]);
        pageUI.add(lineColorComponents[1]);
        pageUI.add(lineWidthComponents[1]);
        pageUI.add(lineWidthComponents[0]);
        pageUI.add(lineTransparencyComponents[1]);
        pageUI.add(lineTransparencyComponents[0]);
        pageUI.add(showTextLabelsComponents[0]);
        pageUI.add(this.textFgColorComponents[0]);
        pageUI.add(this.textFgColorComponents[1]);
        pageUI.add(this.textBgColorComponents[0]);
        pageUI.add(this.textBgColorComponents[1]);
        pageUI.add(textBgTransparencyComponents[1]);
        pageUI.add(textBgTransparencyComponents[0]);
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(100), "East");
        return parent;
    }

    @Override
    protected void configure(BindingContext context) {
        Enablement enablementAvgGridSize = context.bindEnabledState("graticule.res.pixels", true, "graticule.res.auto", (Object)true);
        Enablement enablementLatStep = context.bindEnabledState("graticule.res.lat", true, "graticule.res.auto", (Object)false);
        Enablement enablementLonStep = context.bindEnabledState("graticule.res.lon", true, "graticule.res.auto", (Object)false);
        context.getPropertySet().getProperty("graticule.res.auto").addPropertyChangeListener(evt -> {
            enablementAvgGridSize.apply();
            enablementLatStep.apply();
            enablementLonStep.apply();
        });
        Enablement enablementTextBgTransparency = context.bindEnabledState("graticule.text.bg.transparency", true, "graticule.text.enabled", (Object)true);
        context.getPropertySet().getProperty("graticule.text.enabled").addPropertyChangeListener(evt -> {
            enablementTextBgTransparency.apply();
            for (JComponent component : this.textFgColorComponents) {
                component.setEnabled((Boolean)evt.getNewValue());
            }
            for (JComponent component : this.textBgColorComponents) {
                component.setEnabled((Boolean)evt.getNewValue());
            }
        });
        for (JComponent component : this.textFgColorComponents) {
            component.setEnabled(true);
        }
        for (JComponent component : this.textBgColorComponents) {
            component.setEnabled(true);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("layer");
    }

    static class GraticuleBean {
        @Preference(label="Compute latitude and longitude steps", key="graticule.res.auto")
        boolean computeLatLonSteps = true;
        @Preference(label="Average grid size in pixels", key="graticule.res.pixels", interval="[16,512]")
        int averageGridSize = 128;
        @Preference(label="Latitude step (dec. degree)", key="graticule.res.lat", interval="[0.01,90.0]")
        double latStep = 1.0;
        @Preference(label="Longitude step (dec. degree)", key="graticule.res.lon", interval="[0.01,180.0]")
        double lonStep = 1.0;
        @Preference(label="Line colour", key="graticule.line.color")
        Color lineColor = new Color(204, 204, 255);
        @Preference(label="Line width", key="graticule.line.width")
        double lineWidth = 0.5;
        @Preference(label="Line transparency", key="graticule.line.transparency", interval="[0.0,1.0]")
        double lineTransparency = 0.0;
        @Preference(label="Show text labels", key="graticule.text.enabled")
        boolean showTextLabels = true;
        @Preference(label="Text foreground colour", key="graticule.text.fg.color")
        Color fgColor = Color.white;
        @Preference(label="Text background colour", key="graticule.text.bg.color")
        Color bgColor = Color.black;
        @Preference(label="Text background transparency", key="graticule.text.bg.transparency", interval="[0.0,1.0]")
        double textBgTransparency = 0.7;

        GraticuleBean() {
        }
    }
}

