/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark.gcp;

import com.bc.ceres.swing.TableLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.util.Debug;

class GcpGeoCodingForm
extends JPanel {
    private JTextField methodTextField;
    private JTextField rmseLatTextField;
    private JTextField rmseLonTextField;
    private JComboBox methodComboBox;
    private JToggleButton attachButton;
    private JTextField warningLabel;
    private Product currentProduct;
    private Format rmseNumberFormat = new RmseNumberFormat();
    private GcpGroupListener currentGcpGroupListener = new GcpGroupListener();

    public GcpGeoCodingForm() {
        this.initComponents();
    }

    private void initComponents() {
        TableLayout layout = new TableLayout(2);
        this.setLayout((LayoutManager)layout);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableWeightY(Double.valueOf(1.0));
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTablePadding(2, 2);
        layout.setColumnWeightX(0, Double.valueOf(0.5));
        layout.setColumnWeightX(1, Double.valueOf(0.5));
        this.add(this.createInfoPanel());
        this.add(this.createAttachDetachPanel());
        this.updateUIState();
    }

    private JPanel createInfoPanel() {
        TableLayout layout = new TableLayout(2);
        layout.setTablePadding(2, 4);
        layout.setColumnWeightX(0, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Current GCP Geo-Coding"));
        panel.add(new JLabel("Method:"));
        this.methodTextField = new JTextField();
        this.setComponentName(this.methodTextField, "methodTextField");
        this.methodTextField.setEditable(false);
        this.methodTextField.setHorizontalAlignment(11);
        panel.add(this.methodTextField);
        this.rmseLatTextField = new JTextField();
        this.setComponentName(this.rmseLatTextField, "rmseLatTextField");
        this.rmseLatTextField.setEditable(false);
        this.rmseLatTextField.setHorizontalAlignment(11);
        panel.add(new JLabel("RMSE Lat:"));
        panel.add(this.rmseLatTextField);
        this.rmseLonTextField = new JTextField();
        this.setComponentName(this.rmseLonTextField, "rmseLonTextField");
        this.rmseLonTextField.setEditable(false);
        this.rmseLonTextField.setHorizontalAlignment(11);
        panel.add(new JLabel("RMSE Lon:"));
        panel.add(this.rmseLonTextField);
        return panel;
    }

    private JPanel createAttachDetachPanel() {
        this.methodComboBox = new JComboBox<GcpGeoCoding.Method>(GcpGeoCoding.Method.values());
        this.setComponentName(this.methodComboBox, "methodComboBox");
        this.methodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GcpGeoCodingForm.this.updateUIState();
            }
        });
        this.attachButton = new JToggleButton();
        this.setComponentName(this.attachButton, "attachButton");
        this.attachButton.setName("attachButton");
        AbstractAction attachDetachAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(GcpGeoCodingForm.this.currentProduct.getSceneGeoCoding() instanceof GcpGeoCoding)) {
                    GcpGeoCodingForm.this.attachGeoCoding(GcpGeoCodingForm.this.currentProduct);
                } else {
                    GcpGeoCodingForm.this.detachGeoCoding(GcpGeoCodingForm.this.currentProduct);
                }
            }
        };
        this.attachButton.setAction(attachDetachAction);
        this.attachButton.setHideActionText(true);
        this.warningLabel = new JTextField();
        this.warningLabel.setEditable(false);
        TableLayout layout = new TableLayout(2);
        layout.setTablePadding(2, 4);
        layout.setColumnWeightX(0, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setCellColspan(2, 0, Integer.valueOf(2));
        layout.setCellFill(2, 0, TableLayout.Fill.VERTICAL);
        layout.setCellAnchor(2, 0, TableLayout.Anchor.CENTER);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder("Attach / Detach GCP Geo-Coding"));
        panel.add(new JLabel("Method:"));
        panel.add(this.methodComboBox);
        panel.add(new JLabel("Status:"));
        panel.add(this.warningLabel);
        panel.add(this.attachButton);
        return panel;
    }

    void updateUIState() {
        if (this.currentProduct != null && this.currentProduct.getSceneGeoCoding() instanceof GcpGeoCoding) {
            GcpGeoCoding gcpGeoCoding = (GcpGeoCoding)this.currentProduct.getSceneGeoCoding();
            this.rmseLatTextField.setText(this.rmseNumberFormat.format(gcpGeoCoding.getRmseLat()));
            this.rmseLonTextField.setText(this.rmseNumberFormat.format(gcpGeoCoding.getRmseLon()));
            this.methodTextField.setText(gcpGeoCoding.getMethod().getName());
            this.methodComboBox.setSelectedItem(gcpGeoCoding.getMethod());
            this.methodComboBox.setEnabled(false);
            this.attachButton.setText("Detach");
            this.attachButton.setSelected(true);
            this.attachButton.setEnabled(true);
            this.warningLabel.setText("GCP geo-coding attached");
            this.warningLabel.setForeground(Color.BLACK);
        } else {
            this.methodComboBox.setEnabled(true);
            this.methodTextField.setText("n/a");
            this.rmseLatTextField.setText(this.rmseNumberFormat.format(Double.NaN));
            this.rmseLonTextField.setText(this.rmseNumberFormat.format(Double.NaN));
            this.attachButton.setText("Attach");
            this.attachButton.setSelected(false);
            this.updateAttachButtonAndStatus();
        }
    }

    private void updateAttachButtonAndStatus() {
        GcpGeoCoding.Method method = (GcpGeoCoding.Method)this.methodComboBox.getSelectedItem();
        if (this.currentProduct != null && GcpGeoCodingForm.getValidGcpCount(this.currentProduct.getGcpGroup()) >= method.getTermCountP()) {
            this.attachButton.setEnabled(true);
            this.warningLabel.setText("OK, enough GCPs for selected method");
            this.warningLabel.setForeground(Color.GREEN.darker());
        } else {
            this.attachButton.setEnabled(false);
            this.warningLabel.setText("Not enough (valid) GCPs for selected method");
            this.warningLabel.setForeground(Color.RED.darker());
        }
    }

    private void detachGeoCoding(Product product) {
        if (product.getSceneGeoCoding() instanceof GcpGeoCoding) {
            GeoCoding gc = ((GcpGeoCoding)product.getSceneGeoCoding()).getOriginalGeoCoding();
            product.setSceneGeoCoding(gc);
        }
        this.updateUIState();
    }

    private void attachGeoCoding(final Product product) {
        final GcpGeoCoding.Method method = (GcpGeoCoding.Method)this.methodComboBox.getSelectedItem();
        final Placemark[] gcps = GcpGeoCodingForm.getValidGcps((ProductNodeGroup<Placemark>)product.getGcpGroup());
        GeoCoding geoCoding = product.getSceneGeoCoding();
        final Datum datum = geoCoding == null ? Datum.WGS_84 : geoCoding.getDatum();
        SwingWorker<GcpGeoCoding, GcpGeoCoding> sw = new SwingWorker<GcpGeoCoding, GcpGeoCoding>(){

            @Override
            protected GcpGeoCoding doInBackground() throws Exception {
                GcpGeoCoding gcpGeoCoding = new GcpGeoCoding(method, gcps, product.getSceneRasterWidth(), product.getSceneRasterHeight(), datum);
                gcpGeoCoding.setOriginalGeoCoding(product.getSceneGeoCoding());
                return gcpGeoCoding;
            }

            @Override
            protected void done() {
                try {
                    GcpGeoCoding gcpGeoCoding = (GcpGeoCoding)this.get();
                    product.setSceneGeoCoding((GeoCoding)gcpGeoCoding);
                    GcpGeoCodingForm.this.updateUIState();
                }
                catch (InterruptedException e) {
                    Debug.trace((Throwable)e);
                }
                catch (ExecutionException e) {
                    Debug.trace((Throwable)e.getCause());
                }
            }
        };
        sw.execute();
    }

    public void setProduct(Product product) {
        if (product == this.currentProduct) {
            return;
        }
        if (this.currentProduct != null) {
            this.currentProduct.removeProductNodeListener((ProductNodeListener)this.currentGcpGroupListener);
        }
        this.currentProduct = product;
        if (this.currentProduct != null) {
            this.currentProduct.addProductNodeListener((ProductNodeListener)this.currentGcpGroupListener);
        }
    }

    private void setComponentName(JComponent component, String name) {
        component.setName(this.getClass().getName() + name);
    }

    private static Placemark[] getValidGcps(ProductNodeGroup<Placemark> gcpGroup) {
        ArrayList<Placemark> gcpList = new ArrayList<Placemark>(gcpGroup.getNodeCount());
        for (int i = 0; i < gcpGroup.getNodeCount(); ++i) {
            Placemark p = (Placemark)gcpGroup.get(i);
            PixelPos pixelPos = p.getPixelPos();
            GeoPos geoPos = p.getGeoPos();
            if (pixelPos == null || !pixelPos.isValid() || geoPos == null || !geoPos.isValid()) continue;
            gcpList.add(p);
        }
        return gcpList.toArray(new Placemark[gcpList.size()]);
    }

    private static int getValidGcpCount(PlacemarkGroup gcpGroup) {
        int count = 0;
        for (int i = 0; i < gcpGroup.getNodeCount(); ++i) {
            Placemark p = (Placemark)gcpGroup.get(i);
            if (!GcpGeoCodingForm.isValid(p)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isValid(Placemark p) {
        PixelPos pixelPos = p.getPixelPos();
        GeoPos geoPos = p.getGeoPos();
        return pixelPos != null && pixelPos.isValid() && geoPos != null && geoPos.isValid();
    }

    private class GcpGroupListener
    implements ProductNodeListener {
        private GcpGroupListener() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            if ("sceneGeoCoding".equals(event.getPropertyName())) {
                return;
            }
            ProductNode sourceNode = event.getSourceNode();
            if (sourceNode instanceof Placemark && GcpGeoCodingForm.this.currentProduct.getGcpGroup().contains((ProductNode)((Placemark)sourceNode))) {
                this.updateGcpGeoCoding();
            }
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.nodeChanged(event);
        }

        public void nodeAdded(ProductNodeEvent event) {
            if (event.getGroup() == GcpGeoCodingForm.this.currentProduct.getGcpGroup()) {
                this.updateGcpGeoCoding();
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            if (event.getGroup() == GcpGeoCodingForm.this.currentProduct.getGcpGroup()) {
                this.updateGcpGeoCoding();
            }
        }

        private void updateGcpGeoCoding() {
            GeoCoding geoCoding = GcpGeoCodingForm.this.currentProduct.getSceneGeoCoding();
            if (geoCoding instanceof GcpGeoCoding) {
                GcpGeoCoding gcpGeoCoding = (GcpGeoCoding)geoCoding;
                PlacemarkGroup gcpGroup = GcpGeoCodingForm.this.currentProduct.getGcpGroup();
                int gcpCount = gcpGroup.getNodeCount();
                if (gcpCount < gcpGeoCoding.getMethod().getTermCountP()) {
                    GcpGeoCodingForm.this.detachGeoCoding(GcpGeoCodingForm.this.currentProduct);
                } else {
                    gcpGeoCoding.setGcps((Placemark[])gcpGroup.toArray((ProductNode[])new Placemark[gcpCount]));
                    GcpGeoCodingForm.this.currentProduct.fireProductNodeChanged("sceneGeoCoding");
                    GcpGeoCodingForm.this.updateUIState();
                }
            }
        }
    }

    private static class RmseNumberFormat
    extends NumberFormat {
        DecimalFormat format = new DecimalFormat("0.0####");

        private RmseNumberFormat() {
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            if (Double.isNaN(number)) {
                return toAppendTo.append("n/a");
            }
            return this.format.format(number, toAppendTo, pos);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format.format(number, toAppendTo, pos);
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return this.format.parse(source, parsePosition);
        }
    }
}

