/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.pixelinfo;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.grender.Viewport;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Calendar;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.pixelinfo.PixelInfoState;
import org.esa.snap.rcp.pixelinfo.PixelInfoView;
import org.esa.snap.rcp.pixelinfo.PixelInfoViewTableModel;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.geometry.DirectPosition2D;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class PixelInfoViewModelUpdater {
    private static final String INVALID_POS_TEXT = "Invalid pos.";
    private final PixelInfoViewTableModel positionModel;
    private final PixelInfoViewTableModel timeModel;
    private final PixelInfoViewTableModel bandModel;
    private final PixelInfoViewTableModel tiePointModel;
    private final PixelInfoViewTableModel flagModel;
    private volatile Product currentProduct;
    private volatile RasterDataNode currentRaster;
    private volatile ProductSceneView currentView;
    private Band[] currentFlagBands;
    private int pixelX;
    private int pixelY;
    private int rasterLevel;
    private int levelZeroRasterX;
    private int levelZeroRasterY;
    private double sceneX;
    private double sceneY;
    private int levelZeroSceneX;
    private int levelZeroSceneY;
    private boolean pixelPosValidInRaster;
    private final PixelInfoView pixelInfoView;

    PixelInfoViewModelUpdater(PixelInfoView pixelInfoView, PixelInfoViewTableModel positionModel, PixelInfoViewTableModel timeModel, PixelInfoViewTableModel bandModel, PixelInfoViewTableModel tiePointModel, PixelInfoViewTableModel flagModel) {
        this.pixelInfoView = pixelInfoView;
        this.positionModel = positionModel;
        this.timeModel = timeModel;
        this.bandModel = bandModel;
        this.tiePointModel = tiePointModel;
        this.flagModel = flagModel;
    }

    Product getCurrentProduct() {
        return this.currentProduct;
    }

    RasterDataNode getCurrentRaster() {
        return this.currentRaster;
    }

    void update(PixelInfoState state) {
        this.update(state.view, state.pixelX, state.pixelY, state.level, state.pixelPosValid);
    }

    void update(ProductSceneView view, int pixelX, int pixelY, int level, boolean pixelPosValid) {
        Guardian.assertNotNull((String)"view", (Object)view);
        boolean clearRasterTableSelection = false;
        RasterDataNode raster = view.getRaster();
        Product product = raster.getProduct();
        if (product == this.currentProduct && view.isRGB()) {
            this.resetBandTableModel();
        }
        if (product != this.currentProduct) {
            ProductNodeListener productNodeListener = this.pixelInfoView.getProductNodeListener();
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener(productNodeListener);
            }
            product.addProductNodeListener(productNodeListener);
            this.currentProduct = product;
        }
        if (raster != this.currentRaster) {
            this.currentRaster = raster;
            this.registerFlagDatasets();
            this.resetTableModels();
        }
        if (this.bandModel.getRowCount() != this.getBandRowCount()) {
            this.resetTableModels();
        }
        if (view != this.currentView) {
            this.currentView = view;
            this.resetTableModels();
            clearRasterTableSelection = true;
        }
        this.pixelX = pixelX;
        this.pixelY = pixelY;
        this.rasterLevel = level;
        this.pixelPosValidInRaster = pixelPosValid;
        AffineTransform i2mTransform = this.currentView.getBaseImageLayer().getImageToModelTransform(level);
        Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
        try {
            Point2D sceneP = this.currentView.getRaster().getModelToSceneTransform().transform(modelP, (Point2D)new Point2D.Double());
            this.sceneX = sceneP.getX();
            this.sceneY = sceneP.getY();
        }
        catch (TransformException e) {
            this.sceneX = Double.NaN;
            this.sceneY = Double.NaN;
        }
        AffineTransform m2iTransform = view.getBaseImageLayer().getModelToImageTransform();
        Point2D levelZeroP = m2iTransform.transform(modelP, null);
        this.levelZeroRasterX = this.floor(levelZeroP.getX());
        this.levelZeroRasterY = this.floor(levelZeroP.getY());
        if (product.isMultiSizeProduct()) {
            try {
                GeoCoding sceneGeoCoding = product.getSceneGeoCoding();
                if (sceneGeoCoding != null) {
                    MathTransform imageToMapTransform = sceneGeoCoding.getImageToMapTransform();
                    if (imageToMapTransform instanceof AffineTransform) {
                        MathTransform modelToImage = imageToMapTransform.inverse();
                        DirectPosition2D pos = new DirectPosition2D(this.sceneX, this.sceneY);
                        DirectPosition position = modelToImage.transform((DirectPosition)pos, (DirectPosition)pos);
                        this.levelZeroSceneX = this.floor(position.getCoordinate()[0]);
                        this.levelZeroSceneY = this.floor(position.getCoordinate()[1]);
                    } else {
                        this.levelZeroSceneX = this.floor(this.sceneX);
                        this.levelZeroSceneY = this.floor(this.sceneY);
                    }
                }
            }
            catch (TransformException e) {
                this.levelZeroSceneX = this.levelZeroRasterX;
                this.levelZeroSceneY = this.levelZeroRasterY;
            }
        }
        this.updateDataDisplay(clearRasterTableSelection);
    }

    private void resetTableModels() {
        this.resetPositionTableModel();
        this.resetTimeTableModel();
        this.resetBandTableModel();
        this.resetTiePointGridTableModel();
        this.resetFlagTableModel();
    }

    private void fireTableChanged(boolean clearRasterTableSelection) {
        SwingUtilities.invokeLater(() -> {
            if (clearRasterTableSelection) {
                this.pixelInfoView.clearSelectionInRasterTables();
            }
            this.positionModel.fireTableDataChanged();
            this.timeModel.fireTableDataChanged();
            this.bandModel.fireTableDataChanged();
            this.tiePointModel.fireTableDataChanged();
            this.flagModel.fireTableDataChanged();
        });
    }

    private void updateDataDisplay(boolean clearRasterTableSelection) {
        if (this.currentRaster == null) {
            return;
        }
        if (this.pixelInfoView.isCollapsiblePaneVisible(0)) {
            this.updatePositionValues();
        }
        if (this.pixelInfoView.isCollapsiblePaneVisible(1)) {
            this.updateTimeValues();
        }
        if (this.pixelInfoView.isCollapsiblePaneVisible(2)) {
            this.updateBandPixelValues();
        }
        if (this.pixelInfoView.isCollapsiblePaneVisible(3)) {
            this.updateTiePointGridPixelValues();
        }
        if (this.pixelInfoView.isCollapsiblePaneVisible(4)) {
            this.updateFlagPixelValues();
        }
        this.fireTableChanged(clearRasterTableSelection);
    }

    private void resetPositionTableModel() {
        this.positionModel.clear();
        if (this.currentRaster != null) {
            GeoCoding geoCoding = this.currentRaster.getGeoCoding();
            this.positionModel.addRow("Image-X", "", "pixel");
            this.positionModel.addRow("Image-Y", "", "pixel");
            if (this.getCurrentProduct().isMultiSizeProduct()) {
                this.positionModel.addRow("Scene-X", "", "pixel");
                this.positionModel.addRow("Scene-Y", "", "pixel");
            }
            if (geoCoding != null) {
                this.positionModel.addRow("Longitude", "", "degree");
                this.positionModel.addRow("Latitude", "", "degree");
                if (geoCoding instanceof MapGeoCoding) {
                    MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
                    String mapUnit = mapGeoCoding.getMapInfo().getMapProjection().getMapUnit();
                    this.positionModel.addRow("Map-X", "", mapUnit);
                    this.positionModel.addRow("Map-Y", "", mapUnit);
                } else if (geoCoding instanceof CrsGeoCoding) {
                    String xAxisUnit = geoCoding.getMapCRS().getCoordinateSystem().getAxis(0).getUnit().toString();
                    String yAxisUnit = geoCoding.getMapCRS().getCoordinateSystem().getAxis(1).getUnit().toString();
                    this.positionModel.addRow("Map-X", "", xAxisUnit);
                    this.positionModel.addRow("Map-Y", "", yAxisUnit);
                }
            }
        }
    }

    private void updatePositionValues() {
        boolean availableInRaster = this.pixelPosValidInRaster && this.coordinatesAreInRasterBounds(this.currentRaster, this.pixelX, this.pixelY, this.rasterLevel);
        boolean availableInScene = this.isSampleValueAvailableInScene();
        double offset = 0.5 + (this.pixelInfoView.getShowPixelPosOffset1() ? 1.0 : 0.0);
        double pX = (double)this.levelZeroRasterX + offset;
        double pY = (double)this.levelZeroRasterY + offset;
        String tgy = INVALID_POS_TEXT;
        String tgx = INVALID_POS_TEXT;
        String tmy = INVALID_POS_TEXT;
        String tmx = INVALID_POS_TEXT;
        String tsy = INVALID_POS_TEXT;
        String tsx = INVALID_POS_TEXT;
        String tiy = INVALID_POS_TEXT;
        String tix = INVALID_POS_TEXT;
        GeoCoding geoCoding = this.currentRaster.getGeoCoding();
        if (availableInRaster) {
            if (this.pixelInfoView.getShowPixelPosDecimal()) {
                tix = String.valueOf(pX);
                tiy = String.valueOf(pY);
            } else {
                tix = String.valueOf((int)Math.floor(pX));
                tiy = String.valueOf((int)Math.floor(pY));
            }
        }
        if (this.getCurrentProduct().isMultiSizeProduct()) {
            if (!availableInScene) {
                tsx = INVALID_POS_TEXT;
                tsy = INVALID_POS_TEXT;
            } else {
                double sX = (double)this.levelZeroSceneX + offset;
                double sY = (double)this.levelZeroSceneY + offset;
                if (this.pixelInfoView.getShowPixelPosDecimal()) {
                    tsx = String.valueOf(sX);
                    tsy = String.valueOf(sY);
                } else {
                    tsx = String.valueOf((int)Math.floor(sX));
                    tsy = String.valueOf((int)Math.floor(sY));
                }
            }
        }
        if (availableInRaster && geoCoding != null) {
            PixelPos pixelPos = new PixelPos(pX, pY);
            GeoPos geoPos = geoCoding.getGeoPos(pixelPos, null);
            if (this.pixelInfoView.getShowGeoPosDecimals()) {
                tgx = String.format("%.6f", geoPos.getLon());
                tgy = String.format("%.6f", geoPos.getLat());
            } else {
                tgx = geoPos.getLonString();
                tgy = geoPos.getLatString();
            }
            if (geoCoding instanceof MapGeoCoding) {
                MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
                MapTransform mapTransform = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform();
                Point2D mapPoint = mapTransform.forward(geoPos, null);
                tmx = String.valueOf(MathUtils.round((double)mapPoint.getX(), (double)10000.0));
                tmy = String.valueOf(MathUtils.round((double)mapPoint.getY(), (double)10000.0));
            } else if (geoCoding instanceof CrsGeoCoding) {
                MathTransform transform = geoCoding.getImageToMapTransform();
                try {
                    DirectPosition position = transform.transform((DirectPosition)new DirectPosition2D(pX, pY), null);
                    double[] coordinate = position.getCoordinate();
                    tmx = String.valueOf(coordinate[0]);
                    tmy = String.valueOf(coordinate[1]);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
        }
        int rowCount = 0;
        this.positionModel.updateValue(tix, rowCount++);
        this.positionModel.updateValue(tiy, rowCount++);
        if (this.getCurrentProduct().isMultiSizeProduct()) {
            this.positionModel.updateValue(tsx, rowCount++);
            this.positionModel.updateValue(tsy, rowCount++);
        }
        if (geoCoding != null) {
            this.positionModel.updateValue(tgx, rowCount++);
            this.positionModel.updateValue(tgy, rowCount++);
            if (geoCoding instanceof MapGeoCoding || geoCoding instanceof CrsGeoCoding) {
                this.positionModel.updateValue(tmx, rowCount++);
                this.positionModel.updateValue(tmy, rowCount);
            }
        }
    }

    private void resetTimeTableModel() {
        this.timeModel.clear();
        if (this.currentRaster != null) {
            this.timeModel.addRow("Date", "", "YYYY-MM-DD");
            this.timeModel.addRow("Time (UTC)", "", "HH:MM:SS:mm [AM/PM]");
        }
    }

    private void updateTimeValues() {
        ProductData.UTC utcStartTime = this.currentProduct.getStartTime();
        ProductData.UTC utcEndTime = this.currentProduct.getEndTime();
        if (utcStartTime == null || utcEndTime == null || !this.isSampleValueAvailableInScene()) {
            this.timeModel.updateValue("No date information", 0);
            this.timeModel.updateValue("No time information", 1);
        } else {
            ProductData.UTC utcCurrentLine = ProductUtils.getScanLineTime((Product)this.currentProduct, (double)((double)this.levelZeroSceneY + 0.5));
            Assert.notNull((Object)utcCurrentLine, (String)"utcCurrentLine");
            Calendar currentLineTime = utcCurrentLine.getAsCalendar();
            String dateString = String.format("%1$tF", currentLineTime);
            String timeString = String.format("%1$tI:%1$tM:%1$tS:%1$tL %1$Tp", currentLineTime);
            this.timeModel.updateValue(dateString, 0);
            this.timeModel.updateValue(timeString, 1);
        }
    }

    private void resetBandTableModel() {
        this.bandModel.clear();
        if (this.currentRaster != null) {
            int numBands = this.currentProduct.getNumBands();
            for (int i = 0; i < numBands; ++i) {
                Band band = this.currentProduct.getBandAt(i);
                if (!this.shouldDisplayBand(band)) continue;
                this.bandModel.addRow(band.getName(), "", band.getUnit());
            }
        }
    }

    private void updateBandPixelValues() {
        for (int i = 0; i < this.bandModel.getRowCount(); ++i) {
            String bandName = (String)this.bandModel.getValueAt(i, 0);
            this.bandModel.updateValue(this.getPixelString((RasterDataNode)this.currentProduct.getBand(bandName)), i);
        }
    }

    private int getBandRowCount() {
        int rowCount = 0;
        if (this.currentProduct != null) {
            Band[] bands;
            for (Band band : bands = this.currentProduct.getBands()) {
                if (!this.shouldDisplayBand(band)) continue;
                ++rowCount;
            }
        }
        return rowCount;
    }

    private boolean shouldDisplayBand(Band band) {
        PixelInfoView.DisplayFilter displayFilter = this.pixelInfoView.getDisplayFilter();
        if (displayFilter != null) {
            return displayFilter.accept((ProductNode)band);
        }
        return band.hasRasterData();
    }

    private void resetTiePointGridTableModel() {
        this.tiePointModel.clear();
        if (this.currentRaster != null) {
            int numTiePointGrids = this.currentProduct.getNumTiePointGrids();
            for (int i = 0; i < numTiePointGrids; ++i) {
                TiePointGrid tiePointGrid = this.currentProduct.getTiePointGridAt(i);
                this.tiePointModel.addRow(tiePointGrid.getName(), "", tiePointGrid.getUnit());
            }
        }
    }

    private void updateTiePointGridPixelValues() {
        for (int i = 0; i < this.tiePointModel.getRowCount(); ++i) {
            TiePointGrid grid = this.currentProduct.getTiePointGrid((String)this.tiePointModel.getValueAt(i, 0));
            this.tiePointModel.updateValue(this.getPixelString((RasterDataNode)grid), i);
        }
    }

    private void resetFlagTableModel() {
        this.flagModel.clear();
        if (this.currentRaster != null) {
            for (Band band : this.currentFlagBands) {
                FlagCoding flagCoding = band.getFlagCoding();
                int numFlags = flagCoding.getNumAttributes();
                String bandNameDot = band.getName() + ".";
                for (int j = 0; j < numFlags; ++j) {
                    String name = bandNameDot + flagCoding.getAttributeAt(j).getName();
                    this.flagModel.addRow(name, "", "");
                }
            }
        }
    }

    private void updateFlagPixelValues() {
        if (this.flagModel.getRowCount() != this.getFlagRowCount()) {
            this.resetFlagTableModel();
        }
        int rowIndex = 0;
        for (Band band : this.currentFlagBands) {
            long pixelValue;
            boolean available;
            if (band.getImageToModelTransform().equals(this.currentRaster.getImageToModelTransform()) && band.getSceneToModelTransform().equals((Object)this.currentRaster.getSceneToModelTransform())) {
                available = this.pixelPosValidInRaster;
                pixelValue = available ? ProductUtils.getGeophysicalSampleAsLong((RasterDataNode)band, (int)this.pixelX, (int)this.pixelY, (int)this.rasterLevel) : 0L;
            } else {
                PixelPos rasterPos = new PixelPos();
                Point2D.Double scenePos = new Point2D.Double(this.sceneX, this.sceneY);
                try {
                    Point2D modelPos = band.getSceneToModelTransform().transform((Point2D)scenePos, (Point2D)new Point2D.Double());
                    MultiLevelModel multiLevelModel = band.getMultiLevelModel();
                    int level = this.getLevel(multiLevelModel);
                    multiLevelModel.getModelToImageTransform(level).transform(modelPos, (Point2D)rasterPos);
                    int rasterX = (int)Math.floor(rasterPos.getX());
                    int rasterY = (int)Math.floor(rasterPos.getY());
                    available = this.coordinatesAreInRasterBounds((RasterDataNode)band, rasterX, rasterY, level);
                    pixelValue = available ? ProductUtils.getGeophysicalSampleAsLong((RasterDataNode)band, (int)rasterX, (int)rasterY, (int)level) : 0L;
                }
                catch (TransformException e) {
                    available = false;
                    pixelValue = -1L;
                }
            }
            for (int j = 0; j < band.getFlagCoding().getNumAttributes(); ++j) {
                if (available) {
                    MetadataAttribute attribute = band.getFlagCoding().getAttributeAt(j);
                    int mask = attribute.getData().getElemInt();
                    this.flagModel.updateValue(String.valueOf((pixelValue & (long)mask) == (long)mask), rowIndex);
                } else {
                    this.flagModel.updateValue(INVALID_POS_TEXT, rowIndex);
                }
                ++rowIndex;
            }
        }
    }

    private void registerFlagDatasets() {
        Vector<Band> flagBandsVector = new Vector<Band>();
        if (this.currentProduct != null) {
            Band[] bands;
            for (Band band : bands = this.currentProduct.getBands()) {
                if (!this.isFlagBand(band)) continue;
                flagBandsVector.add(band);
            }
        }
        this.currentFlagBands = flagBandsVector.toArray(new Band[flagBandsVector.size()]);
    }

    private boolean isFlagBand(Band band) {
        return band.getFlagCoding() != null;
    }

    private int getFlagRowCount() {
        int rowCount = 0;
        for (Band band : this.currentFlagBands) {
            rowCount += band.getFlagCoding().getNumAttributes();
        }
        return rowCount;
    }

    private String getPixelString(RasterDataNode raster) {
        if (raster.getImageToModelTransform().equals(this.currentRaster.getImageToModelTransform()) && raster.getSceneToModelTransform().equals((Object)this.currentRaster.getSceneToModelTransform())) {
            if (!this.pixelPosValidInRaster) {
                return INVALID_POS_TEXT;
            }
            return this.getPixelString(raster, this.pixelX, this.pixelY, this.rasterLevel);
        }
        Point2D.Double scenePos = new Point2D.Double(this.sceneX, this.sceneY);
        Point2D.Double modelPos = new Point2D.Double();
        try {
            raster.getSceneToModelTransform().transform((Point2D)scenePos, (Point2D)modelPos);
            if (Double.isNaN(modelPos.getX()) || Double.isNaN(modelPos.getY())) {
                return INVALID_POS_TEXT;
            }
        }
        catch (TransformException e) {
            return INVALID_POS_TEXT;
        }
        MultiLevelModel multiLevelModel = raster.getMultiLevelModel();
        int level = this.getLevel(multiLevelModel);
        PixelPos rasterPos = (PixelPos)multiLevelModel.getModelToImageTransform(level).transform(modelPos, (Point2D)new PixelPos());
        int rasterX = this.floor(rasterPos.getX());
        int rasterY = this.floor(rasterPos.getY());
        if (!this.coordinatesAreInRasterBounds(raster, rasterX, rasterY, level)) {
            return INVALID_POS_TEXT;
        }
        return this.getPixelString(raster, rasterX, rasterY, level);
    }

    private int getLevel(MultiLevelModel multiLevelModel) {
        if (this.rasterLevel < multiLevelModel.getLevelCount()) {
            return this.rasterLevel;
        }
        return ImageLayer.getLevel((MultiLevelModel)multiLevelModel, (Viewport)this.currentView.getViewport());
    }

    private String getPixelString(RasterDataNode raster, int x, int y, int level) {
        if (this.isPixelValid(raster, x, y, level)) {
            if (raster.isScalingApplied() || ProductData.isFloatingPointType((int)raster.getDataType())) {
                int dataType = raster.getGeophysicalDataType();
                if (dataType == 31) {
                    double pixel = ProductUtils.getGeophysicalSampleAsDouble((RasterDataNode)raster, (int)x, (int)y, (int)level);
                    return String.format("%.10f", pixel);
                }
                if (dataType == 30) {
                    double pixel = ProductUtils.getGeophysicalSampleAsDouble((RasterDataNode)raster, (int)x, (int)y, (int)level);
                    return String.format("%.5f", pixel);
                }
            }
            return String.valueOf(ProductUtils.getGeophysicalSampleAsLong((RasterDataNode)raster, (int)x, (int)y, (int)level));
        }
        return "NaN";
    }

    private boolean isPixelValid(RasterDataNode raster, int pixelX, int pixelY, int level) {
        if (raster.isValidMaskUsed()) {
            PlanarImage image = ImageManager.getInstance().getValidMaskImage(raster, level);
            Raster data = this.getRasterTile(image, pixelX, pixelY);
            return data.getSample(pixelX, pixelY, 0) != 0;
        }
        return true;
    }

    private Raster getRasterTile(PlanarImage image, int pixelX, int pixelY) {
        int tileX = image.XToTileX(pixelX);
        int tileY = image.YToTileY(pixelY);
        return image.getTile(tileX, tileY);
    }

    private boolean coordinatesAreInRasterBounds(RasterDataNode raster, int x, int y, int level) {
        RenderedImage levelImage = raster.getSourceImage().getImage(level);
        return x >= 0 && y >= 0 && x < levelImage.getWidth() && y < levelImage.getHeight();
    }

    private int floor(double value) {
        if (Double.isNaN(value)) {
            return -1;
        }
        return (int)Math.floor(value);
    }

    private boolean isSampleValueAvailableInScene() {
        return this.levelZeroSceneX >= 0 && this.levelZeroSceneY >= 0 && this.levelZeroSceneX < this.currentProduct.getSceneRasterWidth() && this.levelZeroSceneY < this.currentProduct.getSceneRasterHeight();
    }

    void clearProductNodeRefs() {
        this.currentProduct = null;
        this.currentRaster = null;
        this.currentView = null;
        this.currentFlagBands = new Band[0];
    }
}

