/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import com.bc.ceres.core.Assert;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.nodes.Bundle;
import org.esa.snap.rcp.nodes.PNGroup;
import org.esa.snap.rcp.nodes.PNNode;
import org.openide.nodes.Node;

abstract class PNGGroup<T extends ProductNode>
extends PNGroup<T> {
    private final String displayName;
    private final ProductNodeGroup<T> group;

    protected PNGGroup(String displayName, ProductNodeGroup<T> group) {
        Assert.notNull(group, (String)"group");
        this.displayName = displayName;
        this.group = group;
    }

    @Override
    public Product getProduct() {
        return this.group.getProduct();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    boolean isDirectChild(ProductNode productNode) {
        int nodeCount = this.group.getNodeCount();
        for (int i = 0; i < nodeCount; ++i) {
            if (this.group.get(i) != productNode) continue;
            return true;
        }
        return false;
    }

    protected boolean createKeys(List<T> list) {
        int nodeCount = this.group.getNodeCount();
        for (int i = 0; i < nodeCount; ++i) {
            list.add(this.group.get(i));
        }
        return true;
    }

    protected abstract Node createNodeForKey(T var1);

    public static class ME
    extends PNGGroup<MetadataElement> {
        public ME(ProductNodeGroup<MetadataElement> group) {
            super(Bundle.LBL_MetadataGroupName(), group);
        }

        protected PNNode createNodeForKey(MetadataElement key) {
            return new PNNode.ME(key);
        }
    }

    public static class IC
    extends PNGGroup<IndexCoding> {
        public IC(ProductNodeGroup<IndexCoding> group) {
            super(Bundle.LBL_IndexCodingGroupName(), group);
        }

        protected PNNode createNodeForKey(IndexCoding key) {
            return new PNNode.IC(key);
        }
    }

    public static class FC
    extends PNGGroup<FlagCoding> {
        public FC(ProductNodeGroup<FlagCoding> group) {
            super(Bundle.LBL_FlagCodingGroupName(), group);
        }

        protected PNNode createNodeForKey(FlagCoding key) {
            return new PNNode.FC(key);
        }
    }

    public static class M
    extends PNGGroup<Mask> {
        public M(ProductNodeGroup<Mask> group) {
            super(Bundle.LBL_MaskGroupName(), group);
        }

        protected PNNode createNodeForKey(Mask key) {
            return new PNNode.M(key);
        }
    }

    public static class VDN
    extends PNGGroup<VectorDataNode> {
        public VDN(ProductNodeGroup<VectorDataNode> group) {
            super(Bundle.LBL_VectorDataGroupName(), group);
        }

        protected PNNode createNodeForKey(VectorDataNode key) {
            return new PNNode.VDN(key);
        }
    }

    public static class TPG
    extends PNGGroup<TiePointGrid> {
        private final Product product;
        private final ProductNodeGroup<TiePointGrid> group;

        public TPG(String displayName, ProductNodeGroup<TiePointGrid> group, Product product) {
            super(displayName, group);
            this.product = product;
            this.group = group;
        }

        protected PNNode createNodeForKey(TiePointGrid key) {
            return new PNNode.TPG(key);
        }

        @Override
        void refresh() {
            this.refreshGroup();
            super.refresh();
        }

        private void refreshGroup() {
            Product.AutoGrouping autoGrouping;
            ProductNodeGroup productTiePointGridGroup = this.product.getTiePointGridGroup();
            if (this.group != productTiePointGridGroup && (autoGrouping = this.product.getAutoGrouping()) != null) {
                int groupIndex = autoGrouping.indexOf(this.group.getDisplayName());
                this.group.removeAll();
                for (int i = 0; i < productTiePointGridGroup.getNodeCount(); ++i) {
                    TiePointGrid tiePointGrid = (TiePointGrid)productTiePointGridGroup.get(i);
                    if (autoGrouping.indexOf(tiePointGrid.getName()) != groupIndex) continue;
                    this.group.add((ProductNode)tiePointGrid);
                }
            }
        }

        @Override
        public Product getProduct() {
            return this.product;
        }
    }

    public static class B
    extends PNGGroup<Band> {
        private final Product product;
        private final ProductNodeGroup<Band> group;

        public B(String displayName, ProductNodeGroup<Band> group, Product product) {
            super(displayName, group);
            this.product = product;
            this.group = group;
        }

        protected PNNode createNodeForKey(Band key) {
            return new PNNode.B(key);
        }

        @Override
        void refresh() {
            this.refreshGroup();
            super.refresh();
        }

        private void refreshGroup() {
            Product.AutoGrouping autoGrouping;
            ProductNodeGroup productBandGroup = this.product.getBandGroup();
            if (this.group != productBandGroup && (autoGrouping = this.product.getAutoGrouping()) != null) {
                int groupIndex = autoGrouping.indexOf(this.group.getDisplayName());
                this.group.removeAll();
                for (int i = 0; i < productBandGroup.getNodeCount(); ++i) {
                    Band band = (Band)productBandGroup.get(i);
                    if (autoGrouping.indexOf(band.getName()) != groupIndex) continue;
                    this.group.add((ProductNode)band);
                }
            }
        }

        @Override
        public Product getProduct() {
            return this.product;
        }
    }
}

