/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nav;

import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.DefaultLayerCanvasModel;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glayer.swing.LayerCanvasModel;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.ViewportListener;
import com.bc.ceres.grender.support.DefaultViewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import org.esa.snap.rcp.windows.NavigationTopComponent;
import org.esa.snap.ui.product.ProductSceneView;

public class NavigationCanvas
extends JPanel {
    private final NavigationTopComponent navigationWindow;
    private LayerCanvas thumbnailCanvas;
    private static final DefaultLayerCanvasModel NULL_MODEL = new DefaultLayerCanvasModel((Layer)new CollectionLayer(), (Viewport)new DefaultViewport());
    private ObservedViewportHandler observedViewportHandler;
    private Rectangle2D moveSliderRect;
    private boolean adjustingObservedViewport;
    private boolean debug = false;

    public NavigationCanvas(NavigationTopComponent navigationWindow) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.navigationWindow = navigationWindow;
        this.thumbnailCanvas = new LayerCanvas();
        this.thumbnailCanvas.setBackground(ProductSceneView.DEFAULT_IMAGE_BACKGROUND_COLOR);
        this.thumbnailCanvas.setLayerFilter(new LayerFilter(){

            public boolean accept(Layer layer) {
                return layer instanceof ImageLayer;
            }
        });
        this.thumbnailCanvas.addOverlay(new LayerCanvas.Overlay(){

            public void paintOverlay(LayerCanvas canvas, Rendering rendering) {
                if (NavigationCanvas.this.moveSliderRect != null && !NavigationCanvas.this.moveSliderRect.isEmpty()) {
                    Graphics2D g = rendering.getGraphics();
                    g.setColor(new Color(NavigationCanvas.this.getForeground().getRed(), NavigationCanvas.this.getForeground().getGreen(), NavigationCanvas.this.getForeground().getBlue(), 82));
                    Rectangle bounds = NavigationCanvas.this.moveSliderRect.getBounds();
                    g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    g.setColor(NavigationCanvas.this.getForeground());
                    g.draw3DRect(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2, true);
                    g.draw3DRect(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
            }
        });
        this.add((Component)this.thumbnailCanvas, "Center");
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.observedViewportHandler = new ObservedViewportHandler();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.thumbnailCanvas.getViewport().setViewBounds(new Rectangle(x, y, width, height));
        this.thumbnailCanvas.zoomAll();
        this.updateMoveSliderRect();
    }

    @Override
    public void setBorder(Border border) {
    }

    public void handleViewChanged(ProductSceneView oldView, ProductSceneView newView) {
        Viewport observedViewport;
        if (this.debug) {
            System.out.println("NavigationCanvas.handleViewChanged(): " + System.currentTimeMillis());
            System.out.println("  oldView = " + (oldView == null ? "null" : oldView.getSceneName()));
            System.out.println("  newView = " + (newView == null ? "null" : newView.getSceneName()));
        }
        if (oldView != null) {
            observedViewport = oldView.getLayerCanvas().getViewport();
            observedViewport.removeListener((ViewportListener)this.observedViewportHandler);
        }
        if (newView != null) {
            observedViewport = newView.getLayerCanvas().getViewport();
            observedViewport.addListener((ViewportListener)this.observedViewportHandler);
            Rectangle bounds = this.getBounds().isEmpty() ? new Rectangle(0, 0, 100, 100) : this.getBounds();
            DefaultViewport thumbnailViewport = new DefaultViewport(bounds, observedViewport.isModelYAxisDown());
            thumbnailViewport.setOrientation(observedViewport.getOrientation());
            DefaultLayerCanvasModel thumbnailCanvasModel = new DefaultLayerCanvasModel(newView.getRootLayer(), (Viewport)thumbnailViewport);
            this.thumbnailCanvas.setModel((LayerCanvasModel)thumbnailCanvasModel);
            this.thumbnailCanvas.zoomAll();
        } else {
            this.thumbnailCanvas.setModel((LayerCanvasModel)NULL_MODEL);
        }
        this.updateMoveSliderRect();
    }

    private void updateMoveSliderRect() {
        Viewport viewport;
        ProductSceneView currentView = this.getNavigationWindow().getCurrentView();
        if (currentView != null) {
            viewport = currentView.getLayerCanvas().getViewport();
            Rectangle viewBounds = viewport.getViewBounds();
            AffineTransform m2vTN = this.thumbnailCanvas.getViewport().getModelToViewTransform();
            AffineTransform v2mVP = viewport.getViewToModelTransform();
            this.moveSliderRect = m2vTN.createTransformedShape(v2mVP.createTransformedShape(viewBounds)).getBounds2D();
        } else {
            this.moveSliderRect = new Rectangle2D.Double();
        }
        if (this.debug) {
            System.out.println("NavigationCanvas.updateMoveSliderRect(): " + System.currentTimeMillis());
            if (currentView != null) {
                viewport = currentView.getLayerCanvas().getViewport();
                System.out.println("  currentView    = " + currentView.getSceneName() + ", viewBounds = " + viewport.getViewBounds() + ", viewBounds = " + viewport.getViewBounds());
            } else {
                System.out.println("  currentView    = null");
            }
            System.out.println("  moveSliderRect = " + this.moveSliderRect);
        }
        this.repaint();
    }

    private void handleMoveSliderRectChanged() {
        ProductSceneView view = this.getNavigationWindow().getCurrentView();
        if (view != null) {
            this.adjustingObservedViewport = true;
            Point2D.Double location = new Point2D.Double(this.moveSliderRect.getMinX(), this.moveSliderRect.getMinY());
            this.thumbnailCanvas.getViewport().getViewToModelTransform().transform(location, location);
            this.getNavigationWindow().setModelOffset(((Point2D)location).getX(), ((Point2D)location).getY());
            this.adjustingObservedViewport = false;
        }
    }

    private NavigationTopComponent getNavigationWindow() {
        return this.navigationWindow;
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private Point pickPoint;
        private Point sliderPoint;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pickPoint = e.getPoint();
            if (!NavigationCanvas.this.moveSliderRect.contains(this.pickPoint)) {
                int x1 = this.pickPoint.x - ((NavigationCanvas)NavigationCanvas.this).moveSliderRect.getBounds().width / 2;
                int y1 = this.pickPoint.y - ((NavigationCanvas)NavigationCanvas.this).moveSliderRect.getBounds().height / 2;
                NavigationCanvas.this.moveSliderRect.setRect(x1, y1, NavigationCanvas.this.moveSliderRect.getWidth(), NavigationCanvas.this.moveSliderRect.getHeight());
                NavigationCanvas.this.repaint();
            }
            this.sliderPoint = NavigationCanvas.this.moveSliderRect.getBounds().getLocation();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            NavigationCanvas.this.repaint();
            NavigationCanvas.this.handleMoveSliderRectChanged();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x1 = this.sliderPoint.x + (e.getX() - this.pickPoint.x);
            int y1 = this.sliderPoint.y + (e.getY() - this.pickPoint.y);
            NavigationCanvas.this.moveSliderRect.setRect(x1, y1, NavigationCanvas.this.moveSliderRect.getWidth(), NavigationCanvas.this.moveSliderRect.getHeight());
            NavigationCanvas.this.repaint();
            NavigationCanvas.this.handleMoveSliderRectChanged();
        }
    }

    private class ObservedViewportHandler
    implements ViewportListener {
        private ObservedViewportHandler() {
        }

        public void handleViewportChanged(Viewport observedViewport, boolean orientationChanged) {
            if (!NavigationCanvas.this.adjustingObservedViewport) {
                if (orientationChanged) {
                    NavigationCanvas.this.thumbnailCanvas.getViewport().setOrientation(observedViewport.getOrientation());
                    NavigationCanvas.this.thumbnailCanvas.zoomAll();
                }
                NavigationCanvas.this.updateMoveSliderRect();
            }
        }
    }
}

