/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.metadata;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.openide.awt.HtmlRenderer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

class MetadataOutlineCellRenderer
extends DefaultOutlineCellRenderer {
    private static final Color VERY_LIGHT_GRAY = new Color(236, 236, 236);
    protected boolean centered = System.getProperty("os.name").toLowerCase().indexOf("windows") != 0;

    MetadataOutlineCellRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = null;
        Object valueToDisplay = value;
        if (value instanceof Node.Property) {
            try {
                valueToDisplay = ((Node.Property)value).getValue();
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (valueToDisplay != null) {
            TableCellRenderer renderer = table.getDefaultRenderer(valueToDisplay.getClass());
            if (renderer != null) {
                cell = renderer.getTableCellRendererComponent(table, valueToDisplay, isSelected, hasFocus, row, column);
            }
        } else {
            cell = super.getTableCellRendererComponent(table, valueToDisplay, isSelected, hasFocus, row, column);
        }
        if (cell != null) {
            if (cell instanceof HtmlRenderer.Renderer) {
                ((HtmlRenderer.Renderer)cell).setCentered(this.centered);
                ((HtmlRenderer.Renderer)cell).setIndent(5);
            } else if (cell instanceof DefaultTableCellRenderer.UIResource) {
                if (this.centered) {
                    ((DefaultTableCellRenderer.UIResource)cell).setHorizontalAlignment(0);
                } else {
                    ((DefaultTableCellRenderer.UIResource)cell).setHorizontalAlignment(2);
                }
            }
            Color foregroundColor = table.getForeground();
            cell.setForeground(foregroundColor);
            cell.setBackground(row % 2 == 0 ? Color.WHITE : VERY_LIGHT_GRAY);
            if (isSelected) {
                cell.setBackground(table.getSelectionBackground());
            }
        }
        return cell;
    }
}

