/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.LayerUtils;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class LayerTreeModel
implements TreeModel {
    private final Layer rootLayer;
    private final WeakHashMap<TreeModelListener, Object> treeModelListeners;

    LayerTreeModel(Layer rootLayer) {
        this.rootLayer = rootLayer;
        this.rootLayer.addListener((com.bc.ceres.glayer.LayerListener)new LayerListener());
        this.treeModelListeners = new WeakHashMap();
    }

    @Override
    public Object getRoot() {
        return this.rootLayer;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((Layer)parent).getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((Layer)parent).getChildren().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((Layer)node).getChildren().isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        String newName;
        Layer layer;
        String oldName;
        if (newValue instanceof String && !(oldName = (layer = (Layer)path.getLastPathComponent()).getName()).equals(newName = (String)newValue)) {
            layer.setName(newName);
            this.fireTreeNodeChanged(layer);
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((Layer)parent).getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.put(l, "");
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public Layer getRootLayer() {
        return this.rootLayer;
    }

    protected void fireTreeNodeChanged(Layer layer) {
        TreeModelEvent event = this.createTreeModelEvent(layer);
        for (TreeModelListener treeModelListener : this.treeModelListeners.keySet()) {
            treeModelListener.treeNodesChanged(event);
        }
    }

    protected void fireTreeStructureChanged(Layer parentLayer) {
        TreeModelEvent event = this.createTreeModelEvent(parentLayer);
        for (TreeModelListener treeModelListener : this.treeModelListeners.keySet()) {
            treeModelListener.treeStructureChanged(event);
        }
    }

    protected void fireTreeNodesInserted(Layer parentLayer) {
        TreeModelEvent event = this.createTreeModelEvent(parentLayer);
        for (TreeModelListener treeModelListener : this.treeModelListeners.keySet()) {
            treeModelListener.treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(Layer parentLayer) {
        TreeModelEvent event = this.createTreeModelEvent(parentLayer);
        for (TreeModelListener treeModelListener : this.treeModelListeners.keySet()) {
            treeModelListener.treeNodesRemoved(event);
        }
    }

    private TreeModelEvent createTreeModelEvent(Layer layer) {
        Object[] parentPath = LayerUtils.getLayerPath((Layer)this.rootLayer, (Layer)layer);
        return new TreeModelEvent((Object)this, parentPath);
    }

    private class LayerListener
    extends AbstractLayerListener {
        private LayerListener() {
        }

        public void handleLayerPropertyChanged(Layer layer, PropertyChangeEvent event) {
            SwingUtilities.invokeLater(() -> LayerTreeModel.this.fireTreeNodeChanged(layer));
        }

        public void handleLayerDataChanged(Layer layer, Rectangle2D modelRegion) {
            SwingUtilities.invokeLater(() -> LayerTreeModel.this.fireTreeNodeChanged(layer));
        }

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
            SwingUtilities.invokeLater(() -> LayerTreeModel.this.fireTreeStructureChanged(parentLayer));
        }

        public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
            SwingUtilities.invokeLater(() -> LayerTreeModel.this.fireTreeStructureChanged(parentLayer));
        }
    }
}

