/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.swing.selection.AbstractSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import java.util.WeakHashMap;
import org.esa.snap.rcp.layermanager.AbstractLayerTopComponent;
import org.esa.snap.rcp.layermanager.Bundle;
import org.esa.snap.rcp.layermanager.LayerManagerForm;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="LayerManagerTopComponent", iconBase="org/esa/snap/rcp/icons/LayerManager.png", persistenceType=0)
public class LayerManagerTopComponent
extends AbstractLayerTopComponent {
    private WeakHashMap<ProductSceneView, LayerManagerForm> layerManagerMap;
    private LayerManagerForm activeForm;
    private LayerSelectionContext selectionContext;

    @Override
    protected void initUI() {
        this.layerManagerMap = new WeakHashMap();
        this.selectionContext = new LayerSelectionContext();
        super.initUI();
    }

    @Override
    protected void viewClosed(ProductSceneView view) {
        this.layerManagerMap.remove(view);
    }

    @Override
    protected void viewSelectionChanged(ProductSceneView oldView, ProductSceneView newView) {
        this.realizeActiveForm();
    }

    @Override
    protected void layerSelectionChanged(Layer oldLayer, Layer selectedLayer) {
        if (this.activeForm != null) {
            this.activeForm.updateFormControl();
            this.selectionContext.fireSelectionChange((Selection)new DefaultSelection((Object[])new Layer[]{selectedLayer}));
        }
    }

    @Override
    protected String getTitle() {
        return Bundle.CTL_LayerManagerTopComponent_Name();
    }

    @Override
    protected String getHelpId() {
        return Bundle.CTL_LayerManagerTopComponent_HelpId();
    }

    private void realizeActiveForm() {
        if (this.getComponentCount() > 0) {
            this.remove(0);
        }
        if (this.getSelectedView() != null) {
            this.activeForm = this.getOrCreateActiveForm(this.getSelectedView());
            this.add(this.activeForm.getFormControl(), "Center");
        } else {
            this.activeForm = null;
        }
        this.validate();
        this.repaint();
    }

    protected LayerManagerForm getOrCreateActiveForm(ProductSceneView view) {
        if (this.layerManagerMap.containsKey(view)) {
            this.activeForm = this.layerManagerMap.get(view);
        } else {
            this.activeForm = new LayerManagerForm(this);
            this.layerManagerMap.put(view, this.activeForm);
        }
        return this.activeForm;
    }

    private class LayerSelectionContext
    extends AbstractSelectionContext {
        private LayerSelectionContext() {
        }

        public void setSelection(Selection selection) {
            Object selectedValue = selection.getSelectedValue();
            if (selectedValue instanceof Layer) {
                LayerManagerTopComponent.this.setSelectedLayer((Layer)selectedValue);
            }
        }

        public Selection getSelection() {
            Layer selectedLayer = LayerManagerTopComponent.this.getSelectedLayer();
            if (selectedLayer != null) {
                return new DefaultSelection((Object[])new Layer[]{selectedLayer});
            }
            return DefaultSelection.EMPTY;
        }

        protected void fireSelectionChange(Selection selection) {
            super.fireSelectionChange(selection);
        }
    }
}

