/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.ctxhelp;

import java.awt.Desktop;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.logging.Level;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.SystemUtils;

public class ContextWebSearch {
    private static final String DEFAULT_SEARCH = "http://www.google.com/search?q=";
    private static final String DEFAULT_QUERY = "ESA Sentinel Toolbox";
    private static final String CONFIG_FILENAME = "context-search.properties";
    private static ContextWebSearch instance;
    private final Properties config = new Properties();

    public static ContextWebSearch getDefault() {
        if (instance == null) {
            instance = new ContextWebSearch();
        }
        return instance;
    }

    public void searchForNode(ProductNode node) {
        String searchString = this.getSearch();
        String queryString = this.getQueryString(node);
        try {
            String search = searchString + URLEncoder.encode(queryString, "UTF-8");
            URI uri = URI.create(search);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.WARNING, "Failed to perform context search");
        }
    }

    public ContextWebSearch() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.SEVERE, "Failed to load context search configuration", e);
        }
    }

    private String getSearch() {
        return this.config.getProperty("search", DEFAULT_SEARCH);
    }

    private String getQuery() {
        return this.config.getProperty("query", DEFAULT_QUERY);
    }

    private String getQuery(String productType, String def) {
        return this.config.getProperty(String.format("products.%s.query", productType.replace(" ", "_")), def);
    }

    private String getQueryString(ProductNode node) {
        String productType;
        String contextTerms = this.getQuery();
        if (node == null) {
            return contextTerms;
        }
        Product product = node.getProduct();
        if (product != null && (productType = product.getProductType()) != null) {
            contextTerms = this.getQuery(productType, contextTerms);
        }
        String nodeName = node.getName();
        String[] nodeNameSplits = nodeName.split("[\\.\\_\\ \\-]");
        StringBuilder nodeNameTerms = new StringBuilder();
        for (String nodeNameSplit : nodeNameSplits) {
            if (nodeNameSplit.isEmpty() || !Character.isAlphabetic(nodeNameSplit.charAt(0))) continue;
            if (nodeNameTerms.length() > 0) {
                nodeNameTerms.append(" OR ");
            }
            nodeNameTerms.append(nodeNameSplit);
        }
        return contextTerms + " " + nodeNameTerms;
    }

    private void loadConfig() throws IOException {
        Path file = this.getConfigPath();
        this.config.load(new FileReader(file.toFile()));
    }

    private Path getConfigPath() throws IOException {
        Path file;
        FileSystem fs = FileSystems.getDefault();
        Path dir = SystemUtils.getAuxDataPath();
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (Files.notExists(file = fs.getPath(dir.toString(), CONFIG_FILENAME), new LinkOption[0])) {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(CONFIG_FILENAME);
            Files.copy(resourceAsStream, file, new CopyOption[0]);
        }
        return file;
    }
}

